// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dynamodbstreams.model



/**
 * Represents the input of a GetShardIterator operation.
 */
class GetShardIteratorRequest private constructor(builder: Builder) {
    /**
     * The sequence number of a stream record in the shard from which to start reading.
     */
    val sequenceNumber: kotlin.String? = builder.sequenceNumber
    /**
     * The identifier of the shard. The iterator will be returned for this shard ID.
     */
    val shardId: kotlin.String? = builder.shardId
    /**
     * Determines how the shard iterator is used to start reading stream records from the shard:
     * AT_SEQUENCE_NUMBER - Start reading exactly from the position denoted by a
     * specific sequence number.
     * AFTER_SEQUENCE_NUMBER - Start reading right after the position denoted by a
     * specific sequence number.
     * TRIM_HORIZON - Start reading at the last (untrimmed) stream record, which is
     * the oldest record in the shard. In DynamoDB Streams, there is a 24 hour limit on data retention.
     * Stream records whose age exceeds this limit are subject to removal (trimming) from the
     * stream.
     * LATEST - Start reading just after the most recent stream record in the
     * shard, so that you always read the most recent data in the shard.
     */
    val shardIteratorType: aws.sdk.kotlin.services.dynamodbstreams.model.ShardIteratorType? = builder.shardIteratorType
    /**
     * The Amazon Resource Name (ARN) for the stream.
     */
    val streamArn: kotlin.String? = builder.streamArn

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dynamodbstreams.model.GetShardIteratorRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetShardIteratorRequest(")
        append("sequenceNumber=$sequenceNumber,")
        append("shardId=$shardId,")
        append("shardIteratorType=$shardIteratorType,")
        append("streamArn=$streamArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = sequenceNumber?.hashCode() ?: 0
        result = 31 * result + (shardId?.hashCode() ?: 0)
        result = 31 * result + (shardIteratorType?.hashCode() ?: 0)
        result = 31 * result + (streamArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as GetShardIteratorRequest

        if (sequenceNumber != other.sequenceNumber) return false
        if (shardId != other.shardId) return false
        if (shardIteratorType != other.shardIteratorType) return false
        if (streamArn != other.streamArn) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dynamodbstreams.model.GetShardIteratorRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The sequence number of a stream record in the shard from which to start reading.
         */
        var sequenceNumber: kotlin.String? = null
        /**
         * The identifier of the shard. The iterator will be returned for this shard ID.
         */
        var shardId: kotlin.String? = null
        /**
         * Determines how the shard iterator is used to start reading stream records from the shard:
         * AT_SEQUENCE_NUMBER - Start reading exactly from the position denoted by a
         * specific sequence number.
         * AFTER_SEQUENCE_NUMBER - Start reading right after the position denoted by a
         * specific sequence number.
         * TRIM_HORIZON - Start reading at the last (untrimmed) stream record, which is
         * the oldest record in the shard. In DynamoDB Streams, there is a 24 hour limit on data retention.
         * Stream records whose age exceeds this limit are subject to removal (trimming) from the
         * stream.
         * LATEST - Start reading just after the most recent stream record in the
         * shard, so that you always read the most recent data in the shard.
         */
        var shardIteratorType: aws.sdk.kotlin.services.dynamodbstreams.model.ShardIteratorType? = null
        /**
         * The Amazon Resource Name (ARN) for the stream.
         */
        var streamArn: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dynamodbstreams.model.GetShardIteratorRequest) : this() {
            this.sequenceNumber = x.sequenceNumber
            this.shardId = x.shardId
            this.shardIteratorType = x.shardIteratorType
            this.streamArn = x.streamArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dynamodbstreams.model.GetShardIteratorRequest = GetShardIteratorRequest(this)
    }
}
