// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dynamodbstreams.model



/**
 * Represents the data for an attribute.
 * Each attribute value is described as a name-value pair.  The name is the data type, and the value is the data itself.
 * For more information, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes">Data Types in the
 * Amazon DynamoDB Developer Guide.
 */
sealed class AttributeValue {
    /**
     * An attribute of type Binary.  For example:
     * "B": "dGhpcyB0ZXh0IGlzIGJhc2U2NC1lbmNvZGVk"
     */
    data class B(val value: kotlin.ByteArray) : aws.sdk.kotlin.services.dynamodbstreams.model.AttributeValue() {

        override fun hashCode(): kotlin.Int {
            return value.contentHashCode()
        }

        override fun equals(other: kotlin.Any?): kotlin.Boolean {
            if (this === other) return true
            if (javaClass != other?.javaClass) return false

            other as B

            if (!value.contentEquals(other.value)) return false

            return true
        }
    }
    /**
     * An attribute of type Boolean.  For example:
     * "BOOL": true
     */
    data class Bool(val value: kotlin.Boolean) : aws.sdk.kotlin.services.dynamodbstreams.model.AttributeValue()
    /**
     * An attribute of type Binary Set.  For example:
     * "BS": &#91;"U3Vubnk=", "UmFpbnk=", "U25vd3k="&#93;
     */
    data class Bs(val value: List<ByteArray>) : aws.sdk.kotlin.services.dynamodbstreams.model.AttributeValue()
    /**
     * An attribute of type List.  For example:
     * "L": &#91; {"S": "Cookies"} , {"S": "Coffee"}, {"N", "3.14159"}&#93;
     */
    data class L(val value: List<AttributeValue>) : aws.sdk.kotlin.services.dynamodbstreams.model.AttributeValue()
    /**
     * An attribute of type Map.  For example:
     * "M": {"Name": {"S": "Joe"}, "Age": {"N": "35"}}
     */
    data class M(val value: Map<String, AttributeValue>) : aws.sdk.kotlin.services.dynamodbstreams.model.AttributeValue()
    /**
     * An attribute of type Number. For example:
     * "N": "123.45"
     * Numbers are sent across the network to DynamoDB as strings, to maximize compatibility across languages and libraries. However, DynamoDB treats them as number type attributes for mathematical operations.
     */
    data class N(val value: kotlin.String) : aws.sdk.kotlin.services.dynamodbstreams.model.AttributeValue()
    /**
     * An attribute of type Number Set.  For example:
     * "NS": &#91;"42.2", "-19", "7.5", "3.14"&#93;
     * Numbers are sent across the network to DynamoDB as strings, to maximize compatibility across languages and libraries. However, DynamoDB treats them as number type attributes for mathematical operations.
     */
    data class Ns(val value: List<String>) : aws.sdk.kotlin.services.dynamodbstreams.model.AttributeValue()
    /**
     * An attribute of type Null.  For example:
     * "NULL": true
     */
    data class Null(val value: kotlin.Boolean) : aws.sdk.kotlin.services.dynamodbstreams.model.AttributeValue()
    /**
     * An attribute of type  String. For example:
     * "S": "Hello"
     */
    data class S(val value: kotlin.String) : aws.sdk.kotlin.services.dynamodbstreams.model.AttributeValue()
    /**
     * An attribute of type String Set.  For example:
     * "SS": &#91;"Giraffe", "Hippo" ,"Zebra"&#93;
     */
    data class Ss(val value: List<String>) : aws.sdk.kotlin.services.dynamodbstreams.model.AttributeValue()
    object SdkUnknown : aws.sdk.kotlin.services.dynamodbstreams.model.AttributeValue()
}
