// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dynamodbstreams

import aws.sdk.kotlin.runtime.auth.credentials.CredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.client.AwsClientConfig
import aws.sdk.kotlin.runtime.config.AwsClientConfigLoadOptions
import aws.sdk.kotlin.runtime.config.fromEnvironment
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.services.dynamodbstreams.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.dynamodbstreams.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.operation.EndpointResolver
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucket
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucketOptions

/**
 * <fullname>Amazon DynamoDB</fullname>
 * Amazon DynamoDB Streams provides API actions for accessing streams and processing
 * stream records. To learn more about application development with Streams, see <a href="https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Streams.html">Capturing
 * Table Activity with DynamoDB Streams in the Amazon DynamoDB Developer
 * Guide.
 */
interface DynamoDbStreamsClient : SdkClient {

    override val serviceName: String
        get() = "DynamoDB Streams"
    /**
     * DynamoDbStreamsClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(sharedConfig: AwsClientConfig? = null, block: Config.Builder.() -> Unit = {}): DynamoDbStreamsClient {
            val config = Config.Builder().apply {
                region = sharedConfig?.region
                credentialsProvider = sharedConfig?.credentialsProvider
            }.apply(block).build()
            return DefaultDynamoDbStreamsClient(config)
        }

        operator fun invoke(config: Config): DynamoDbStreamsClient = DefaultDynamoDbStreamsClient(config)

        /**
         * Construct a [DynamoDbStreamsClient] by resolving the configuration from the current environment.
         * NOTE: If you are using multiple AWS service clients you may wish to share the configuration among them
         * by constructing a [aws.sdk.kotlin.runtime.client.AwsClientConfig] and passing it to each client at construction.
         */
        suspend fun fromEnvironment(block: AwsClientConfigLoadOptions.() -> Unit = {}): DynamoDbStreamsClient {
            val sharedConfig = AwsClientConfig.fromEnvironment(block)
            return DynamoDbStreamsClient(sharedConfig)
        }
    }

    class Config private constructor(builder: Builder): AwsClientConfig, HttpClientConfig, SdkClientConfig {
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = run {
            val strategyOptions = StandardRetryStrategyOptions.Default
            val tokenBucket = StandardRetryTokenBucket(StandardRetryTokenBucketOptions.Default)
            val delayer = ExponentialBackoffWithJitter(ExponentialBackoffWithJitterOptions.Default)
            StandardRetryStrategy(strategyOptions, tokenBucket, delayer)
        }
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc)
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Returns information about a stream, including the current status of the stream, its Amazon Resource Name (ARN), the composition of its shards, and its corresponding DynamoDB table.
     * You can call DescribeStream at a maximum rate of 10 times per second.
     * Each shard in the stream has a SequenceNumberRange associated with it. If the
     * SequenceNumberRange has a StartingSequenceNumber but no
     * EndingSequenceNumber, then the shard is still open (able to receive more stream
     * records). If both StartingSequenceNumber and EndingSequenceNumber
     * are present, then that shard is closed and can no longer receive more data.
     */
    suspend fun describeStream(input: DescribeStreamRequest): DescribeStreamResponse

    /**
     * Returns information about a stream, including the current status of the stream, its Amazon Resource Name (ARN), the composition of its shards, and its corresponding DynamoDB table.
     * You can call DescribeStream at a maximum rate of 10 times per second.
     * Each shard in the stream has a SequenceNumberRange associated with it. If the
     * SequenceNumberRange has a StartingSequenceNumber but no
     * EndingSequenceNumber, then the shard is still open (able to receive more stream
     * records). If both StartingSequenceNumber and EndingSequenceNumber
     * are present, then that shard is closed and can no longer receive more data.
     */
    suspend fun describeStream(block: DescribeStreamRequest.Builder.() -> Unit) = describeStream(DescribeStreamRequest.Builder().apply(block).build())

    /**
     * Retrieves the stream records from a given shard.
     * Specify a shard iterator using the ShardIterator parameter. The shard iterator
     * specifies the position in the shard from which you want to start reading stream records
     * sequentially. If there are no stream records available in the portion of the shard that the
     * iterator points to, GetRecords returns an empty list. Note that it might take
     * multiple calls to get to a portion of the shard that contains stream records.
     * GetRecords can retrieve a maximum of 1 MB of data or 1000 stream records,
     * whichever comes first.
     */
    suspend fun getRecords(input: GetRecordsRequest): GetRecordsResponse

    /**
     * Retrieves the stream records from a given shard.
     * Specify a shard iterator using the ShardIterator parameter. The shard iterator
     * specifies the position in the shard from which you want to start reading stream records
     * sequentially. If there are no stream records available in the portion of the shard that the
     * iterator points to, GetRecords returns an empty list. Note that it might take
     * multiple calls to get to a portion of the shard that contains stream records.
     * GetRecords can retrieve a maximum of 1 MB of data or 1000 stream records,
     * whichever comes first.
     */
    suspend fun getRecords(block: GetRecordsRequest.Builder.() -> Unit) = getRecords(GetRecordsRequest.Builder().apply(block).build())

    /**
     * Returns a shard iterator. A shard iterator provides information
     * about how to retrieve the stream records from within a shard.  Use
     * the shard iterator in a subsequent
     * GetRecords request to read the stream records
     * from the shard.
     * A shard iterator expires 15 minutes after it is returned to the requester.
     */
    suspend fun getShardIterator(input: GetShardIteratorRequest): GetShardIteratorResponse

    /**
     * Returns a shard iterator. A shard iterator provides information
     * about how to retrieve the stream records from within a shard.  Use
     * the shard iterator in a subsequent
     * GetRecords request to read the stream records
     * from the shard.
     * A shard iterator expires 15 minutes after it is returned to the requester.
     */
    suspend fun getShardIterator(block: GetShardIteratorRequest.Builder.() -> Unit) = getShardIterator(GetShardIteratorRequest.Builder().apply(block).build())

    /**
     * Returns an array of stream ARNs associated with the current account and endpoint. If the
     * TableName parameter is present, then ListStreams will return only the
     * streams ARNs for that table.
     * You can call ListStreams at a maximum rate of 5 times per second.
     */
    suspend fun listStreams(input: ListStreamsRequest): ListStreamsResponse

    /**
     * Returns an array of stream ARNs associated with the current account and endpoint. If the
     * TableName parameter is present, then ListStreams will return only the
     * streams ARNs for that table.
     * You can call ListStreams at a maximum rate of 5 times per second.
     */
    suspend fun listStreams(block: ListStreamsRequest.Builder.() -> Unit) = listStreams(ListStreamsRequest.Builder().apply(block).build())
}
