// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dynamodbstreams.model



/**
 * Represents the input of a `DescribeStream` operation.
 */
public class DescribeStreamRequest private constructor(builder: Builder) {
    /**
     * The shard ID of the first item that this operation will evaluate. Use the value that was returned for `LastEvaluatedShardId` in the previous operation.
     */
    public val exclusiveStartShardId: kotlin.String? = builder.exclusiveStartShardId
    /**
     * The maximum number of shard objects to return. The upper limit is 100.
     */
    public val limit: kotlin.Int? = builder.limit
    /**
     * The Amazon Resource Name (ARN) for the stream.
     */
    public val streamArn: kotlin.String? = builder.streamArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dynamodbstreams.model.DescribeStreamRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeStreamRequest(")
        append("exclusiveStartShardId=$exclusiveStartShardId,")
        append("limit=$limit,")
        append("streamArn=$streamArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = exclusiveStartShardId?.hashCode() ?: 0
        result = 31 * result + (limit ?: 0)
        result = 31 * result + (streamArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeStreamRequest

        if (exclusiveStartShardId != other.exclusiveStartShardId) return false
        if (limit != other.limit) return false
        if (streamArn != other.streamArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dynamodbstreams.model.DescribeStreamRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The shard ID of the first item that this operation will evaluate. Use the value that was returned for `LastEvaluatedShardId` in the previous operation.
         */
        public var exclusiveStartShardId: kotlin.String? = null
        /**
         * The maximum number of shard objects to return. The upper limit is 100.
         */
        public var limit: kotlin.Int? = null
        /**
         * The Amazon Resource Name (ARN) for the stream.
         */
        public var streamArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dynamodbstreams.model.DescribeStreamRequest) : this() {
            this.exclusiveStartShardId = x.exclusiveStartShardId
            this.limit = x.limit
            this.streamArn = x.streamArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dynamodbstreams.model.DescribeStreamRequest = DescribeStreamRequest(this)

        internal fun correctErrors(): Builder {
            if (streamArn == null) streamArn = ""
            return this
        }
    }
}
