// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dynamodbstreams.model



/**
 * A description of a unique event within a stream.
 */
public class Record private constructor(builder: Builder) {
    /**
     * The region in which the `GetRecords` request was received.
     */
    public val awsRegion: kotlin.String? = builder.awsRegion
    /**
     * The main body of the stream record, containing all of the DynamoDB-specific fields.
     */
    public val dynamodb: aws.sdk.kotlin.services.dynamodbstreams.model.StreamRecord? = builder.dynamodb
    /**
     * A globally unique identifier for the event that was recorded in this stream record.
     */
    public val eventId: kotlin.String? = builder.eventId
    /**
     * The type of data modification that was performed on the DynamoDB table:
     * + `INSERT` - a new item was added to the table.
     * + `MODIFY` - one or more of an existing item's attributes were modified.
     * + `REMOVE` - the item was deleted from the table
     */
    public val eventName: aws.sdk.kotlin.services.dynamodbstreams.model.OperationType? = builder.eventName
    /**
     * The AWS service from which the stream record originated. For DynamoDB Streams, this is `aws:dynamodb`.
     */
    public val eventSource: kotlin.String? = builder.eventSource
    /**
     * The version number of the stream record format. This number is updated whenever the structure of `Record` is modified.
     *
     * Client applications must not assume that `eventVersion` will remain at a particular value, as this number is subject to change at any time. In general, `eventVersion` will only increase as the low-level DynamoDB Streams API evolves.
     */
    public val eventVersion: kotlin.String? = builder.eventVersion
    /**
     * Items that are deleted by the Time to Live process after expiration have the following fields:
     * + Records&#91;&#93;.userIdentity.type"Service"
     * + Records&#91;&#93;.userIdentity.principalId"dynamodb.amazonaws.com"
     */
    public val userIdentity: aws.sdk.kotlin.services.dynamodbstreams.model.Identity? = builder.userIdentity

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dynamodbstreams.model.Record = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Record(")
        append("awsRegion=$awsRegion,")
        append("dynamodb=$dynamodb,")
        append("eventId=$eventId,")
        append("eventName=$eventName,")
        append("eventSource=$eventSource,")
        append("eventVersion=$eventVersion,")
        append("userIdentity=$userIdentity)")
    }

    override fun hashCode(): kotlin.Int {
        var result = awsRegion?.hashCode() ?: 0
        result = 31 * result + (dynamodb?.hashCode() ?: 0)
        result = 31 * result + (eventId?.hashCode() ?: 0)
        result = 31 * result + (eventName?.hashCode() ?: 0)
        result = 31 * result + (eventSource?.hashCode() ?: 0)
        result = 31 * result + (eventVersion?.hashCode() ?: 0)
        result = 31 * result + (userIdentity?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Record

        if (awsRegion != other.awsRegion) return false
        if (dynamodb != other.dynamodb) return false
        if (eventId != other.eventId) return false
        if (eventName != other.eventName) return false
        if (eventSource != other.eventSource) return false
        if (eventVersion != other.eventVersion) return false
        if (userIdentity != other.userIdentity) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dynamodbstreams.model.Record = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The region in which the `GetRecords` request was received.
         */
        public var awsRegion: kotlin.String? = null
        /**
         * The main body of the stream record, containing all of the DynamoDB-specific fields.
         */
        public var dynamodb: aws.sdk.kotlin.services.dynamodbstreams.model.StreamRecord? = null
        /**
         * A globally unique identifier for the event that was recorded in this stream record.
         */
        public var eventId: kotlin.String? = null
        /**
         * The type of data modification that was performed on the DynamoDB table:
         * + `INSERT` - a new item was added to the table.
         * + `MODIFY` - one or more of an existing item's attributes were modified.
         * + `REMOVE` - the item was deleted from the table
         */
        public var eventName: aws.sdk.kotlin.services.dynamodbstreams.model.OperationType? = null
        /**
         * The AWS service from which the stream record originated. For DynamoDB Streams, this is `aws:dynamodb`.
         */
        public var eventSource: kotlin.String? = null
        /**
         * The version number of the stream record format. This number is updated whenever the structure of `Record` is modified.
         *
         * Client applications must not assume that `eventVersion` will remain at a particular value, as this number is subject to change at any time. In general, `eventVersion` will only increase as the low-level DynamoDB Streams API evolves.
         */
        public var eventVersion: kotlin.String? = null
        /**
         * Items that are deleted by the Time to Live process after expiration have the following fields:
         * + Records&#91;&#93;.userIdentity.type"Service"
         * + Records&#91;&#93;.userIdentity.principalId"dynamodb.amazonaws.com"
         */
        public var userIdentity: aws.sdk.kotlin.services.dynamodbstreams.model.Identity? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dynamodbstreams.model.Record) : this() {
            this.awsRegion = x.awsRegion
            this.dynamodb = x.dynamodb
            this.eventId = x.eventId
            this.eventName = x.eventName
            this.eventSource = x.eventSource
            this.eventVersion = x.eventVersion
            this.userIdentity = x.userIdentity
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dynamodbstreams.model.Record = Record(this)

        /**
         * construct an [aws.sdk.kotlin.services.dynamodbstreams.model.StreamRecord] inside the given [block]
         */
        public fun dynamodb(block: aws.sdk.kotlin.services.dynamodbstreams.model.StreamRecord.Builder.() -> kotlin.Unit) {
            this.dynamodb = aws.sdk.kotlin.services.dynamodbstreams.model.StreamRecord.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.dynamodbstreams.model.Identity] inside the given [block]
         */
        public fun userIdentity(block: aws.sdk.kotlin.services.dynamodbstreams.model.Identity.Builder.() -> kotlin.Unit) {
            this.userIdentity = aws.sdk.kotlin.services.dynamodbstreams.model.Identity.invoke(block)
        }
    }
}
