// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dynamodbstreams.model

import aws.smithy.kotlin.runtime.ServiceErrorMetadata

/**
 * The operation attempted to read past the oldest stream record in a shard.
 *
 * In DynamoDB Streams, there is a 24 hour limit on data retention. Stream records whose age exceeds this limit are subject to removal (trimming) from the stream. You might receive a TrimmedDataAccessException if:
 * + You request a shard iterator with a sequence number older than the trim point (24 hours).
 * + You obtain a shard iterator, but before you use the iterator in a `GetRecords` request, a stream record in the shard exceeds the 24 hour period and is trimmed. This causes the iterator to access a record that no longer exists.
 */
public class TrimmedDataAccessException private constructor(builder: Builder) : DynamoDbStreamsException(builder.message) {

    init {
        sdkErrorMetadata.attributes[ServiceErrorMetadata.ErrorType] = ErrorType.Client
    }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dynamodbstreams.model.TrimmedDataAccessException = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TrimmedDataAccessException(")
        append("message=$message")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = message?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TrimmedDataAccessException

        if (message != other.message) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dynamodbstreams.model.TrimmedDataAccessException = Builder(this).apply(block).build()

    public class Builder {
        /**
         * "The data you are trying to access has been trimmed.
         */
        public var message: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dynamodbstreams.model.TrimmedDataAccessException) : this() {
            this.message = x.message
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dynamodbstreams.model.TrimmedDataAccessException = TrimmedDataAccessException(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
