// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dynamodbstreams.model



/**
 * Represents all of the data describing a particular stream.
 */
public class Stream private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) for the stream.
     */
    public val streamArn: kotlin.String? = builder.streamArn
    /**
     * A timestamp, in ISO 8601 format, for this stream.
     *
     * Note that `LatestStreamLabel` is not a unique identifier for the stream, because it is possible that a stream from another table might have the same timestamp. However, the combination of the following three elements is guaranteed to be unique:
     * + the Amazon Web Services customer ID.
     * + the table name
     * + the `StreamLabel`
     */
    public val streamLabel: kotlin.String? = builder.streamLabel
    /**
     * The DynamoDB table with which the stream is associated.
     */
    public val tableName: kotlin.String? = builder.tableName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dynamodbstreams.model.Stream = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Stream(")
        append("streamArn=$streamArn,")
        append("streamLabel=$streamLabel,")
        append("tableName=$tableName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = streamArn?.hashCode() ?: 0
        result = 31 * result + (streamLabel?.hashCode() ?: 0)
        result = 31 * result + (tableName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Stream

        if (streamArn != other.streamArn) return false
        if (streamLabel != other.streamLabel) return false
        if (tableName != other.tableName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dynamodbstreams.model.Stream = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) for the stream.
         */
        public var streamArn: kotlin.String? = null
        /**
         * A timestamp, in ISO 8601 format, for this stream.
         *
         * Note that `LatestStreamLabel` is not a unique identifier for the stream, because it is possible that a stream from another table might have the same timestamp. However, the combination of the following three elements is guaranteed to be unique:
         * + the Amazon Web Services customer ID.
         * + the table name
         * + the `StreamLabel`
         */
        public var streamLabel: kotlin.String? = null
        /**
         * The DynamoDB table with which the stream is associated.
         */
        public var tableName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dynamodbstreams.model.Stream) : this() {
            this.streamArn = x.streamArn
            this.streamLabel = x.streamLabel
            this.tableName = x.tableName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dynamodbstreams.model.Stream = Stream(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
