// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dynamodbstreams.model



/**
 * Represents the data for an attribute.
 *
 * Each attribute value is described as a name-value pair. The name is the data type, and the value is the data itself.
 *
 * For more information, see [Data Types](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.NamingRulesDataTypes.html#HowItWorks.DataTypes) in the *Amazon DynamoDB Developer Guide*.
 */
public sealed class AttributeValue {
    /**
     * An attribute of type Binary. For example:
     *
     * `"B": "dGhpcyB0ZXh0IGlzIGJhc2U2NC1lbmNvZGVk"`
     */
    public data class B(val value: kotlin.ByteArray) : aws.sdk.kotlin.services.dynamodbstreams.model.AttributeValue() {

        override fun hashCode(): kotlin.Int {
            return value.contentHashCode()
        }

        override fun equals(other: kotlin.Any?): kotlin.Boolean {
            if (this === other) return true
            if (other == null || this::class != other::class) return false

            other as B

            if (!value.contentEquals(other.value)) return false

            return true
        }
    }

    /**
     * An attribute of type Boolean. For example:
     *
     * `"BOOL": true`
     */
    public data class Bool(val value: kotlin.Boolean) : aws.sdk.kotlin.services.dynamodbstreams.model.AttributeValue() {
    }

    /**
     * An attribute of type Binary Set. For example:
     *
     * `"BS": ["U3Vubnk=", "UmFpbnk=", "U25vd3k="]`
     */
    public data class Bs(val value: List<kotlin.ByteArray>) : aws.sdk.kotlin.services.dynamodbstreams.model.AttributeValue() {
    }

    /**
     * An attribute of type List. For example:
     *
     * `"L": [ {"S": "Cookies"} , {"S": "Coffee"}, {"N": "3.14159"}]`
     */
    public data class L(val value: List<aws.sdk.kotlin.services.dynamodbstreams.model.AttributeValue>) : aws.sdk.kotlin.services.dynamodbstreams.model.AttributeValue() {
    }

    /**
     * An attribute of type Map. For example:
     *
     * `"M": {"Name": {"S": "Joe"}, "Age": {"N": "35"}}`
     */
    public data class M(val value: Map<kotlin.String, aws.sdk.kotlin.services.dynamodbstreams.model.AttributeValue>) : aws.sdk.kotlin.services.dynamodbstreams.model.AttributeValue() {
    }

    /**
     * An attribute of type Number. For example:
     *
     * `"N": "123.45"`
     *
     * Numbers are sent across the network to DynamoDB as strings, to maximize compatibility across languages and libraries. However, DynamoDB treats them as number type attributes for mathematical operations.
     */
    public data class N(val value: kotlin.String) : aws.sdk.kotlin.services.dynamodbstreams.model.AttributeValue() {
    }

    /**
     * An attribute of type Number Set. For example:
     *
     * `"NS": ["42.2", "-19", "7.5", "3.14"]`
     *
     * Numbers are sent across the network to DynamoDB as strings, to maximize compatibility across languages and libraries. However, DynamoDB treats them as number type attributes for mathematical operations.
     */
    public data class Ns(val value: List<kotlin.String>) : aws.sdk.kotlin.services.dynamodbstreams.model.AttributeValue() {
    }

    /**
     * An attribute of type Null. For example:
     *
     * `"NULL": true`
     */
    public data class Null(val value: kotlin.Boolean) : aws.sdk.kotlin.services.dynamodbstreams.model.AttributeValue() {
    }

    /**
     * An attribute of type String. For example:
     *
     * `"S": "Hello"`
     */
    public data class S(val value: kotlin.String) : aws.sdk.kotlin.services.dynamodbstreams.model.AttributeValue() {
    }

    /**
     * An attribute of type String Set. For example:
     *
     * `"SS": ["Giraffe", "Hippo" ,"Zebra"]`
     */
    public data class Ss(val value: List<kotlin.String>) : aws.sdk.kotlin.services.dynamodbstreams.model.AttributeValue() {
    }

    public object SdkUnknown : aws.sdk.kotlin.services.dynamodbstreams.model.AttributeValue() {
    }

    /**
     * Casts this [AttributeValue] as a [B] and retrieves its [kotlin.ByteArray] value. Throws an exception if the [AttributeValue] is not a
     * [B].
     */
    public fun asB(): kotlin.ByteArray = (this as AttributeValue.B).value

    /**
     * Casts this [AttributeValue] as a [B] and retrieves its [kotlin.ByteArray] value. Returns null if the [AttributeValue] is not a [B].
     */
    public fun asBOrNull(): kotlin.ByteArray? = (this as? AttributeValue.B)?.value

    /**
     * Casts this [AttributeValue] as a [Bool] and retrieves its [kotlin.Boolean] value. Throws an exception if the [AttributeValue] is not a
     * [Bool].
     */
    public fun asBool(): kotlin.Boolean = (this as AttributeValue.Bool).value

    /**
     * Casts this [AttributeValue] as a [Bool] and retrieves its [kotlin.Boolean] value. Returns null if the [AttributeValue] is not a [Bool].
     */
    public fun asBoolOrNull(): kotlin.Boolean? = (this as? AttributeValue.Bool)?.value

    /**
     * Casts this [AttributeValue] as a [Bs] and retrieves its [List<kotlin.ByteArray>] value. Throws an exception if the [AttributeValue] is not a
     * [Bs].
     */
    public fun asBs(): List<kotlin.ByteArray> = (this as AttributeValue.Bs).value

    /**
     * Casts this [AttributeValue] as a [Bs] and retrieves its [List<kotlin.ByteArray>] value. Returns null if the [AttributeValue] is not a [Bs].
     */
    public fun asBsOrNull(): List<kotlin.ByteArray>? = (this as? AttributeValue.Bs)?.value

    /**
     * Casts this [AttributeValue] as a [L] and retrieves its [List<aws.sdk.kotlin.services.dynamodbstreams.model.AttributeValue>] value. Throws an exception if the [AttributeValue] is not a
     * [L].
     */
    public fun asL(): List<aws.sdk.kotlin.services.dynamodbstreams.model.AttributeValue> = (this as AttributeValue.L).value

    /**
     * Casts this [AttributeValue] as a [L] and retrieves its [List<aws.sdk.kotlin.services.dynamodbstreams.model.AttributeValue>] value. Returns null if the [AttributeValue] is not a [L].
     */
    public fun asLOrNull(): List<aws.sdk.kotlin.services.dynamodbstreams.model.AttributeValue>? = (this as? AttributeValue.L)?.value

    /**
     * Casts this [AttributeValue] as a [M] and retrieves its [Map<kotlin.String, aws.sdk.kotlin.services.dynamodbstreams.model.AttributeValue>] value. Throws an exception if the [AttributeValue] is not a
     * [M].
     */
    public fun asM(): Map<kotlin.String, aws.sdk.kotlin.services.dynamodbstreams.model.AttributeValue> = (this as AttributeValue.M).value

    /**
     * Casts this [AttributeValue] as a [M] and retrieves its [Map<kotlin.String, aws.sdk.kotlin.services.dynamodbstreams.model.AttributeValue>] value. Returns null if the [AttributeValue] is not a [M].
     */
    public fun asMOrNull(): Map<kotlin.String, aws.sdk.kotlin.services.dynamodbstreams.model.AttributeValue>? = (this as? AttributeValue.M)?.value

    /**
     * Casts this [AttributeValue] as a [N] and retrieves its [kotlin.String] value. Throws an exception if the [AttributeValue] is not a
     * [N].
     */
    public fun asN(): kotlin.String = (this as AttributeValue.N).value

    /**
     * Casts this [AttributeValue] as a [N] and retrieves its [kotlin.String] value. Returns null if the [AttributeValue] is not a [N].
     */
    public fun asNOrNull(): kotlin.String? = (this as? AttributeValue.N)?.value

    /**
     * Casts this [AttributeValue] as a [Ns] and retrieves its [List<kotlin.String>] value. Throws an exception if the [AttributeValue] is not a
     * [Ns].
     */
    public fun asNs(): List<kotlin.String> = (this as AttributeValue.Ns).value

    /**
     * Casts this [AttributeValue] as a [Ns] and retrieves its [List<kotlin.String>] value. Returns null if the [AttributeValue] is not a [Ns].
     */
    public fun asNsOrNull(): List<kotlin.String>? = (this as? AttributeValue.Ns)?.value

    /**
     * Casts this [AttributeValue] as a [Null] and retrieves its [kotlin.Boolean] value. Throws an exception if the [AttributeValue] is not a
     * [Null].
     */
    public fun asNull(): kotlin.Boolean = (this as AttributeValue.Null).value

    /**
     * Casts this [AttributeValue] as a [Null] and retrieves its [kotlin.Boolean] value. Returns null if the [AttributeValue] is not a [Null].
     */
    public fun asNullOrNull(): kotlin.Boolean? = (this as? AttributeValue.Null)?.value

    /**
     * Casts this [AttributeValue] as a [S] and retrieves its [kotlin.String] value. Throws an exception if the [AttributeValue] is not a
     * [S].
     */
    public fun asS(): kotlin.String = (this as AttributeValue.S).value

    /**
     * Casts this [AttributeValue] as a [S] and retrieves its [kotlin.String] value. Returns null if the [AttributeValue] is not a [S].
     */
    public fun asSOrNull(): kotlin.String? = (this as? AttributeValue.S)?.value

    /**
     * Casts this [AttributeValue] as a [Ss] and retrieves its [List<kotlin.String>] value. Throws an exception if the [AttributeValue] is not a
     * [Ss].
     */
    public fun asSs(): List<kotlin.String> = (this as AttributeValue.Ss).value

    /**
     * Casts this [AttributeValue] as a [Ss] and retrieves its [List<kotlin.String>] value. Returns null if the [AttributeValue] is not a [Ss].
     */
    public fun asSsOrNull(): List<kotlin.String>? = (this as? AttributeValue.Ss)?.value
}
