/*
 * Decompiled with CFR 0.152.
 */
package aws.sdk.kotlin.services.dynamodbstreams.endpoints;

import aws.sdk.kotlin.runtime.endpoint.AuthScheme;
import aws.sdk.kotlin.runtime.endpoint.AuthSchemeKt;
import aws.sdk.kotlin.runtime.endpoint.functions.PartitionConfig;
import aws.sdk.kotlin.services.dynamodbstreams.endpoints.EndpointParameters;
import aws.sdk.kotlin.services.dynamodbstreams.endpoints.internal.PartitionsKt;
import aws.smithy.kotlin.runtime.client.endpoints.Endpoint;
import aws.smithy.kotlin.runtime.client.endpoints.EndpointProvider;
import aws.smithy.kotlin.runtime.client.endpoints.EndpointProviderException;
import aws.smithy.kotlin.runtime.net.Url;
import aws.smithy.kotlin.runtime.util.Attributes;
import aws.smithy.kotlin.runtime.util.AttributesBuilder;
import aws.smithy.kotlin.runtime.util.ValuesMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0019\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\b\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\t"}, d2={"Laws/sdk/kotlin/services/dynamodbstreams/endpoints/DefaultEndpointProvider;", "Laws/smithy/kotlin/runtime/client/endpoints/EndpointProvider;", "Laws/sdk/kotlin/services/dynamodbstreams/endpoints/EndpointParameters;", "Laws/sdk/kotlin/services/dynamodbstreams/endpoints/EndpointProvider;", "()V", "resolveEndpoint", "Laws/smithy/kotlin/runtime/client/endpoints/Endpoint;", "params", "(Laws/sdk/kotlin/services/dynamodbstreams/endpoints/EndpointParameters;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "dynamodbstreams"})
@SourceDebugExtension(value={"SMAP\nDefaultEndpointProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultEndpointProvider.kt\naws/sdk/kotlin/services/dynamodbstreams/endpoints/DefaultEndpointProvider\n+ 2 Attributes.kt\naws/smithy/kotlin/runtime/util/AttributesKt\n*L\n1#1,150:1\n191#2:151\n174#2:152\n*S KotlinDebug\n*F\n+ 1 DefaultEndpointProvider.kt\naws/sdk/kotlin/services/dynamodbstreams/endpoints/DefaultEndpointProvider\n*L\n93#1:151\n93#1:152\n*E\n"})
public final class DefaultEndpointProvider
implements EndpointProvider<EndpointParameters> {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public Object resolveEndpoint(@NotNull EndpointParameters params, @NotNull Continuation<? super Endpoint> $completion) {
        if (params.getEndpoint() != null) {
            if (Intrinsics.areEqual((Object)params.getUseFips(), (Object)Boxing.boxBoolean((boolean)true))) {
                throw new EndpointProviderException("Invalid Configuration: FIPS and custom endpoint are not supported");
            }
            if (Intrinsics.areEqual((Object)params.getUseDualStack(), (Object)Boxing.boxBoolean((boolean)true))) {
                throw new EndpointProviderException("Invalid Configuration: Dualstack and custom endpoint are not supported");
            }
            return new Endpoint(Url.Companion.parse(params.getEndpoint()), null, 2, null);
        }
        if (params.getRegion() != null) {
            DefaultEndpointProvider $this$resolveEndpoint_u24lambda_u241 = this;
            boolean bl = false;
            PartitionConfig partitionResult = PartitionsKt.partition(params.getRegion());
            if (partitionResult != null) {
                if (Intrinsics.areEqual((Object)params.getUseFips(), (Object)Boxing.boxBoolean((boolean)true)) && Intrinsics.areEqual((Object)params.getUseDualStack(), (Object)Boxing.boxBoolean((boolean)true))) {
                    if (Intrinsics.areEqual((Object)Boxing.boxBoolean((boolean)true), (Object)partitionResult.getSupportsFIPS()) && Intrinsics.areEqual((Object)Boxing.boxBoolean((boolean)true), (Object)partitionResult.getSupportsDualStack())) {
                        return new Endpoint(Url.Companion.parse("https://streams.dynamodb-fips." + params.getRegion() + '.' + partitionResult.getDualStackDnsSuffix()), null, 2, null);
                    }
                    throw new EndpointProviderException("FIPS and DualStack are enabled, but this partition does not support one or both");
                }
                if (Intrinsics.areEqual((Object)params.getUseFips(), (Object)Boxing.boxBoolean((boolean)true))) {
                    if (Intrinsics.areEqual((Object)Boxing.boxBoolean((boolean)true), (Object)partitionResult.getSupportsFIPS())) {
                        if (Intrinsics.areEqual((Object)"aws-us-gov", (Object)partitionResult.getName())) {
                            return new Endpoint(Url.Companion.parse("https://streams.dynamodb." + params.getRegion() + ".amazonaws.com"), null, 2, null);
                        }
                        return new Endpoint(Url.Companion.parse("https://streams.dynamodb-fips." + params.getRegion() + '.' + partitionResult.getDnsSuffix()), null, 2, null);
                    }
                    throw new EndpointProviderException("FIPS is enabled but this partition does not support FIPS");
                }
                if (Intrinsics.areEqual((Object)params.getUseDualStack(), (Object)Boxing.boxBoolean((boolean)true))) {
                    if (Intrinsics.areEqual((Object)Boxing.boxBoolean((boolean)true), (Object)partitionResult.getSupportsDualStack())) {
                        return new Endpoint(Url.Companion.parse("https://streams.dynamodb." + params.getRegion() + '.' + partitionResult.getDualStackDnsSuffix()), null, 2, null);
                    }
                    throw new EndpointProviderException("DualStack is enabled but this partition does not support DualStack");
                }
                if (Intrinsics.areEqual((Object)params.getRegion(), (Object)"local")) {
                    void $this$resolveEndpoint_u24lambda_u241_u24lambda_u240;
                    AttributesBuilder attributesBuilder;
                    boolean $i$f$attributesOf = false;
                    boolean $i$f$mutableAttributesOf = false;
                    AttributesBuilder attributesBuilder2 = attributesBuilder = new AttributesBuilder();
                    ValuesMap valuesMap = null;
                    Url url = Url.Companion.parse("http://localhost:8000");
                    boolean bl2 = false;
                    $this$resolveEndpoint_u24lambda_u241_u24lambda_u240.to(AuthSchemeKt.getAuthSchemesAttributeKey(), (Object)CollectionsKt.listOf((Object)new AuthScheme.SigV4("dynamodb", false, "us-east-1")));
                    Unit unit = Unit.INSTANCE;
                    DefaultConstructorMarker defaultConstructorMarker = null;
                    int n = 2;
                    Attributes attributes = (Attributes)attributesBuilder.getAttributes();
                    ValuesMap valuesMap2 = valuesMap;
                    Url url2 = url;
                    return new Endpoint(url2, valuesMap2, attributes, n, defaultConstructorMarker);
                }
                if (Intrinsics.areEqual((Object)"aws", (Object)partitionResult.getName())) {
                    return new Endpoint(Url.Companion.parse("https://streams.dynamodb." + params.getRegion() + ".amazonaws.com"), null, 2, null);
                }
                if (Intrinsics.areEqual((Object)"aws-cn", (Object)partitionResult.getName())) {
                    return new Endpoint(Url.Companion.parse("https://streams.dynamodb." + params.getRegion() + ".amazonaws.com.cn"), null, 2, null);
                }
                if (Intrinsics.areEqual((Object)"aws-us-gov", (Object)partitionResult.getName())) {
                    return new Endpoint(Url.Companion.parse("https://streams.dynamodb." + params.getRegion() + ".amazonaws.com"), null, 2, null);
                }
                if (Intrinsics.areEqual((Object)"aws-iso", (Object)partitionResult.getName())) {
                    return new Endpoint(Url.Companion.parse("https://streams.dynamodb." + params.getRegion() + ".c2s.ic.gov"), null, 2, null);
                }
                if (Intrinsics.areEqual((Object)"aws-iso-b", (Object)partitionResult.getName())) {
                    return new Endpoint(Url.Companion.parse("https://streams.dynamodb." + params.getRegion() + ".sc2s.sgov.gov"), null, 2, null);
                }
                return new Endpoint(Url.Companion.parse("https://streams.dynamodb." + params.getRegion() + '.' + partitionResult.getDnsSuffix()), null, 2, null);
            }
        }
        throw new EndpointProviderException("Invalid Configuration: Missing Region");
    }
}

