// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dynamodbstreams.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A description of a single data modification that was performed on an item in a DynamoDB table.
 */
class StreamRecord private constructor(builder: Builder) {
    /**
     * The approximate date and time when the stream record was created, in [UNIX epoch time](http://www.epochconverter.com/) format.
     */
    val approximateCreationDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.approximateCreationDateTime
    /**
     * The primary key attribute(s) for the DynamoDB item that was modified.
     */
    val keys: Map<String, AttributeValue>? = builder.keys
    /**
     * The item in the DynamoDB table as it appeared after it was modified.
     */
    val newImage: Map<String, AttributeValue>? = builder.newImage
    /**
     * The item in the DynamoDB table as it appeared before it was modified.
     */
    val oldImage: Map<String, AttributeValue>? = builder.oldImage
    /**
     * The sequence number of the stream record.
     */
    val sequenceNumber: kotlin.String? = builder.sequenceNumber
    /**
     * The size of the stream record, in bytes.
     */
    val sizeBytes: kotlin.Long? = builder.sizeBytes
    /**
     * The type of data from the modified DynamoDB item that was captured in this stream record:
     * + `KEYS_ONLY` - only the key attributes of the modified item.
     * + `NEW_IMAGE` - the entire item, as it appeared after it was modified.
     * + `OLD_IMAGE` - the entire item, as it appeared before it was modified.
     * + `NEW_AND_OLD_IMAGES` - both the new and the old item images of the item.
     */
    val streamViewType: aws.sdk.kotlin.services.dynamodbstreams.model.StreamViewType? = builder.streamViewType

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dynamodbstreams.model.StreamRecord = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StreamRecord(")
        append("approximateCreationDateTime=$approximateCreationDateTime,")
        append("keys=$keys,")
        append("newImage=$newImage,")
        append("oldImage=$oldImage,")
        append("sequenceNumber=$sequenceNumber,")
        append("sizeBytes=$sizeBytes,")
        append("streamViewType=$streamViewType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = approximateCreationDateTime?.hashCode() ?: 0
        result = 31 * result + (keys?.hashCode() ?: 0)
        result = 31 * result + (newImage?.hashCode() ?: 0)
        result = 31 * result + (oldImage?.hashCode() ?: 0)
        result = 31 * result + (sequenceNumber?.hashCode() ?: 0)
        result = 31 * result + (sizeBytes?.hashCode() ?: 0)
        result = 31 * result + (streamViewType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StreamRecord

        if (approximateCreationDateTime != other.approximateCreationDateTime) return false
        if (keys != other.keys) return false
        if (newImage != other.newImage) return false
        if (oldImage != other.oldImage) return false
        if (sequenceNumber != other.sequenceNumber) return false
        if (sizeBytes != other.sizeBytes) return false
        if (streamViewType != other.streamViewType) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dynamodbstreams.model.StreamRecord = Builder(this).apply(block).build()

    class Builder {
        /**
         * The approximate date and time when the stream record was created, in [UNIX epoch time](http://www.epochconverter.com/) format.
         */
        var approximateCreationDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The primary key attribute(s) for the DynamoDB item that was modified.
         */
        var keys: Map<String, AttributeValue>? = null
        /**
         * The item in the DynamoDB table as it appeared after it was modified.
         */
        var newImage: Map<String, AttributeValue>? = null
        /**
         * The item in the DynamoDB table as it appeared before it was modified.
         */
        var oldImage: Map<String, AttributeValue>? = null
        /**
         * The sequence number of the stream record.
         */
        var sequenceNumber: kotlin.String? = null
        /**
         * The size of the stream record, in bytes.
         */
        var sizeBytes: kotlin.Long? = null
        /**
         * The type of data from the modified DynamoDB item that was captured in this stream record:
         * + `KEYS_ONLY` - only the key attributes of the modified item.
         * + `NEW_IMAGE` - the entire item, as it appeared after it was modified.
         * + `OLD_IMAGE` - the entire item, as it appeared before it was modified.
         * + `NEW_AND_OLD_IMAGES` - both the new and the old item images of the item.
         */
        var streamViewType: aws.sdk.kotlin.services.dynamodbstreams.model.StreamViewType? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dynamodbstreams.model.StreamRecord) : this() {
            this.approximateCreationDateTime = x.approximateCreationDateTime
            this.keys = x.keys
            this.newImage = x.newImage
            this.oldImage = x.oldImage
            this.sequenceNumber = x.sequenceNumber
            this.sizeBytes = x.sizeBytes
            this.streamViewType = x.streamViewType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dynamodbstreams.model.StreamRecord = StreamRecord(this)
    }
}
