/*
 * Decompiled with CFR 0.152.
 */
package aws.sdk.kotlin.hll.dynamodbmapper.operations;

import aws.sdk.kotlin.hll.dynamodbmapper.annotations.ManualPagination;
import aws.sdk.kotlin.hll.dynamodbmapper.model.TableSpec;
import aws.sdk.kotlin.hll.dynamodbmapper.operations.DeleteItemKt;
import aws.sdk.kotlin.hll.dynamodbmapper.operations.DeleteItemRequest;
import aws.sdk.kotlin.hll.dynamodbmapper.operations.DeleteItemResponse;
import aws.sdk.kotlin.hll.dynamodbmapper.operations.GetItemKt;
import aws.sdk.kotlin.hll.dynamodbmapper.operations.GetItemRequest;
import aws.sdk.kotlin.hll.dynamodbmapper.operations.GetItemResponse;
import aws.sdk.kotlin.hll.dynamodbmapper.operations.PutItemKt;
import aws.sdk.kotlin.hll.dynamodbmapper.operations.PutItemRequest;
import aws.sdk.kotlin.hll.dynamodbmapper.operations.PutItemResponse;
import aws.sdk.kotlin.hll.dynamodbmapper.operations.QueryKt;
import aws.sdk.kotlin.hll.dynamodbmapper.operations.QueryRequest;
import aws.sdk.kotlin.hll.dynamodbmapper.operations.QueryResponse;
import aws.sdk.kotlin.hll.dynamodbmapper.operations.ScanKt;
import aws.sdk.kotlin.hll.dynamodbmapper.operations.ScanRequest;
import aws.sdk.kotlin.hll.dynamodbmapper.operations.ScanResponse;
import aws.sdk.kotlin.hll.dynamodbmapper.operations.TableOperations;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0015\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\"\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\nH\u0096@\u00a2\u0006\u0002\u0010\u000bJ\"\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\r2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\u000eH\u0096@\u00a2\u0006\u0002\u0010\u000fJ\"\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u00112\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\u0012H\u0096@\u00a2\u0006\u0002\u0010\u0013J\"\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u00152\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016H\u0097@\u00a2\u0006\u0002\u0010\u0017J\"\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u00192\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\u001aH\u0097@\u00a2\u0006\u0002\u0010\u001bR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Laws/sdk/kotlin/hll/dynamodbmapper/operations/TableOperationsImpl;", "T", "Laws/sdk/kotlin/hll/dynamodbmapper/operations/TableOperations;", "spec", "Laws/sdk/kotlin/hll/dynamodbmapper/model/TableSpec;", "<init>", "(Laws/sdk/kotlin/hll/dynamodbmapper/model/TableSpec;)V", "deleteItem", "Laws/sdk/kotlin/hll/dynamodbmapper/operations/DeleteItemResponse;", "request", "Laws/sdk/kotlin/hll/dynamodbmapper/operations/DeleteItemRequest;", "(Laws/sdk/kotlin/hll/dynamodbmapper/operations/DeleteItemRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getItem", "Laws/sdk/kotlin/hll/dynamodbmapper/operations/GetItemResponse;", "Laws/sdk/kotlin/hll/dynamodbmapper/operations/GetItemRequest;", "(Laws/sdk/kotlin/hll/dynamodbmapper/operations/GetItemRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "putItem", "Laws/sdk/kotlin/hll/dynamodbmapper/operations/PutItemResponse;", "Laws/sdk/kotlin/hll/dynamodbmapper/operations/PutItemRequest;", "(Laws/sdk/kotlin/hll/dynamodbmapper/operations/PutItemRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "query", "Laws/sdk/kotlin/hll/dynamodbmapper/operations/QueryResponse;", "Laws/sdk/kotlin/hll/dynamodbmapper/operations/QueryRequest;", "(Laws/sdk/kotlin/hll/dynamodbmapper/operations/QueryRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "scan", "Laws/sdk/kotlin/hll/dynamodbmapper/operations/ScanResponse;", "Laws/sdk/kotlin/hll/dynamodbmapper/operations/ScanRequest;", "(Laws/sdk/kotlin/hll/dynamodbmapper/operations/ScanRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "dynamodb-mapper"})
public final class TableOperationsImpl<T>
implements TableOperations<T> {
    @NotNull
    private final TableSpec<T> spec;

    public TableOperationsImpl(@NotNull TableSpec<T> spec) {
        Intrinsics.checkNotNullParameter(spec, (String)"spec");
        this.spec = spec;
    }

    @Override
    @Nullable
    public Object deleteItem(@NotNull DeleteItemRequest<T> request, @NotNull Continuation<? super DeleteItemResponse<T>> $completion) {
        return DeleteItemKt.deleteItemOperation(this.spec).execute(request, $completion);
    }

    @Override
    @Nullable
    public Object getItem(@NotNull GetItemRequest<T> request, @NotNull Continuation<? super GetItemResponse<T>> $completion) {
        return GetItemKt.getItemOperation(this.spec).execute(request, $completion);
    }

    @Override
    @Nullable
    public Object putItem(@NotNull PutItemRequest<T> request, @NotNull Continuation<? super PutItemResponse<T>> $completion) {
        return PutItemKt.putItemOperation(this.spec).execute(request, $completion);
    }

    @Override
    @ManualPagination(paginatedEquivalent="queryPaginated")
    @Nullable
    public Object query(@NotNull QueryRequest<T> request, @NotNull Continuation<? super QueryResponse<T>> $completion) {
        return QueryKt.queryOperation(this.spec).execute(request, $completion);
    }

    @Override
    @ManualPagination(paginatedEquivalent="scanPaginated")
    @Nullable
    public Object scan(@NotNull ScanRequest<T> request, @NotNull Continuation<? super ScanResponse<T>> $completion) {
        return ScanKt.scanOperation(this.spec).execute(request, $completion);
    }
}

