// Code generated by dynamodb-mapper-ops-codegen. DO NOT EDIT!

package aws.sdk.kotlin.hll.dynamodbmapper.operations

import aws.sdk.kotlin.hll.dynamodbmapper.expressions.internal.ParameterizingExpressionVisitor
import aws.sdk.kotlin.hll.dynamodbmapper.internal.withWrappedClient
import aws.sdk.kotlin.hll.dynamodbmapper.items.ItemSchema
import aws.sdk.kotlin.hll.dynamodbmapper.model.TableSpec
import aws.sdk.kotlin.hll.dynamodbmapper.model.toItem
import aws.sdk.kotlin.hll.dynamodbmapper.pipeline.internal.HReqContextImpl
import aws.sdk.kotlin.hll.dynamodbmapper.pipeline.internal.MapperContextImpl
import aws.sdk.kotlin.hll.dynamodbmapper.pipeline.internal.Operation
import aws.sdk.kotlin.services.dynamodb.model.ConsumedCapacity
import aws.sdk.kotlin.services.dynamodb.model.ItemCollectionMetrics
import aws.sdk.kotlin.services.dynamodb.model.ReturnConsumedCapacity
import aws.sdk.kotlin.services.dynamodb.model.ReturnItemCollectionMetrics
import aws.sdk.kotlin.services.dynamodb.model.ReturnValue
import aws.sdk.kotlin.services.dynamodb.model.ReturnValuesOnConditionCheckFailure
import aws.smithy.kotlin.runtime.ExperimentalApi
import aws.sdk.kotlin.services.dynamodb.model.DeleteItemRequest as LowLevelDeleteItemRequest
import aws.sdk.kotlin.services.dynamodb.model.DeleteItemResponse as LowLevelDeleteItemResponse

@ExperimentalApi
public interface DeleteItemRequest<T> {
    @ExperimentalApi
    public companion object { }

    public val key: T?
    public val returnConsumedCapacity: ReturnConsumedCapacity?
    public val returnItemCollectionMetrics: ReturnItemCollectionMetrics?
    public val returnValues: ReturnValue?
    public val returnValuesOnConditionCheckFailure: ReturnValuesOnConditionCheckFailure?
}

private data class DeleteItemRequestImpl<T>(
    override val key: T?,
    override val returnConsumedCapacity: ReturnConsumedCapacity?,
    override val returnItemCollectionMetrics: ReturnItemCollectionMetrics?,
    override val returnValues: ReturnValue?,
    override val returnValuesOnConditionCheckFailure: ReturnValuesOnConditionCheckFailure?,
): DeleteItemRequest<T>

/**
 * A DSL-style builder for instances of [DeleteItemRequest<T>]
 */
@ExperimentalApi
public class DeleteItemRequestBuilder<T> {
    public var key: T? = null
    public var returnConsumedCapacity: ReturnConsumedCapacity? = null
    public var returnItemCollectionMetrics: ReturnItemCollectionMetrics? = null
    public var returnValues: ReturnValue? = null
    public var returnValuesOnConditionCheckFailure: ReturnValuesOnConditionCheckFailure? = null

    public fun build(): DeleteItemRequest<T> {
        val key = key
        val returnConsumedCapacity = returnConsumedCapacity
        val returnItemCollectionMetrics = returnItemCollectionMetrics
        val returnValues = returnValues
        val returnValuesOnConditionCheckFailure = returnValuesOnConditionCheckFailure

        return DeleteItemRequestImpl<T>(
            key,
            returnConsumedCapacity,
            returnItemCollectionMetrics,
            returnValues,
            returnValuesOnConditionCheckFailure,
        )
    }
}

@ExperimentalApi
public fun <T> DeleteItemRequest<T>.toBuilder(): DeleteItemRequestBuilder<T> = DeleteItemRequestBuilder<T>().apply {
    key = this@toBuilder.key
    returnConsumedCapacity = this@toBuilder.returnConsumedCapacity
    returnItemCollectionMetrics = this@toBuilder.returnItemCollectionMetrics
    returnValues = this@toBuilder.returnValues
    returnValuesOnConditionCheckFailure = this@toBuilder.returnValuesOnConditionCheckFailure
}

@ExperimentalApi
public fun <T> DeleteItemRequest<T>.copy(block: DeleteItemRequestBuilder<T>.() -> Unit): DeleteItemRequest<T> =
    toBuilder().apply(block).build()

@ExperimentalApi
public fun <T> DeleteItemRequest(block: DeleteItemRequestBuilder<T>.() -> Unit): DeleteItemRequest<T> =
    DeleteItemRequestBuilder<T>().apply(block).build()

private fun <T> DeleteItemRequest<T>.convert(
    tableName: String?, 
    schema: ItemSchema<T>,
) = LowLevelDeleteItemRequest {
    returnConsumedCapacity = this@convert.returnConsumedCapacity
    returnItemCollectionMetrics = this@convert.returnItemCollectionMetrics
    returnValues = this@convert.returnValues
    returnValuesOnConditionCheckFailure = this@convert.returnValuesOnConditionCheckFailure
    this@convert.key?.let { key = schema.converter.convertTo(it, schema.keyAttributeNames) }
    this.tableName = tableName

    val expressionVisitor = ParameterizingExpressionVisitor()
    expressionAttributeNames = expressionVisitor.expressionAttributeNames()
    expressionAttributeValues = expressionVisitor.expressionAttributeValues()
}

@ExperimentalApi
public interface DeleteItemResponse<T> {
    @ExperimentalApi
    public companion object { }

    public val attributes: T?
    public val consumedCapacity: ConsumedCapacity?
    public val itemCollectionMetrics: ItemCollectionMetrics?
}

private data class DeleteItemResponseImpl<T>(
    override val attributes: T?,
    override val consumedCapacity: ConsumedCapacity?,
    override val itemCollectionMetrics: ItemCollectionMetrics?,
): DeleteItemResponse<T>

/**
 * A DSL-style builder for instances of [DeleteItemResponse<T>]
 */
@ExperimentalApi
public class DeleteItemResponseBuilder<T> {
    public var attributes: T? = null
    public var consumedCapacity: ConsumedCapacity? = null
    public var itemCollectionMetrics: ItemCollectionMetrics? = null

    public fun build(): DeleteItemResponse<T> {
        val attributes = attributes
        val consumedCapacity = consumedCapacity
        val itemCollectionMetrics = itemCollectionMetrics

        return DeleteItemResponseImpl<T>(
            attributes,
            consumedCapacity,
            itemCollectionMetrics,
        )
    }
}

@ExperimentalApi
public fun <T> DeleteItemResponse<T>.toBuilder(): DeleteItemResponseBuilder<T> = DeleteItemResponseBuilder<T>().apply {
    attributes = this@toBuilder.attributes
    consumedCapacity = this@toBuilder.consumedCapacity
    itemCollectionMetrics = this@toBuilder.itemCollectionMetrics
}

@ExperimentalApi
public fun <T> DeleteItemResponse<T>.copy(block: DeleteItemResponseBuilder<T>.() -> Unit): DeleteItemResponse<T> =
    toBuilder().apply(block).build()

@ExperimentalApi
public fun <T> DeleteItemResponse(block: DeleteItemResponseBuilder<T>.() -> Unit): DeleteItemResponse<T> =
    DeleteItemResponseBuilder<T>().apply(block).build()

private fun <T> LowLevelDeleteItemResponse.convert(schema: ItemSchema<T>) = DeleteItemResponse<T> {
    consumedCapacity = this@convert.consumedCapacity
    itemCollectionMetrics = this@convert.itemCollectionMetrics
    attributes = this@convert.attributes?.toItem()?.let(schema.converter::convertFrom)
}

internal fun <T> deleteItemOperation(spec: TableSpec<T>) = Operation(
    initialize = { highLevelReq: DeleteItemRequest<T> -> HReqContextImpl(highLevelReq, spec.schema, MapperContextImpl(spec, "DeleteItem")) },
    serialize = { highLevelReq, schema -> highLevelReq.convert(spec.tableName, schema) },
    lowLevelInvoke = { lowLevelReq ->
        spec.mapper.client.withWrappedClient { client ->
            client.deleteItem(lowLevelReq)
        }
    },
    deserialize = LowLevelDeleteItemResponse::convert,
    interceptors = spec.mapper.config.interceptors,
)
