// Code generated by dynamodb-mapper-ops-codegen. DO NOT EDIT!

package aws.sdk.kotlin.hll.dynamodbmapper.operations

import aws.sdk.kotlin.hll.dynamodbmapper.annotations.ManualPagination
import aws.sdk.kotlin.hll.dynamodbmapper.model.IndexSpec
import aws.smithy.kotlin.runtime.ExperimentalApi
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow

/**
 * Provides access to operations on a particular index, which will invoke low-level
 * operations after mapping objects to items and vice versa
 * @param T The type of objects which will be read from and/or written to this index
 */
@ExperimentalApi
public interface IndexOperations<T> : ItemSourceOperations<T> {

    @ManualPagination(paginatedEquivalent = "queryPaginated")
    public override suspend fun query(request: QueryRequest<T>): QueryResponse<T>

    @ManualPagination(paginatedEquivalent = "scanPaginated")
    public override suspend fun scan(request: ScanRequest<T>): ScanResponse<T>
}

@ExperimentalApi
public fun <T> IndexOperations<T>.queryPaginated(initialRequest: QueryRequest<T>): Flow<QueryResponse<T>> = flow {
    var cursor = initialRequest.exclusiveStartKey
    var hasNextPage = true

    while (hasNextPage) {
        val req = initialRequest.copy { exclusiveStartKey = cursor }

        @OptIn(ManualPagination::class)
        val res = this@queryPaginated.query(req)

        cursor = res.lastEvaluatedKey
        hasNextPage = cursor != null
        emit(res)
    }
}

@ExperimentalApi
public inline fun <T> IndexOperations<T>.queryPaginated(crossinline block: QueryRequestBuilder<T>.() -> Unit): Flow<QueryResponse<T>> =
    queryPaginated(QueryRequestBuilder<T>().apply(block).build())

@ExperimentalApi
public fun <T> IndexOperations<T>.scanPaginated(initialRequest: ScanRequest<T>): Flow<ScanResponse<T>> = flow {
    var cursor = initialRequest.exclusiveStartKey
    var hasNextPage = true

    while (hasNextPage) {
        val req = initialRequest.copy { exclusiveStartKey = cursor }

        @OptIn(ManualPagination::class)
        val res = this@scanPaginated.scan(req)

        cursor = res.lastEvaluatedKey
        hasNextPage = cursor != null
        emit(res)
    }
}

@ExperimentalApi
public inline fun <T> IndexOperations<T>.scanPaginated(crossinline block: ScanRequestBuilder<T>.() -> Unit): Flow<ScanResponse<T>> =
    scanPaginated(ScanRequestBuilder<T>().apply(block).build())

internal class IndexOperationsImpl<T>(private val spec: IndexSpec<T>) : IndexOperations<T> {

    @ManualPagination(paginatedEquivalent = "queryPaginated")
    override suspend fun query(request: QueryRequest<T>) = queryOperation(spec).execute(request)

    @ManualPagination(paginatedEquivalent = "scanPaginated")
    override suspend fun scan(request: ScanRequest<T>) = scanOperation(spec).execute(request)
}
