// Code generated by dynamodb-mapper-ops-codegen. DO NOT EDIT!

package aws.sdk.kotlin.hll.dynamodbmapper.operations

import aws.sdk.kotlin.hll.dynamodbmapper.expressions.internal.ParameterizingExpressionVisitor
import aws.sdk.kotlin.hll.dynamodbmapper.internal.withWrappedClient
import aws.sdk.kotlin.hll.dynamodbmapper.items.ItemSchema
import aws.sdk.kotlin.hll.dynamodbmapper.model.TableSpec
import aws.sdk.kotlin.hll.dynamodbmapper.model.toItem
import aws.sdk.kotlin.hll.dynamodbmapper.pipeline.internal.HReqContextImpl
import aws.sdk.kotlin.hll.dynamodbmapper.pipeline.internal.MapperContextImpl
import aws.sdk.kotlin.hll.dynamodbmapper.pipeline.internal.Operation
import aws.sdk.kotlin.services.dynamodb.model.ConsumedCapacity
import aws.sdk.kotlin.services.dynamodb.model.ItemCollectionMetrics
import aws.sdk.kotlin.services.dynamodb.model.ReturnConsumedCapacity
import aws.sdk.kotlin.services.dynamodb.model.ReturnItemCollectionMetrics
import aws.sdk.kotlin.services.dynamodb.model.ReturnValue
import aws.sdk.kotlin.services.dynamodb.model.ReturnValuesOnConditionCheckFailure
import aws.smithy.kotlin.runtime.ExperimentalApi
import aws.sdk.kotlin.services.dynamodb.model.PutItemRequest as LowLevelPutItemRequest
import aws.sdk.kotlin.services.dynamodb.model.PutItemResponse as LowLevelPutItemResponse

@ExperimentalApi
public interface PutItemRequest<T> {
    @ExperimentalApi
    public companion object { }

    public val item: T?
    public val returnConsumedCapacity: ReturnConsumedCapacity?
    public val returnItemCollectionMetrics: ReturnItemCollectionMetrics?
    public val returnValues: ReturnValue?
    public val returnValuesOnConditionCheckFailure: ReturnValuesOnConditionCheckFailure?
}

private data class PutItemRequestImpl<T>(
    override val item: T?,
    override val returnConsumedCapacity: ReturnConsumedCapacity?,
    override val returnItemCollectionMetrics: ReturnItemCollectionMetrics?,
    override val returnValues: ReturnValue?,
    override val returnValuesOnConditionCheckFailure: ReturnValuesOnConditionCheckFailure?,
): PutItemRequest<T>

/**
 * A DSL-style builder for instances of [PutItemRequest<T>]
 */
@ExperimentalApi
public class PutItemRequestBuilder<T> {
    public var item: T? = null
    public var returnConsumedCapacity: ReturnConsumedCapacity? = null
    public var returnItemCollectionMetrics: ReturnItemCollectionMetrics? = null
    public var returnValues: ReturnValue? = null
    public var returnValuesOnConditionCheckFailure: ReturnValuesOnConditionCheckFailure? = null

    public fun build(): PutItemRequest<T> {
        val item = item
        val returnConsumedCapacity = returnConsumedCapacity
        val returnItemCollectionMetrics = returnItemCollectionMetrics
        val returnValues = returnValues
        val returnValuesOnConditionCheckFailure = returnValuesOnConditionCheckFailure

        return PutItemRequestImpl<T>(
            item,
            returnConsumedCapacity,
            returnItemCollectionMetrics,
            returnValues,
            returnValuesOnConditionCheckFailure,
        )
    }
}

@ExperimentalApi
public fun <T> PutItemRequest<T>.toBuilder(): PutItemRequestBuilder<T> = PutItemRequestBuilder<T>().apply {
    item = this@toBuilder.item
    returnConsumedCapacity = this@toBuilder.returnConsumedCapacity
    returnItemCollectionMetrics = this@toBuilder.returnItemCollectionMetrics
    returnValues = this@toBuilder.returnValues
    returnValuesOnConditionCheckFailure = this@toBuilder.returnValuesOnConditionCheckFailure
}

@ExperimentalApi
public fun <T> PutItemRequest<T>.copy(block: PutItemRequestBuilder<T>.() -> Unit): PutItemRequest<T> =
    toBuilder().apply(block).build()

@ExperimentalApi
public fun <T> PutItemRequest(block: PutItemRequestBuilder<T>.() -> Unit): PutItemRequest<T> =
    PutItemRequestBuilder<T>().apply(block).build()

private fun <T> PutItemRequest<T>.convert(
    tableName: String?, 
    schema: ItemSchema<T>,
) = LowLevelPutItemRequest {
    returnConsumedCapacity = this@convert.returnConsumedCapacity
    returnItemCollectionMetrics = this@convert.returnItemCollectionMetrics
    returnValues = this@convert.returnValues
    returnValuesOnConditionCheckFailure = this@convert.returnValuesOnConditionCheckFailure
    this@convert.item?.let { item = schema.converter.convertTo(it) }
    this.tableName = tableName

    val expressionVisitor = ParameterizingExpressionVisitor()
    expressionAttributeNames = expressionVisitor.expressionAttributeNames()
    expressionAttributeValues = expressionVisitor.expressionAttributeValues()
}

@ExperimentalApi
public interface PutItemResponse<T> {
    @ExperimentalApi
    public companion object { }

    public val attributes: T?
    public val consumedCapacity: ConsumedCapacity?
    public val itemCollectionMetrics: ItemCollectionMetrics?
}

private data class PutItemResponseImpl<T>(
    override val attributes: T?,
    override val consumedCapacity: ConsumedCapacity?,
    override val itemCollectionMetrics: ItemCollectionMetrics?,
): PutItemResponse<T>

/**
 * A DSL-style builder for instances of [PutItemResponse<T>]
 */
@ExperimentalApi
public class PutItemResponseBuilder<T> {
    public var attributes: T? = null
    public var consumedCapacity: ConsumedCapacity? = null
    public var itemCollectionMetrics: ItemCollectionMetrics? = null

    public fun build(): PutItemResponse<T> {
        val attributes = attributes
        val consumedCapacity = consumedCapacity
        val itemCollectionMetrics = itemCollectionMetrics

        return PutItemResponseImpl<T>(
            attributes,
            consumedCapacity,
            itemCollectionMetrics,
        )
    }
}

@ExperimentalApi
public fun <T> PutItemResponse<T>.toBuilder(): PutItemResponseBuilder<T> = PutItemResponseBuilder<T>().apply {
    attributes = this@toBuilder.attributes
    consumedCapacity = this@toBuilder.consumedCapacity
    itemCollectionMetrics = this@toBuilder.itemCollectionMetrics
}

@ExperimentalApi
public fun <T> PutItemResponse<T>.copy(block: PutItemResponseBuilder<T>.() -> Unit): PutItemResponse<T> =
    toBuilder().apply(block).build()

@ExperimentalApi
public fun <T> PutItemResponse(block: PutItemResponseBuilder<T>.() -> Unit): PutItemResponse<T> =
    PutItemResponseBuilder<T>().apply(block).build()

private fun <T> LowLevelPutItemResponse.convert(schema: ItemSchema<T>) = PutItemResponse<T> {
    consumedCapacity = this@convert.consumedCapacity
    itemCollectionMetrics = this@convert.itemCollectionMetrics
    attributes = this@convert.attributes?.toItem()?.let(schema.converter::convertFrom)
}

internal fun <T> putItemOperation(spec: TableSpec<T>) = Operation(
    initialize = { highLevelReq: PutItemRequest<T> -> HReqContextImpl(highLevelReq, spec.schema, MapperContextImpl(spec, "PutItem")) },
    serialize = { highLevelReq, schema -> highLevelReq.convert(spec.tableName, schema) },
    lowLevelInvoke = { lowLevelReq ->
        spec.mapper.client.withWrappedClient { client ->
            client.putItem(lowLevelReq)
        }
    },
    deserialize = LowLevelPutItemResponse::convert,
    interceptors = spec.mapper.config.interceptors,
)
