// Code generated by dynamodb-mapper-ops-codegen. DO NOT EDIT!

package aws.sdk.kotlin.hll.dynamodbmapper.operations

import aws.sdk.kotlin.hll.dynamodbmapper.annotations.ManualPagination
import aws.smithy.kotlin.runtime.ExperimentalApi
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform
import kotlin.jvm.JvmName

/**
 * Provides access to operations on a particular itemSource, which will invoke low-level
 * operations after mapping objects to items and vice versa
 * @param T The type of objects which will be read from and/or written to this itemSource
 */
@ExperimentalApi
public interface ItemSourceOperations<T> {

    @ManualPagination(paginatedEquivalent = "queryPaginated")
    public suspend fun query(request: QueryRequest<T>): QueryResponse<T>

    @ManualPagination(paginatedEquivalent = "scanPaginated")
    public suspend fun scan(request: ScanRequest<T>): ScanResponse<T>
}

@ManualPagination(paginatedEquivalent = "queryPaginated")
public suspend inline fun <T> ItemSourceOperations<T>.query(crossinline block: QueryRequestBuilder<T>.() -> Unit): QueryResponse<T> =
    query(QueryRequestBuilder<T>().apply(block).build())

@ManualPagination(paginatedEquivalent = "scanPaginated")
public suspend inline fun <T> ItemSourceOperations<T>.scan(crossinline block: ScanRequestBuilder<T>.() -> Unit): ScanResponse<T> =
    scan(ScanRequestBuilder<T>().apply(block).build())

@ExperimentalApi
public fun <T> ItemSourceOperations<T>.queryPaginated(initialRequest: QueryRequest<T>): Flow<QueryResponse<T>> = flow {
    var cursor = initialRequest.exclusiveStartKey
    var hasNextPage = true

    while (hasNextPage) {
        val req = initialRequest.copy { exclusiveStartKey = cursor }

        @OptIn(ManualPagination::class)
        val res = this@queryPaginated.query(req)

        cursor = res.lastEvaluatedKey
        hasNextPage = cursor != null
        emit(res)
    }
}

@ExperimentalApi
public inline fun <T> ItemSourceOperations<T>.queryPaginated(crossinline block: QueryRequestBuilder<T>.() -> Unit): Flow<QueryResponse<T>> =
    queryPaginated(QueryRequestBuilder<T>().apply(block).build())

@ExperimentalApi
public fun <T> ItemSourceOperations<T>.scanPaginated(initialRequest: ScanRequest<T>): Flow<ScanResponse<T>> = flow {
    var cursor = initialRequest.exclusiveStartKey
    var hasNextPage = true

    while (hasNextPage) {
        val req = initialRequest.copy { exclusiveStartKey = cursor }

        @OptIn(ManualPagination::class)
        val res = this@scanPaginated.scan(req)

        cursor = res.lastEvaluatedKey
        hasNextPage = cursor != null
        emit(res)
    }
}

@ExperimentalApi
public inline fun <T> ItemSourceOperations<T>.scanPaginated(crossinline block: ScanRequestBuilder<T>.() -> Unit): Flow<ScanResponse<T>> =
    scanPaginated(ScanRequestBuilder<T>().apply(block).build())

@ExperimentalApi
@JvmName("queryItems")
public fun <T> Flow<QueryResponse<T>>.items(): Flow<T> =
    transform { page ->
        page.items?.forEach { item ->
            emit(item)
        }
    }

@ExperimentalApi
@JvmName("scanItems")
public fun <T> Flow<ScanResponse<T>>.items(): Flow<T> =
    transform { page ->
        page.items?.forEach { item ->
            emit(item)
        }
    }

