// Code generated by dynamodb-mapper-ops-codegen. DO NOT EDIT!

package aws.sdk.kotlin.hll.dynamodbmapper.operations

import aws.sdk.kotlin.hll.dynamodbmapper.expressions.internal.ParameterizingExpressionVisitor
import aws.sdk.kotlin.hll.dynamodbmapper.internal.withWrappedClient
import aws.sdk.kotlin.hll.dynamodbmapper.items.ItemSchema
import aws.sdk.kotlin.hll.dynamodbmapper.model.TableSpec
import aws.sdk.kotlin.hll.dynamodbmapper.model.intersectKeys
import aws.sdk.kotlin.hll.dynamodbmapper.model.toItem
import aws.sdk.kotlin.hll.dynamodbmapper.pipeline.internal.HReqContextImpl
import aws.sdk.kotlin.hll.dynamodbmapper.pipeline.internal.MapperContextImpl
import aws.sdk.kotlin.hll.dynamodbmapper.pipeline.internal.Operation
import aws.sdk.kotlin.services.dynamodb.model.ConsumedCapacity
import aws.sdk.kotlin.services.dynamodb.model.ReturnConsumedCapacity
import aws.smithy.kotlin.runtime.ExperimentalApi
import aws.sdk.kotlin.services.dynamodb.model.GetItemRequest as LowLevelGetItemRequest
import aws.sdk.kotlin.services.dynamodb.model.GetItemResponse as LowLevelGetItemResponse

@ExperimentalApi
public interface GetItemRequest<T> {
    @ExperimentalApi
    public companion object { }

    public val consistentRead: Boolean?
    public val key: T?
    public val returnConsumedCapacity: ReturnConsumedCapacity?
}

private data class GetItemRequestImpl<T>(
    override val consistentRead: Boolean?,
    override val key: T?,
    override val returnConsumedCapacity: ReturnConsumedCapacity?,
): GetItemRequest<T>

/**
 * A DSL-style builder for instances of [GetItemRequest<T>]
 */
@ExperimentalApi
public class GetItemRequestBuilder<T> {
    public var consistentRead: Boolean? = null
    public var key: T? = null
    public var returnConsumedCapacity: ReturnConsumedCapacity? = null

    public fun build(): GetItemRequest<T> {
        val consistentRead = consistentRead
        val key = key
        val returnConsumedCapacity = returnConsumedCapacity

        return GetItemRequestImpl<T>(
            consistentRead,
            key,
            returnConsumedCapacity,
        )
    }
}

@ExperimentalApi
public fun <T> GetItemRequest<T>.toBuilder(): GetItemRequestBuilder<T> = GetItemRequestBuilder<T>().apply {
    consistentRead = this@toBuilder.consistentRead
    key = this@toBuilder.key
    returnConsumedCapacity = this@toBuilder.returnConsumedCapacity
}

@ExperimentalApi
public fun <T> GetItemRequest<T>.copy(block: GetItemRequestBuilder<T>.() -> Unit): GetItemRequest<T> =
    toBuilder().apply(block).build()

@ExperimentalApi
public fun <T> GetItemRequest(block: GetItemRequestBuilder<T>.() -> Unit): GetItemRequest<T> =
    GetItemRequestBuilder<T>().apply(block).build()

private fun <T> GetItemRequest<T>.convert(
    tableName: String?, 
    schema: ItemSchema<T>,
) = LowLevelGetItemRequest {
    consistentRead = this@convert.consistentRead
    returnConsumedCapacity = this@convert.returnConsumedCapacity
    this@convert.key?.let { key = schema.converter.convertTo(it, schema.keyAttributeNames).intersectKeys(schema.keyAttributeNames) }
    this.tableName = tableName

    val expressionVisitor = ParameterizingExpressionVisitor()
    expressionAttributeNames = expressionVisitor.expressionAttributeNames()
}

@ExperimentalApi
public interface GetItemResponse<T> {
    @ExperimentalApi
    public companion object { }

    public val consumedCapacity: ConsumedCapacity?
    public val item: T?
}

private data class GetItemResponseImpl<T>(
    override val consumedCapacity: ConsumedCapacity?,
    override val item: T?,
): GetItemResponse<T>

/**
 * A DSL-style builder for instances of [GetItemResponse<T>]
 */
@ExperimentalApi
public class GetItemResponseBuilder<T> {
    public var consumedCapacity: ConsumedCapacity? = null
    public var item: T? = null

    public fun build(): GetItemResponse<T> {
        val consumedCapacity = consumedCapacity
        val item = item

        return GetItemResponseImpl<T>(
            consumedCapacity,
            item,
        )
    }
}

@ExperimentalApi
public fun <T> GetItemResponse<T>.toBuilder(): GetItemResponseBuilder<T> = GetItemResponseBuilder<T>().apply {
    consumedCapacity = this@toBuilder.consumedCapacity
    item = this@toBuilder.item
}

@ExperimentalApi
public fun <T> GetItemResponse<T>.copy(block: GetItemResponseBuilder<T>.() -> Unit): GetItemResponse<T> =
    toBuilder().apply(block).build()

@ExperimentalApi
public fun <T> GetItemResponse(block: GetItemResponseBuilder<T>.() -> Unit): GetItemResponse<T> =
    GetItemResponseBuilder<T>().apply(block).build()

private fun <T> LowLevelGetItemResponse.convert(schema: ItemSchema<T>) = GetItemResponse<T> {
    consumedCapacity = this@convert.consumedCapacity
    item = this@convert.item?.toItem()?.let(schema.converter::convertFrom)
}

internal fun <T> getItemOperation(spec: TableSpec<T>) = Operation(
    initialize = { highLevelReq: GetItemRequest<T> -> HReqContextImpl(highLevelReq, spec.schema, MapperContextImpl(spec, "GetItem")) },
    serialize = { highLevelReq, schema -> highLevelReq.convert(spec.tableName, schema) },
    lowLevelInvoke = { lowLevelReq ->
        spec.mapper.client.withWrappedClient { client ->
            client.getItem(lowLevelReq)
        }
    },
    deserialize = LowLevelGetItemResponse::convert,
    interceptors = spec.mapper.config.interceptors,
)
