// Code generated by dynamodb-mapper-ops-codegen. DO NOT EDIT!

package aws.sdk.kotlin.hll.dynamodbmapper.operations

import aws.sdk.kotlin.hll.dynamodbmapper.expressions.BooleanExpr
import aws.sdk.kotlin.hll.dynamodbmapper.expressions.Filter
import aws.sdk.kotlin.hll.dynamodbmapper.expressions.KeyFilter
import aws.sdk.kotlin.hll.dynamodbmapper.expressions.internal.FilterImpl
import aws.sdk.kotlin.hll.dynamodbmapper.expressions.internal.ParameterizingExpressionVisitor
import aws.sdk.kotlin.hll.dynamodbmapper.expressions.internal.toExpression
import aws.sdk.kotlin.hll.dynamodbmapper.internal.withWrappedClient
import aws.sdk.kotlin.hll.dynamodbmapper.items.ItemSchema
import aws.sdk.kotlin.hll.dynamodbmapper.model.IndexSpec
import aws.sdk.kotlin.hll.dynamodbmapper.model.TableSpec
import aws.sdk.kotlin.hll.dynamodbmapper.model.intersectKeys
import aws.sdk.kotlin.hll.dynamodbmapper.model.toItem
import aws.sdk.kotlin.hll.dynamodbmapper.pipeline.internal.HReqContextImpl
import aws.sdk.kotlin.hll.dynamodbmapper.pipeline.internal.MapperContextImpl
import aws.sdk.kotlin.hll.dynamodbmapper.pipeline.internal.Operation
import aws.sdk.kotlin.services.dynamodb.model.ConsumedCapacity
import aws.sdk.kotlin.services.dynamodb.model.ReturnConsumedCapacity
import aws.sdk.kotlin.services.dynamodb.model.Select
import aws.smithy.kotlin.runtime.ExperimentalApi
import kotlin.collections.List
import aws.sdk.kotlin.services.dynamodb.model.QueryRequest as LowLevelQueryRequest
import aws.sdk.kotlin.services.dynamodb.model.QueryResponse as LowLevelQueryResponse

@ExperimentalApi
public interface QueryRequest<T> {
    @ExperimentalApi
    public companion object { }

    public val consistentRead: Boolean?
    public val exclusiveStartKey: T?
    public val filter: BooleanExpr?
    public val keyCondition: KeyFilter?
    public val limit: Int?
    public val returnConsumedCapacity: ReturnConsumedCapacity?
    public val scanIndexForward: Boolean?
    public val select: Select?
}

private data class QueryRequestImpl<T>(
    override val consistentRead: Boolean?,
    override val exclusiveStartKey: T?,
    override val filter: BooleanExpr?,
    override val keyCondition: KeyFilter?,
    override val limit: Int?,
    override val returnConsumedCapacity: ReturnConsumedCapacity?,
    override val scanIndexForward: Boolean?,
    override val select: Select?,
): QueryRequest<T>

/**
 * A DSL-style builder for instances of [QueryRequest<T>]
 */
@ExperimentalApi
public class QueryRequestBuilder<T> {
    public var consistentRead: Boolean? = null
    public var exclusiveStartKey: T? = null

    public var filter: BooleanExpr? = null

    public fun filter(block: Filter.() -> BooleanExpr?) {
        filter = FilterImpl.run(block)
    }

    public var keyCondition: KeyFilter? = null
    public var limit: Int? = null
    public var returnConsumedCapacity: ReturnConsumedCapacity? = null
    public var scanIndexForward: Boolean? = null
    public var select: Select? = null

    public fun build(): QueryRequest<T> {
        val consistentRead = consistentRead
        val exclusiveStartKey = exclusiveStartKey
        val filter = filter
        val keyCondition = keyCondition
        val limit = limit
        val returnConsumedCapacity = returnConsumedCapacity
        val scanIndexForward = scanIndexForward
        val select = select

        return QueryRequestImpl<T>(
            consistentRead,
            exclusiveStartKey,
            filter,
            keyCondition,
            limit,
            returnConsumedCapacity,
            scanIndexForward,
            select,
        )
    }
}

@ExperimentalApi
public fun <T> QueryRequest<T>.toBuilder(): QueryRequestBuilder<T> = QueryRequestBuilder<T>().apply {
    consistentRead = this@toBuilder.consistentRead
    exclusiveStartKey = this@toBuilder.exclusiveStartKey
    filter = this@toBuilder.filter
    keyCondition = this@toBuilder.keyCondition
    limit = this@toBuilder.limit
    returnConsumedCapacity = this@toBuilder.returnConsumedCapacity
    scanIndexForward = this@toBuilder.scanIndexForward
    select = this@toBuilder.select
}

@ExperimentalApi
public fun <T> QueryRequest<T>.copy(block: QueryRequestBuilder<T>.() -> Unit): QueryRequest<T> =
    toBuilder().apply(block).build()

@ExperimentalApi
public fun <T> QueryRequest(block: QueryRequestBuilder<T>.() -> Unit): QueryRequest<T> =
    QueryRequestBuilder<T>().apply(block).build()

private fun <T> QueryRequest<T>.convert(
    indexName: String?, 
    tableName: String?, 
    schema: ItemSchema<T>,
) = LowLevelQueryRequest {
    consistentRead = this@convert.consistentRead
    limit = this@convert.limit
    returnConsumedCapacity = this@convert.returnConsumedCapacity
    scanIndexForward = this@convert.scanIndexForward
    select = this@convert.select
    this@convert.exclusiveStartKey?.let { exclusiveStartKey = schema.converter.convertTo(it, schema.keyAttributeNames).intersectKeys(schema.keyAttributeNames) }
    this.indexName = indexName
    this.tableName = tableName

    val expressionVisitor = ParameterizingExpressionVisitor()
    filterExpression = this@convert.filter?.accept(expressionVisitor)
    keyConditionExpression = this@convert.keyCondition?.toExpression(schema)?.accept(expressionVisitor)
    expressionAttributeNames = expressionVisitor.expressionAttributeNames()
    expressionAttributeValues = expressionVisitor.expressionAttributeValues()
}

@ExperimentalApi
public interface QueryResponse<T> {
    @ExperimentalApi
    public companion object { }

    public val consumedCapacity: ConsumedCapacity?
    public val count: Int
    public val items: List<T>?
    public val lastEvaluatedKey: T?
    public val scannedCount: Int
}

private data class QueryResponseImpl<T>(
    override val consumedCapacity: ConsumedCapacity?,
    override val count: Int,
    override val items: List<T>?,
    override val lastEvaluatedKey: T?,
    override val scannedCount: Int,
): QueryResponse<T>

/**
 * A DSL-style builder for instances of [QueryResponse<T>]
 */
@ExperimentalApi
public class QueryResponseBuilder<T> {
    public var consumedCapacity: ConsumedCapacity? = null
    public var count: Int? = null
    public var items: List<T>? = null
    public var lastEvaluatedKey: T? = null
    public var scannedCount: Int? = null

    public fun build(): QueryResponse<T> {
        val consumedCapacity = consumedCapacity
        val count = requireNotNull(count) { "Missing value for count" }
        val items = items
        val lastEvaluatedKey = lastEvaluatedKey
        val scannedCount = requireNotNull(scannedCount) { "Missing value for scannedCount" }

        return QueryResponseImpl<T>(
            consumedCapacity,
            count,
            items,
            lastEvaluatedKey,
            scannedCount,
        )
    }
}

@ExperimentalApi
public fun <T> QueryResponse<T>.toBuilder(): QueryResponseBuilder<T> = QueryResponseBuilder<T>().apply {
    consumedCapacity = this@toBuilder.consumedCapacity
    count = this@toBuilder.count
    items = this@toBuilder.items
    lastEvaluatedKey = this@toBuilder.lastEvaluatedKey
    scannedCount = this@toBuilder.scannedCount
}

@ExperimentalApi
public fun <T> QueryResponse<T>.copy(block: QueryResponseBuilder<T>.() -> Unit): QueryResponse<T> =
    toBuilder().apply(block).build()

@ExperimentalApi
public fun <T> QueryResponse(block: QueryResponseBuilder<T>.() -> Unit): QueryResponse<T> =
    QueryResponseBuilder<T>().apply(block).build()

private fun <T> LowLevelQueryResponse.convert(schema: ItemSchema<T>) = QueryResponse<T> {
    consumedCapacity = this@convert.consumedCapacity
    count = this@convert.count
    scannedCount = this@convert.scannedCount
    lastEvaluatedKey = this@convert.lastEvaluatedKey?.toItem()?.let(schema.converter::convertFrom)
    items = this@convert.items?.map { schema.converter.convertFrom(it.toItem()) }
}

internal fun <T> queryOperation(spec: IndexSpec<T>) = Operation(
    initialize = { highLevelReq: QueryRequest<T> -> HReqContextImpl(highLevelReq, spec.schema, MapperContextImpl(spec, "Query")) },
    serialize = { highLevelReq, schema -> highLevelReq.convert(spec.indexName, spec.tableName, schema) },
    lowLevelInvoke = { lowLevelReq ->
        spec.mapper.client.withWrappedClient { client ->
            client.query(lowLevelReq)
        }
    },
    deserialize = LowLevelQueryResponse::convert,
    interceptors = spec.mapper.config.interceptors,
)

internal fun <T> queryOperation(spec: TableSpec<T>) = Operation(
    initialize = { highLevelReq: QueryRequest<T> -> HReqContextImpl(highLevelReq, spec.schema, MapperContextImpl(spec, "Query")) },
    serialize = { highLevelReq, schema -> highLevelReq.convert(indexName = null, spec.tableName, schema) },
    lowLevelInvoke = { lowLevelReq ->
        spec.mapper.client.withWrappedClient { client ->
            client.query(lowLevelReq)
        }
    },
    deserialize = LowLevelQueryResponse::convert,
    interceptors = spec.mapper.config.interceptors,
)
