// Code generated by dynamodb-mapper-ops-codegen. DO NOT EDIT!

package aws.sdk.kotlin.hll.dynamodbmapper.operations

import aws.sdk.kotlin.hll.dynamodbmapper.annotations.ManualPagination
import aws.sdk.kotlin.hll.dynamodbmapper.model.TableSpec
import aws.smithy.kotlin.runtime.ExperimentalApi
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow

/**
 * Provides access to operations on a particular table, which will invoke low-level
 * operations after mapping objects to items and vice versa
 * @param T The type of objects which will be read from and/or written to this table
 */
@ExperimentalApi
public interface TableOperations<T> : ItemSourceOperations<T> {
    public suspend fun deleteItem(request: DeleteItemRequest<T>): DeleteItemResponse<T>
    public suspend fun getItem(request: GetItemRequest<T>): GetItemResponse<T>
    public suspend fun putItem(request: PutItemRequest<T>): PutItemResponse<T>

    @ManualPagination(paginatedEquivalent = "queryPaginated")
    public override suspend fun query(request: QueryRequest<T>): QueryResponse<T>

    @ManualPagination(paginatedEquivalent = "scanPaginated")
    public override suspend fun scan(request: ScanRequest<T>): ScanResponse<T>
}

public suspend inline fun <T> TableOperations<T>.deleteItem(crossinline block: DeleteItemRequestBuilder<T>.() -> Unit): DeleteItemResponse<T> =
    deleteItem(DeleteItemRequestBuilder<T>().apply(block).build())

public suspend inline fun <T> TableOperations<T>.getItem(crossinline block: GetItemRequestBuilder<T>.() -> Unit): GetItemResponse<T> =
    getItem(GetItemRequestBuilder<T>().apply(block).build())

public suspend inline fun <T> TableOperations<T>.putItem(crossinline block: PutItemRequestBuilder<T>.() -> Unit): PutItemResponse<T> =
    putItem(PutItemRequestBuilder<T>().apply(block).build())

@ExperimentalApi
public fun <T> TableOperations<T>.queryPaginated(initialRequest: QueryRequest<T>): Flow<QueryResponse<T>> = flow {
    var cursor = initialRequest.exclusiveStartKey
    var hasNextPage = true

    while (hasNextPage) {
        val req = initialRequest.copy { exclusiveStartKey = cursor }

        @OptIn(ManualPagination::class)
        val res = this@queryPaginated.query(req)

        cursor = res.lastEvaluatedKey
        hasNextPage = cursor != null
        emit(res)
    }
}

@ExperimentalApi
public inline fun <T> TableOperations<T>.queryPaginated(crossinline block: QueryRequestBuilder<T>.() -> Unit): Flow<QueryResponse<T>> =
    queryPaginated(QueryRequestBuilder<T>().apply(block).build())

@ExperimentalApi
public fun <T> TableOperations<T>.scanPaginated(initialRequest: ScanRequest<T>): Flow<ScanResponse<T>> = flow {
    var cursor = initialRequest.exclusiveStartKey
    var hasNextPage = true

    while (hasNextPage) {
        val req = initialRequest.copy { exclusiveStartKey = cursor }

        @OptIn(ManualPagination::class)
        val res = this@scanPaginated.scan(req)

        cursor = res.lastEvaluatedKey
        hasNextPage = cursor != null
        emit(res)
    }
}

@ExperimentalApi
public inline fun <T> TableOperations<T>.scanPaginated(crossinline block: ScanRequestBuilder<T>.() -> Unit): Flow<ScanResponse<T>> =
    scanPaginated(ScanRequestBuilder<T>().apply(block).build())

internal class TableOperationsImpl<T>(private val spec: TableSpec<T>) : TableOperations<T> {
    override suspend fun deleteItem(request: DeleteItemRequest<T>) = deleteItemOperation(spec).execute(request)
    override suspend fun getItem(request: GetItemRequest<T>) = getItemOperation(spec).execute(request)
    override suspend fun putItem(request: PutItemRequest<T>) = putItemOperation(spec).execute(request)

    @ManualPagination(paginatedEquivalent = "queryPaginated")
    override suspend fun query(request: QueryRequest<T>) = queryOperation(spec).execute(request)

    @ManualPagination(paginatedEquivalent = "scanPaginated")
    override suspend fun scan(request: ScanRequest<T>) = scanOperation(spec).execute(request)
}
