// Code generated by dynamodb-mapper-ops-codegen. DO NOT EDIT!

package aws.sdk.kotlin.hll.dynamodbmapper.operations

import aws.sdk.kotlin.hll.dynamodbmapper.expressions.BooleanExpr
import aws.sdk.kotlin.hll.dynamodbmapper.expressions.Filter
import aws.sdk.kotlin.hll.dynamodbmapper.expressions.internal.FilterImpl
import aws.sdk.kotlin.hll.dynamodbmapper.expressions.internal.ParameterizingExpressionVisitor
import aws.sdk.kotlin.hll.dynamodbmapper.internal.withWrappedClient
import aws.sdk.kotlin.hll.dynamodbmapper.items.ItemSchema
import aws.sdk.kotlin.hll.dynamodbmapper.model.IndexSpec
import aws.sdk.kotlin.hll.dynamodbmapper.model.TableSpec
import aws.sdk.kotlin.hll.dynamodbmapper.model.toItem
import aws.sdk.kotlin.hll.dynamodbmapper.pipeline.internal.HReqContextImpl
import aws.sdk.kotlin.hll.dynamodbmapper.pipeline.internal.MapperContextImpl
import aws.sdk.kotlin.hll.dynamodbmapper.pipeline.internal.Operation
import aws.sdk.kotlin.services.dynamodb.model.ConsumedCapacity
import aws.sdk.kotlin.services.dynamodb.model.ReturnConsumedCapacity
import aws.sdk.kotlin.services.dynamodb.model.Select
import aws.smithy.kotlin.runtime.ExperimentalApi
import kotlin.collections.List
import aws.sdk.kotlin.services.dynamodb.model.ScanRequest as LowLevelScanRequest
import aws.sdk.kotlin.services.dynamodb.model.ScanResponse as LowLevelScanResponse

@ExperimentalApi
public interface ScanRequest<T> {
    @ExperimentalApi
    public companion object { }

    public val consistentRead: Boolean?
    public val exclusiveStartKey: T?
    public val filter: BooleanExpr?
    public val limit: Int?
    public val returnConsumedCapacity: ReturnConsumedCapacity?
    public val segment: Int?
    public val select: Select?
    public val totalSegments: Int?
}

private data class ScanRequestImpl<T>(
    override val consistentRead: Boolean?,
    override val exclusiveStartKey: T?,
    override val filter: BooleanExpr?,
    override val limit: Int?,
    override val returnConsumedCapacity: ReturnConsumedCapacity?,
    override val segment: Int?,
    override val select: Select?,
    override val totalSegments: Int?,
): ScanRequest<T>

/**
 * A DSL-style builder for instances of [ScanRequest<T>]
 */
@ExperimentalApi
public class ScanRequestBuilder<T> {
    public var consistentRead: Boolean? = null
    public var exclusiveStartKey: T? = null

    public var filter: BooleanExpr? = null

    public fun filter(block: Filter.() -> BooleanExpr?) {
        filter = FilterImpl.run(block)
    }

    public var limit: Int? = null
    public var returnConsumedCapacity: ReturnConsumedCapacity? = null
    public var segment: Int? = null
    public var select: Select? = null
    public var totalSegments: Int? = null

    public fun build(): ScanRequest<T> {
        val consistentRead = consistentRead
        val exclusiveStartKey = exclusiveStartKey
        val filter = filter
        val limit = limit
        val returnConsumedCapacity = returnConsumedCapacity
        val segment = segment
        val select = select
        val totalSegments = totalSegments

        return ScanRequestImpl<T>(
            consistentRead,
            exclusiveStartKey,
            filter,
            limit,
            returnConsumedCapacity,
            segment,
            select,
            totalSegments,
        )
    }
}

@ExperimentalApi
public fun <T> ScanRequest<T>.toBuilder(): ScanRequestBuilder<T> = ScanRequestBuilder<T>().apply {
    consistentRead = this@toBuilder.consistentRead
    exclusiveStartKey = this@toBuilder.exclusiveStartKey
    filter = this@toBuilder.filter
    limit = this@toBuilder.limit
    returnConsumedCapacity = this@toBuilder.returnConsumedCapacity
    segment = this@toBuilder.segment
    select = this@toBuilder.select
    totalSegments = this@toBuilder.totalSegments
}

@ExperimentalApi
public fun <T> ScanRequest<T>.copy(block: ScanRequestBuilder<T>.() -> Unit): ScanRequest<T> =
    toBuilder().apply(block).build()

@ExperimentalApi
public fun <T> ScanRequest(block: ScanRequestBuilder<T>.() -> Unit): ScanRequest<T> =
    ScanRequestBuilder<T>().apply(block).build()

private fun <T> ScanRequest<T>.convert(
    indexName: String?, 
    tableName: String?, 
    schema: ItemSchema<T>,
) = LowLevelScanRequest {
    consistentRead = this@convert.consistentRead
    limit = this@convert.limit
    returnConsumedCapacity = this@convert.returnConsumedCapacity
    segment = this@convert.segment
    select = this@convert.select
    totalSegments = this@convert.totalSegments
    this@convert.exclusiveStartKey?.let { exclusiveStartKey = schema.converter.convertTo(it) }
    this.indexName = indexName
    this.tableName = tableName

    val expressionVisitor = ParameterizingExpressionVisitor()
    filterExpression = this@convert.filter?.accept(expressionVisitor)
    expressionAttributeNames = expressionVisitor.expressionAttributeNames()
    expressionAttributeValues = expressionVisitor.expressionAttributeValues()
}

@ExperimentalApi
public interface ScanResponse<T> {
    @ExperimentalApi
    public companion object { }

    public val consumedCapacity: ConsumedCapacity?
    public val count: Int
    public val items: List<T>?
    public val lastEvaluatedKey: T?
    public val scannedCount: Int
}

private data class ScanResponseImpl<T>(
    override val consumedCapacity: ConsumedCapacity?,
    override val count: Int,
    override val items: List<T>?,
    override val lastEvaluatedKey: T?,
    override val scannedCount: Int,
): ScanResponse<T>

/**
 * A DSL-style builder for instances of [ScanResponse<T>]
 */
@ExperimentalApi
public class ScanResponseBuilder<T> {
    public var consumedCapacity: ConsumedCapacity? = null
    public var count: Int? = null
    public var items: List<T>? = null
    public var lastEvaluatedKey: T? = null
    public var scannedCount: Int? = null

    public fun build(): ScanResponse<T> {
        val consumedCapacity = consumedCapacity
        val count = requireNotNull(count) { "Missing value for count" }
        val items = items
        val lastEvaluatedKey = lastEvaluatedKey
        val scannedCount = requireNotNull(scannedCount) { "Missing value for scannedCount" }

        return ScanResponseImpl<T>(
            consumedCapacity,
            count,
            items,
            lastEvaluatedKey,
            scannedCount,
        )
    }
}

@ExperimentalApi
public fun <T> ScanResponse<T>.toBuilder(): ScanResponseBuilder<T> = ScanResponseBuilder<T>().apply {
    consumedCapacity = this@toBuilder.consumedCapacity
    count = this@toBuilder.count
    items = this@toBuilder.items
    lastEvaluatedKey = this@toBuilder.lastEvaluatedKey
    scannedCount = this@toBuilder.scannedCount
}

@ExperimentalApi
public fun <T> ScanResponse<T>.copy(block: ScanResponseBuilder<T>.() -> Unit): ScanResponse<T> =
    toBuilder().apply(block).build()

@ExperimentalApi
public fun <T> ScanResponse(block: ScanResponseBuilder<T>.() -> Unit): ScanResponse<T> =
    ScanResponseBuilder<T>().apply(block).build()

private fun <T> LowLevelScanResponse.convert(schema: ItemSchema<T>) = ScanResponse<T> {
    consumedCapacity = this@convert.consumedCapacity
    count = this@convert.count
    scannedCount = this@convert.scannedCount
    lastEvaluatedKey = this@convert.lastEvaluatedKey?.toItem()?.let(schema.converter::convertFrom)
    items = this@convert.items?.map { schema.converter.convertFrom(it.toItem()) }
}

internal fun <T> scanOperation(spec: IndexSpec<T>) = Operation(
    initialize = { highLevelReq: ScanRequest<T> -> HReqContextImpl(highLevelReq, spec.schema, MapperContextImpl(spec, "Scan")) },
    serialize = { highLevelReq, schema -> highLevelReq.convert(spec.indexName, spec.tableName, schema) },
    lowLevelInvoke = { lowLevelReq ->
        spec.mapper.client.withWrappedClient { client ->
            client.scan(lowLevelReq)
        }
    },
    deserialize = LowLevelScanResponse::convert,
    interceptors = spec.mapper.config.interceptors,
)

internal fun <T> scanOperation(spec: TableSpec<T>) = Operation(
    initialize = { highLevelReq: ScanRequest<T> -> HReqContextImpl(highLevelReq, spec.schema, MapperContextImpl(spec, "Scan")) },
    serialize = { highLevelReq, schema -> highLevelReq.convert(indexName = null, spec.tableName, schema) },
    lowLevelInvoke = { lowLevelReq ->
        spec.mapper.client.withWrappedClient { client ->
            client.scan(lowLevelReq)
        }
    },
    deserialize = LowLevelScanResponse::convert,
    interceptors = spec.mapper.config.interceptors,
)
