/*
 * Decompiled with CFR 0.152.
 */
package aws.sdk.kotlin.hll.dynamodbmapper.values.smithytypes;

import aws.sdk.kotlin.hll.dynamodbmapper.values.NullableConverter;
import aws.sdk.kotlin.hll.dynamodbmapper.values.collections.ListConverterKt;
import aws.sdk.kotlin.hll.dynamodbmapper.values.collections.MapConverterKt;
import aws.sdk.kotlin.hll.dynamodbmapper.values.scalars.BooleanConverterKt;
import aws.sdk.kotlin.hll.dynamodbmapper.values.scalars.NumberConvertersKt;
import aws.sdk.kotlin.hll.dynamodbmapper.values.scalars.TextConvertersKt;
import aws.sdk.kotlin.hll.mapping.core.converters.Converter;
import aws.sdk.kotlin.hll.mapping.core.converters.SplittingConverter;
import aws.sdk.kotlin.hll.mapping.core.converters.SplittingConverterKt;
import aws.sdk.kotlin.hll.mapping.core.converters.collections.ListMappingConvertersKt;
import aws.sdk.kotlin.hll.mapping.core.converters.collections.MapMappingConvertersKt;
import aws.sdk.kotlin.services.dynamodb.model.AttributeValue;
import aws.smithy.kotlin.runtime.ExperimentalApi;
import aws.smithy.kotlin.runtime.content.Document;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@ExperimentalApi
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\b\b\b\u0007\u0018\u0000 \u00172\u0018\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0004:\u0001\u0017B\u00db\u0001\u0012\u001e\b\u0002\u0010\u0005\u001a\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00030\u0001j\b\u0012\u0004\u0012\u00020\u0006`\u0004\u0012\u001e\b\u0002\u0010\u0007\u001a\u0018\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00030\u0001j\b\u0012\u0004\u0012\u00020\b`\u0004\u0012\u001e\b\u0002\u0010\t\u001a\u0018\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00030\u0001j\b\u0012\u0004\u0012\u00020\n`\u0004\u0012\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\f\u0012*\b\u0002\u0010\r\u001a$\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u000e\u0012\u0004\u0012\u00020\u00030\u0001j\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u000e`\u0004\u00126\b\u0002\u0010\u000f\u001a0\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00030\u0010\u0012\u0004\u0012\u00020\u00030\u0001j\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00030\u0010`\u0004\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J\u0010\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0002H\u0016R$\u0010\u0005\u001a\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00030\u0001j\b\u0012\u0004\u0012\u00020\u0006`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0007\u001a\u0018\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00030\u0001j\b\u0012\u0004\u0012\u00020\b`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\t\u001a\u0018\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00030\u0001j\b\u0012\u0004\u0012\u00020\n`\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0004\u0012\u00020\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\r\u001a\u0016\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u000e\u0012\u0004\u0012\u00020\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u000f\u001a\u001c\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0010\u0012\u0004\u0012\u00020\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Laws/sdk/kotlin/hll/dynamodbmapper/values/smithytypes/DocumentConverter;", "Laws/sdk/kotlin/hll/mapping/core/converters/Converter;", "Laws/smithy/kotlin/runtime/content/Document;", "Laws/sdk/kotlin/services/dynamodb/model/AttributeValue;", "Laws/sdk/kotlin/hll/dynamodbmapper/values/ValueConverter;", "numberConverter", "", "stringConverter", "", "booleanConverter", "", "nullableConverter", "Laws/sdk/kotlin/hll/dynamodbmapper/values/NullableConverter;", "listConverter", "", "mapConverter", "", "<init>", "(Laws/sdk/kotlin/hll/mapping/core/converters/Converter;Laws/sdk/kotlin/hll/mapping/core/converters/Converter;Laws/sdk/kotlin/hll/mapping/core/converters/Converter;Laws/sdk/kotlin/hll/dynamodbmapper/values/NullableConverter;Laws/sdk/kotlin/hll/mapping/core/converters/Converter;Laws/sdk/kotlin/hll/mapping/core/converters/Converter;)V", "convertFrom", "to", "convertTo", "from", "Companion", "dynamodb-mapper"})
@SourceDebugExtension(value={"SMAP\nDocumentConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocumentConverter.kt\naws/sdk/kotlin/hll/dynamodbmapper/values/smithytypes/DocumentConverter\n+ 2 NullableConverter.kt\naws/sdk/kotlin/hll/dynamodbmapper/values/NullableConverterKt\n*L\n1#1,68:1\n40#2:69\n*S KotlinDebug\n*F\n+ 1 DocumentConverter.kt\naws/sdk/kotlin/hll/dynamodbmapper/values/smithytypes/DocumentConverter\n*L\n35#1:69\n*E\n"})
public final class DocumentConverter
implements Converter<Document, AttributeValue> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Converter<Number, AttributeValue> numberConverter;
    @NotNull
    private final Converter<String, AttributeValue> stringConverter;
    @NotNull
    private final Converter<Boolean, AttributeValue> booleanConverter;
    @NotNull
    private final Converter<Document, AttributeValue> nullableConverter;
    @NotNull
    private final Converter<List<Document>, AttributeValue> listConverter;
    @NotNull
    private final Converter<Map<String, Document>, AttributeValue> mapConverter;
    @NotNull
    private static final DocumentConverter Default = new DocumentConverter(null, null, null, null, null, null, 63, null);

    public DocumentConverter(@NotNull Converter<Number, AttributeValue> numberConverter, @NotNull Converter<String, AttributeValue> stringConverter, @NotNull Converter<Boolean, AttributeValue> booleanConverter, @NotNull NullableConverter<Document> nullableConverter, @NotNull Converter<List<AttributeValue>, AttributeValue> listConverter, @NotNull Converter<Map<String, AttributeValue>, AttributeValue> mapConverter) {
        Intrinsics.checkNotNullParameter(numberConverter, (String)"numberConverter");
        Intrinsics.checkNotNullParameter(stringConverter, (String)"stringConverter");
        Intrinsics.checkNotNullParameter(booleanConverter, (String)"booleanConverter");
        Intrinsics.checkNotNullParameter(nullableConverter, (String)"nullableConverter");
        Intrinsics.checkNotNullParameter(listConverter, (String)"listConverter");
        Intrinsics.checkNotNullParameter(mapConverter, (String)"mapConverter");
        this.numberConverter = numberConverter;
        this.stringConverter = stringConverter;
        this.booleanConverter = booleanConverter;
        this.nullableConverter = SplittingConverterKt.mergeBy((SplittingConverter)nullableConverter, (Converter)this);
        this.listConverter = ListMappingConvertersKt.mapFrom(listConverter, this.nullableConverter);
        this.mapConverter = MapMappingConvertersKt.mapValuesFrom(mapConverter, this.nullableConverter);
    }

    public /* synthetic */ DocumentConverter(Converter converter, Converter converter2, Converter converter3, NullableConverter nullableConverter, Converter converter4, Converter converter5, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            converter = NumberConvertersKt.getAutoNumberConverter();
        }
        if ((n & 2) != 0) {
            converter2 = TextConvertersKt.getStringConverter();
        }
        if ((n & 4) != 0) {
            converter3 = BooleanConverterKt.getBooleanConverter();
        }
        if ((n & 8) != 0) {
            boolean $i$f$NullableConverter = false;
            nullableConverter = new NullableConverter<Document>(Reflection.getOrCreateKotlinClass(Document.class));
        }
        if ((n & 0x10) != 0) {
            converter4 = ListConverterKt.getListConverter();
        }
        if ((n & 0x20) != 0) {
            converter5 = MapConverterKt.getMapConverter();
        }
        this(converter, converter2, converter3, nullableConverter, converter4, converter5);
    }

    @NotNull
    public Document convertFrom(@NotNull AttributeValue to) {
        Document document;
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        AttributeValue attributeValue = to;
        if (attributeValue instanceof AttributeValue.N) {
            document = (Document)new Document.Number((Number)this.numberConverter.convertFrom((Object)to));
        } else if (attributeValue instanceof AttributeValue.S) {
            document = (Document)new Document.String((String)this.stringConverter.convertFrom((Object)to));
        } else if (attributeValue instanceof AttributeValue.Bool) {
            document = (Document)new Document.Boolean(((Boolean)this.booleanConverter.convertFrom((Object)to)).booleanValue());
        } else if (attributeValue instanceof AttributeValue.L) {
            document = (Document)new Document.List((List)this.listConverter.convertFrom((Object)to));
        } else if (attributeValue instanceof AttributeValue.M) {
            document = (Document)new Document.Map((Map)this.mapConverter.convertFrom((Object)to));
        } else {
            throw new IllegalArgumentException("Documents do not support " + Reflection.getOrCreateKotlinClass(to.getClass()).getQualifiedName() + " values");
        }
        return document;
    }

    @NotNull
    public AttributeValue convertTo(@NotNull Document from) {
        AttributeValue attributeValue;
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Document document = from;
        if (document instanceof Document.Number) {
            attributeValue = (AttributeValue)this.numberConverter.convertTo((Object)((Document.Number)from).getValue());
        } else if (document instanceof Document.String) {
            attributeValue = (AttributeValue)this.stringConverter.convertTo((Object)((Document.String)from).getValue());
        } else if (document instanceof Document.Boolean) {
            attributeValue = (AttributeValue)this.booleanConverter.convertTo((Object)((Document.Boolean)from).getValue());
        } else if (document instanceof Document.List) {
            attributeValue = (AttributeValue)this.listConverter.convertTo((Object)((Document.List)from).getValue());
        } else if (document instanceof Document.Map) {
            attributeValue = (AttributeValue)this.mapConverter.convertTo((Object)((Document.Map)from).getValue());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return attributeValue;
    }

    public DocumentConverter() {
        this(null, null, null, null, null, null, 63, null);
    }

    @ExperimentalApi
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0087\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Laws/sdk/kotlin/hll/dynamodbmapper/values/smithytypes/DocumentConverter$Companion;", "", "<init>", "()V", "Default", "Laws/sdk/kotlin/hll/dynamodbmapper/values/smithytypes/DocumentConverter;", "getDefault", "()Laws/sdk/kotlin/hll/dynamodbmapper/values/smithytypes/DocumentConverter;", "dynamodb-mapper"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DocumentConverter getDefault() {
            return Default;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

