/*
 * Decompiled with CFR 0.152.
 */
package aws.sdk.kotlin.hll.dynamodbmapper.items;

import aws.sdk.kotlin.hll.dynamodbmapper.items.ItemConverter;
import aws.sdk.kotlin.hll.dynamodbmapper.model.Item;
import aws.sdk.kotlin.hll.dynamodbmapper.model.MutableItem;
import aws.sdk.kotlin.hll.dynamodbmapper.model.MutableItemKt;
import aws.sdk.kotlin.services.dynamodb.model.AttributeValue;
import aws.smithy.kotlin.runtime.ExperimentalApi;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ExperimentalApi
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0002\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B=\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\u0011\u001a\u00028\u00002\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014J%\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00028\u00002\u000e\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0018H\u0016\u00a2\u0006\u0002\u0010\u0019R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR#\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001a"}, d2={"Laws/sdk/kotlin/hll/dynamodbmapper/items/HeterogeneousItemConverter;", "T", "Laws/sdk/kotlin/hll/dynamodbmapper/items/ItemConverter;", "typeMapper", "Lkotlin/Function1;", "", "typeAttribute", "subConverters", "", "<init>", "(Lkotlin/jvm/functions/Function1;Ljava/lang/String;Ljava/util/Map;)V", "getTypeMapper", "()Lkotlin/jvm/functions/Function1;", "getTypeAttribute", "()Ljava/lang/String;", "getSubConverters", "()Ljava/util/Map;", "convertFrom", "to", "Laws/sdk/kotlin/hll/dynamodbmapper/model/Item;", "(Laws/sdk/kotlin/hll/dynamodbmapper/model/Item;)Ljava/lang/Object;", "convertTo", "from", "onlyAttributes", "", "(Ljava/lang/Object;Ljava/util/Set;)Laws/sdk/kotlin/hll/dynamodbmapper/model/Item;", "dynamodb-mapper"})
@SourceDebugExtension(value={"SMAP\nHeterogeneousItemConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HeterogeneousItemConverter.kt\naws/sdk/kotlin/hll/dynamodbmapper/items/HeterogeneousItemConverter\n+ 2 Item.kt\naws/sdk/kotlin/hll/dynamodbmapper/model/ItemKt\n*L\n1#1,124:1\n27#2:125\n*S KotlinDebug\n*F\n+ 1 HeterogeneousItemConverter.kt\naws/sdk/kotlin/hll/dynamodbmapper/items/HeterogeneousItemConverter\n*L\n115#1:125\n*E\n"})
public final class HeterogeneousItemConverter<T>
implements ItemConverter<T> {
    @NotNull
    private final Function1<T, String> typeMapper;
    @NotNull
    private final String typeAttribute;
    @NotNull
    private final Map<String, ItemConverter<T>> subConverters;

    public HeterogeneousItemConverter(@NotNull Function1<? super T, String> typeMapper, @NotNull String typeAttribute, @NotNull Map<String, ? extends ItemConverter<T>> subConverters) {
        Intrinsics.checkNotNullParameter(typeMapper, (String)"typeMapper");
        Intrinsics.checkNotNullParameter((Object)typeAttribute, (String)"typeAttribute");
        Intrinsics.checkNotNullParameter(subConverters, (String)"subConverters");
        this.typeMapper = typeMapper;
        this.typeAttribute = typeAttribute;
        this.subConverters = subConverters;
    }

    @NotNull
    public final Function1<T, String> getTypeMapper() {
        return this.typeMapper;
    }

    @NotNull
    public final String getTypeAttribute() {
        return this.typeAttribute;
    }

    @NotNull
    public final Map<String, ItemConverter<T>> getSubConverters() {
        return this.subConverters;
    }

    public T convertFrom(@NotNull Item to) {
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        AttributeValue attributeValue = (AttributeValue)to.get(this.typeAttribute);
        if (attributeValue == null) {
            throw new IllegalStateException(("Missing " + this.typeAttribute).toString());
        }
        AttributeValue attr = attributeValue;
        String string = attr.asSOrNull();
        if (string == null) {
            throw new IllegalStateException(("No string value for " + attr).toString());
        }
        String typeValue = string;
        ItemConverter<T> itemConverter = this.subConverters.get(typeValue);
        if (itemConverter == null) {
            throw new IllegalStateException(("No converter for " + typeValue).toString());
        }
        ItemConverter<T> converter = itemConverter;
        return (T)converter.convertFrom(to);
    }

    @Override
    @NotNull
    public Item convertTo(T from, @Nullable Set<String> onlyAttributes) {
        MutableItem mutableItem;
        String typeValue = (String)this.typeMapper.invoke(from);
        ItemConverter<T> itemConverter = this.subConverters.get(typeValue);
        if (itemConverter == null) {
            throw new IllegalStateException(("No converter for " + typeValue).toString());
        }
        ItemConverter<T> converter = itemConverter;
        boolean $i$f$buildItem = false;
        MutableItem $this$convertTo_u24lambda_u240 = mutableItem = MutableItemKt.toMutableItem(new LinkedHashMap());
        boolean bl = false;
        Set<String> set = onlyAttributes;
        if (!(set != null ? !set.contains(this.typeAttribute) : false)) {
            $this$convertTo_u24lambda_u240.put(this.typeAttribute, new AttributeValue.S(typeValue));
        }
        $this$convertTo_u24lambda_u240.putAll(converter.convertTo(from, onlyAttributes));
        return MutableItemKt.toItem(mutableItem);
    }

    @Override
    @NotNull
    public Item convertTo(T from) {
        return ItemConverter.DefaultImpls.convertTo(this, from);
    }
}

