// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dynamodb.waiters

import aws.sdk.kotlin.services.dynamodb.DynamoDbClient
import aws.sdk.kotlin.services.dynamodb.model.DescribeTableRequest
import aws.sdk.kotlin.services.dynamodb.model.DescribeTableResponse
import aws.smithy.kotlin.runtime.retries.Outcome
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.delay.InfiniteTokenBucket
import aws.smithy.kotlin.runtime.retries.policy.Acceptor
import aws.smithy.kotlin.runtime.retries.policy.AcceptorRetryPolicy
import aws.smithy.kotlin.runtime.retries.policy.ErrorTypeAcceptor
import aws.smithy.kotlin.runtime.retries.policy.OutputAcceptor
import aws.smithy.kotlin.runtime.retries.policy.RetryDirective
import aws.smithy.kotlin.runtime.retries.policy.RetryErrorType
import kotlin.time.Duration.Companion.milliseconds


public suspend fun DynamoDbClient.waitUntilTableExists(request: DescribeTableRequest): Outcome<DescribeTableResponse> {
    val strategy = StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 20_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeTableRequest, DescribeTableResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val table = it.table
            val tableStatus = table?.tableStatus?.value
            tableStatus == "ACTIVE"
        },
        ErrorTypeAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide), "ResourceNotFoundException"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeTable(request) }
}

public suspend fun DynamoDbClient.waitUntilTableExists(block: DescribeTableRequest.Builder.() -> Unit): Outcome<DescribeTableResponse> =
    waitUntilTableExists(DescribeTableRequest.Builder().apply(block).build())

public suspend fun DynamoDbClient.waitUntilTableNotExists(request: DescribeTableRequest): Outcome<DescribeTableResponse> {
    val strategy = StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 20_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<DescribeTableRequest, DescribeTableResponse>>(
        ErrorTypeAcceptor(RetryDirective.TerminateAndSucceed, "ResourceNotFoundException"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { describeTable(request) }
}

public suspend fun DynamoDbClient.waitUntilTableNotExists(block: DescribeTableRequest.Builder.() -> Unit): Outcome<DescribeTableResponse> =
    waitUntilTableNotExists(DescribeTableRequest.Builder().apply(block).build())
