// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dynamodb.serde

import aws.sdk.kotlin.services.dynamodb.model.AttributeValue
import aws.sdk.kotlin.services.dynamodb.model.Condition
import aws.sdk.kotlin.services.dynamodb.model.ConditionalOperator
import aws.sdk.kotlin.services.dynamodb.model.QueryRequest
import aws.sdk.kotlin.services.dynamodb.model.ReturnConsumedCapacity
import aws.sdk.kotlin.services.dynamodb.model.Select
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class QueryOperationSerializer: HttpSerialize<QueryRequest> {
    override suspend fun serialize(context: ExecutionContext, input: QueryRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/"
        }

        val payload = serializeQueryOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.0")
        }
        return builder
    }
}

private fun serializeQueryOperationBody(context: ExecutionContext, input: QueryRequest): ByteArray {
    val serializer = JsonSerializer()
    val ATTRIBUTESTOGET_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("AttributesToGet"))
    val CONDITIONALOPERATOR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("ConditionalOperator"))
    val CONSISTENTREAD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("ConsistentRead"))
    val EXCLUSIVESTARTKEY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("ExclusiveStartKey"))
    val EXPRESSIONATTRIBUTENAMES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("ExpressionAttributeNames"))
    val EXPRESSIONATTRIBUTEVALUES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("ExpressionAttributeValues"))
    val FILTEREXPRESSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FilterExpression"))
    val INDEXNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("IndexName"))
    val KEYCONDITIONEXPRESSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("KeyConditionExpression"))
    val KEYCONDITIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("KeyConditions"))
    val LIMIT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("Limit"))
    val PROJECTIONEXPRESSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ProjectionExpression"))
    val QUERYFILTER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("QueryFilter"))
    val RETURNCONSUMEDCAPACITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("ReturnConsumedCapacity"))
    val SCANINDEXFORWARD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("ScanIndexForward"))
    val SELECT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Select"))
    val TABLENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TableName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ATTRIBUTESTOGET_DESCRIPTOR)
        field(CONDITIONALOPERATOR_DESCRIPTOR)
        field(CONSISTENTREAD_DESCRIPTOR)
        field(EXCLUSIVESTARTKEY_DESCRIPTOR)
        field(EXPRESSIONATTRIBUTENAMES_DESCRIPTOR)
        field(EXPRESSIONATTRIBUTEVALUES_DESCRIPTOR)
        field(FILTEREXPRESSION_DESCRIPTOR)
        field(INDEXNAME_DESCRIPTOR)
        field(KEYCONDITIONEXPRESSION_DESCRIPTOR)
        field(KEYCONDITIONS_DESCRIPTOR)
        field(LIMIT_DESCRIPTOR)
        field(PROJECTIONEXPRESSION_DESCRIPTOR)
        field(QUERYFILTER_DESCRIPTOR)
        field(RETURNCONSUMEDCAPACITY_DESCRIPTOR)
        field(SCANINDEXFORWARD_DESCRIPTOR)
        field(SELECT_DESCRIPTOR)
        field(TABLENAME_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.attributesToGet != null) {
            listField(ATTRIBUTESTOGET_DESCRIPTOR) {
                for (el0 in input.attributesToGet) {
                    serializeString(el0)
                }
            }
        }
        input.conditionalOperator?.let { field(CONDITIONALOPERATOR_DESCRIPTOR, it.value) }
        input.consistentRead?.let { field(CONSISTENTREAD_DESCRIPTOR, it) }
        if (input.exclusiveStartKey != null) {
            mapField(EXCLUSIVESTARTKEY_DESCRIPTOR) {
                input.exclusiveStartKey.forEach { (key, value) -> entry(key, asSdkSerializable(value, ::serializeAttributeValueDocument)) }
            }
        }
        if (input.expressionAttributeNames != null) {
            mapField(EXPRESSIONATTRIBUTENAMES_DESCRIPTOR) {
                input.expressionAttributeNames.forEach { (key, value) -> entry(key, value) }
            }
        }
        if (input.expressionAttributeValues != null) {
            mapField(EXPRESSIONATTRIBUTEVALUES_DESCRIPTOR) {
                input.expressionAttributeValues.forEach { (key, value) -> entry(key, asSdkSerializable(value, ::serializeAttributeValueDocument)) }
            }
        }
        input.filterExpression?.let { field(FILTEREXPRESSION_DESCRIPTOR, it) }
        input.indexName?.let { field(INDEXNAME_DESCRIPTOR, it) }
        input.keyConditionExpression?.let { field(KEYCONDITIONEXPRESSION_DESCRIPTOR, it) }
        if (input.keyConditions != null) {
            mapField(KEYCONDITIONS_DESCRIPTOR) {
                input.keyConditions.forEach { (key, value) -> entry(key, asSdkSerializable(value, ::serializeConditionDocument)) }
            }
        }
        input.limit?.let { field(LIMIT_DESCRIPTOR, it) }
        input.projectionExpression?.let { field(PROJECTIONEXPRESSION_DESCRIPTOR, it) }
        if (input.queryFilter != null) {
            mapField(QUERYFILTER_DESCRIPTOR) {
                input.queryFilter.forEach { (key, value) -> entry(key, asSdkSerializable(value, ::serializeConditionDocument)) }
            }
        }
        input.returnConsumedCapacity?.let { field(RETURNCONSUMEDCAPACITY_DESCRIPTOR, it.value) }
        input.scanIndexForward?.let { field(SCANINDEXFORWARD_DESCRIPTOR, it) }
        input.select?.let { field(SELECT_DESCRIPTOR, it.value) }
        input.tableName?.let { field(TABLENAME_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
