// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dynamodb.serde

import aws.sdk.kotlin.services.dynamodb.model.BackupTypeFilter
import aws.sdk.kotlin.services.dynamodb.model.ListBackupsRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class ListBackupsOperationSerializer: HttpSerialize<ListBackupsRequest> {
    override suspend fun serialize(context: ExecutionContext, input: ListBackupsRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/"
        }

        val payload = serializeListBackupsOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.0")
        }
        return builder
    }
}

private fun serializeListBackupsOperationBody(context: ExecutionContext, input: ListBackupsRequest): ByteArray {
    val serializer = JsonSerializer()
    val BACKUPTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("BackupType"))
    val EXCLUSIVESTARTBACKUPARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ExclusiveStartBackupArn"))
    val LIMIT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("Limit"))
    val TABLENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TableName"))
    val TIMERANGELOWERBOUND_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("TimeRangeLowerBound"))
    val TIMERANGEUPPERBOUND_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("TimeRangeUpperBound"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BACKUPTYPE_DESCRIPTOR)
        field(EXCLUSIVESTARTBACKUPARN_DESCRIPTOR)
        field(LIMIT_DESCRIPTOR)
        field(TABLENAME_DESCRIPTOR)
        field(TIMERANGELOWERBOUND_DESCRIPTOR)
        field(TIMERANGEUPPERBOUND_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.backupType?.let { field(BACKUPTYPE_DESCRIPTOR, it.value) }
        input.exclusiveStartBackupArn?.let { field(EXCLUSIVESTARTBACKUPARN_DESCRIPTOR, it) }
        input.limit?.let { field(LIMIT_DESCRIPTOR, it) }
        input.tableName?.let { field(TABLENAME_DESCRIPTOR, it) }
        input.timeRangeLowerBound?.let { field(TIMERANGELOWERBOUND_DESCRIPTOR, it, TimestampFormat.EPOCH_SECONDS) }
        input.timeRangeUpperBound?.let { field(TIMERANGEUPPERBOUND_DESCRIPTOR, it, TimestampFormat.EPOCH_SECONDS) }
    }
    return serializer.toByteArray()
}
