// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dynamodb.serde

import aws.sdk.kotlin.services.dynamodb.model.BatchWriteItemRequest
import aws.sdk.kotlin.services.dynamodb.model.ReturnConsumedCapacity
import aws.sdk.kotlin.services.dynamodb.model.ReturnItemCollectionMetrics
import aws.sdk.kotlin.services.dynamodb.model.WriteRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class BatchWriteItemOperationSerializer: HttpSerialize<BatchWriteItemRequest> {
    override suspend fun serialize(context: ExecutionContext, input: BatchWriteItemRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/"
        }

        val payload = serializeBatchWriteItemOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.0")
        }
        return builder
    }
}

private fun serializeBatchWriteItemOperationBody(context: ExecutionContext, input: BatchWriteItemRequest): ByteArray {
    val serializer = JsonSerializer()
    val REQUESTITEMS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("RequestItems"))
    val REQUESTITEMS_C0_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List)
    val RETURNCONSUMEDCAPACITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("ReturnConsumedCapacity"))
    val RETURNITEMCOLLECTIONMETRICS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("ReturnItemCollectionMetrics"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(REQUESTITEMS_DESCRIPTOR)
        field(RETURNCONSUMEDCAPACITY_DESCRIPTOR)
        field(RETURNITEMCOLLECTIONMETRICS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.requestItems != null) {
            mapField(REQUESTITEMS_DESCRIPTOR) {
                input.requestItems.forEach { (key, value) ->
                    listEntry(key, REQUESTITEMS_C0_DESCRIPTOR) {
                        for (el1 in value) {
                            serializeSdkSerializable(asSdkSerializable(el1, ::serializeWriteRequestDocument))
                        }
                    }
                }
            }
        }
        input.returnConsumedCapacity?.let { field(RETURNCONSUMEDCAPACITY_DESCRIPTOR, it.value) }
        input.returnItemCollectionMetrics?.let { field(RETURNITEMCOLLECTIONMETRICS_DESCRIPTOR, it.value) }
    }
    return serializer.toByteArray()
}
