// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dynamodb.model



/**
 * Represents the output of an `UpdateItem` operation.
 */
public class UpdateItemResponse private constructor(builder: Builder) {
    /**
     * A map of attribute values as they appear before or after the `UpdateItem` operation, as determined by the `ReturnValues` parameter.
     *
     * The `Attributes` map is only present if the update was successful and `ReturnValues` was specified as something other than `NONE` in the request. Each element represents one attribute.
     */
    public val attributes: Map<String, AttributeValue>? = builder.attributes
    /**
     * The capacity units consumed by the `UpdateItem` operation. The data returned includes the total provisioned throughput consumed, along with statistics for the table and any indexes involved in the operation. `ConsumedCapacity` is only returned if the `ReturnConsumedCapacity` parameter was specified. For more information, see [Provisioned Throughput](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughput.html#ItemSizeCalculations.Reads) in the *Amazon DynamoDB Developer Guide*.
     */
    public val consumedCapacity: aws.sdk.kotlin.services.dynamodb.model.ConsumedCapacity? = builder.consumedCapacity
    /**
     * Information about item collections, if any, that were affected by the `UpdateItem` operation. `ItemCollectionMetrics` is only returned if the `ReturnItemCollectionMetrics` parameter was specified. If the table does not have any local secondary indexes, this information is not returned in the response.
     *
     * Each `ItemCollectionMetrics` element consists of:
     * + `ItemCollectionKey` - The partition key value of the item collection. This is the same as the partition key value of the item itself.
     * + `SizeEstimateRangeGB` - An estimate of item collection size, in gigabytes. This value is a two-element array containing a lower bound and an upper bound for the estimate. The estimate includes the size of all the items in the table, plus the size of all attributes projected into all of the local secondary indexes on that table. Use this estimate to measure whether a local secondary index is approaching its size limit.The estimate is subject to change over time; therefore, do not rely on the precision or accuracy of the estimate.
     */
    public val itemCollectionMetrics: aws.sdk.kotlin.services.dynamodb.model.ItemCollectionMetrics? = builder.itemCollectionMetrics

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dynamodb.model.UpdateItemResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateItemResponse(")
        append("attributes=$attributes,")
        append("consumedCapacity=$consumedCapacity,")
        append("itemCollectionMetrics=$itemCollectionMetrics")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributes?.hashCode() ?: 0
        result = 31 * result + (consumedCapacity?.hashCode() ?: 0)
        result = 31 * result + (itemCollectionMetrics?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateItemResponse

        if (attributes != other.attributes) return false
        if (consumedCapacity != other.consumedCapacity) return false
        if (itemCollectionMetrics != other.itemCollectionMetrics) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dynamodb.model.UpdateItemResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A map of attribute values as they appear before or after the `UpdateItem` operation, as determined by the `ReturnValues` parameter.
         *
         * The `Attributes` map is only present if the update was successful and `ReturnValues` was specified as something other than `NONE` in the request. Each element represents one attribute.
         */
        public var attributes: Map<String, AttributeValue>? = null
        /**
         * The capacity units consumed by the `UpdateItem` operation. The data returned includes the total provisioned throughput consumed, along with statistics for the table and any indexes involved in the operation. `ConsumedCapacity` is only returned if the `ReturnConsumedCapacity` parameter was specified. For more information, see [Provisioned Throughput](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughput.html#ItemSizeCalculations.Reads) in the *Amazon DynamoDB Developer Guide*.
         */
        public var consumedCapacity: aws.sdk.kotlin.services.dynamodb.model.ConsumedCapacity? = null
        /**
         * Information about item collections, if any, that were affected by the `UpdateItem` operation. `ItemCollectionMetrics` is only returned if the `ReturnItemCollectionMetrics` parameter was specified. If the table does not have any local secondary indexes, this information is not returned in the response.
         *
         * Each `ItemCollectionMetrics` element consists of:
         * + `ItemCollectionKey` - The partition key value of the item collection. This is the same as the partition key value of the item itself.
         * + `SizeEstimateRangeGB` - An estimate of item collection size, in gigabytes. This value is a two-element array containing a lower bound and an upper bound for the estimate. The estimate includes the size of all the items in the table, plus the size of all attributes projected into all of the local secondary indexes on that table. Use this estimate to measure whether a local secondary index is approaching its size limit.The estimate is subject to change over time; therefore, do not rely on the precision or accuracy of the estimate.
         */
        public var itemCollectionMetrics: aws.sdk.kotlin.services.dynamodb.model.ItemCollectionMetrics? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dynamodb.model.UpdateItemResponse) : this() {
            this.attributes = x.attributes
            this.consumedCapacity = x.consumedCapacity
            this.itemCollectionMetrics = x.itemCollectionMetrics
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dynamodb.model.UpdateItemResponse = UpdateItemResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.dynamodb.model.ConsumedCapacity] inside the given [block]
         */
        public fun consumedCapacity(block: aws.sdk.kotlin.services.dynamodb.model.ConsumedCapacity.Builder.() -> kotlin.Unit) {
            this.consumedCapacity = aws.sdk.kotlin.services.dynamodb.model.ConsumedCapacity.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.dynamodb.model.ItemCollectionMetrics] inside the given [block]
         */
        public fun itemCollectionMetrics(block: aws.sdk.kotlin.services.dynamodb.model.ItemCollectionMetrics.Builder.() -> kotlin.Unit) {
            this.itemCollectionMetrics = aws.sdk.kotlin.services.dynamodb.model.ItemCollectionMetrics.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
