// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dynamodb.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Represents the properties of a table.
 */
public class TableDescription private constructor(builder: Builder) {
    /**
     * Contains information about the table archive.
     */
    public val archivalSummary: aws.sdk.kotlin.services.dynamodb.model.ArchivalSummary? = builder.archivalSummary
    /**
     * An array of `AttributeDefinition` objects. Each of these objects describes one attribute in the table and index key schema.
     *
     * Each `AttributeDefinition` object in this array is composed of:
     * + `AttributeName` - The name of the attribute.
     * + `AttributeType` - The data type for the attribute.
     */
    public val attributeDefinitions: List<AttributeDefinition>? = builder.attributeDefinitions
    /**
     * Contains the details for the read/write capacity mode.
     */
    public val billingModeSummary: aws.sdk.kotlin.services.dynamodb.model.BillingModeSummary? = builder.billingModeSummary
    /**
     * The date and time when the table was created, in [UNIX epoch time](http://www.epochconverter.com/) format.
     */
    public val creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDateTime
    /**
     * Indicates whether deletion protection is enabled (true) or disabled (false) on the table.
     */
    public val deletionProtectionEnabled: kotlin.Boolean? = builder.deletionProtectionEnabled
    /**
     * The global secondary indexes, if any, on the table. Each index is scoped to a given partition key value. Each element is composed of:
     * + `Backfilling` - If true, then the index is currently in the backfilling phase. Backfilling occurs only when a new global secondary index is added to the table. It is the process by which DynamoDB populates the new index with data from the table. (This attribute does not appear for indexes that were created during a `CreateTable` operation.)  You can delete an index that is being created during the `Backfilling` phase when `IndexStatus` is set to CREATING and `Backfilling` is true. You can't delete the index that is being created when `IndexStatus` is set to CREATING and `Backfilling` is false. (This attribute does not appear for indexes that were created during a `CreateTable` operation.)
     * + `IndexName` - The name of the global secondary index.
     * + `IndexSizeBytes` - The total size of the global secondary index, in bytes. DynamoDB updates this value approximately every six hours. Recent changes might not be reflected in this value.
     * + `IndexStatus` - The current status of the global secondary index:
     *    + `CREATING` - The index is being created.
     *    + `UPDATING` - The index is being updated.
     *    + `DELETING` - The index is being deleted.
     *    + `ACTIVE` - The index is ready for use.
     * + `ItemCount` - The number of items in the global secondary index. DynamoDB updates this value approximately every six hours. Recent changes might not be reflected in this value.
     * + `KeySchema` - Specifies the complete index key schema. The attribute names in the key schema must be between 1 and 255 characters (inclusive). The key schema must begin with the same partition key as the table.
     * + `Projection` - Specifies attributes that are copied (projected) from the table into the index. These are in addition to the primary key attributes and index key attributes, which are automatically projected. Each attribute specification is composed of:
     *    + `ProjectionType` - One of the following:
     *       + `KEYS_ONLY` - Only the index and primary keys are projected into the index.
     *       + `INCLUDE` - In addition to the attributes described in `KEYS_ONLY`, the secondary index will include other non-key attributes that you specify.
     *       + `ALL` - All of the table attributes are projected into the index.
     *    + `NonKeyAttributes` - A list of one or more non-key attribute names that are projected into the secondary index. The total count of attributes provided in `NonKeyAttributes`, summed across all of the secondary indexes, must not exceed 100. If you project the same attribute into two different indexes, this counts as two distinct attributes when determining the total.
     * + `ProvisionedThroughput` - The provisioned throughput settings for the global secondary index, consisting of read and write capacity units, along with data about increases and decreases.
     *
     * If the table is in the `DELETING` state, no information about indexes will be returned.
     */
    public val globalSecondaryIndexes: List<GlobalSecondaryIndexDescription>? = builder.globalSecondaryIndexes
    /**
     * Represents the version of [global tables](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/GlobalTables.html) in use, if the table is replicated across Amazon Web Services Regions.
     */
    public val globalTableVersion: kotlin.String? = builder.globalTableVersion
    /**
     * The number of items in the specified table. DynamoDB updates this value approximately every six hours. Recent changes might not be reflected in this value.
     */
    public val itemCount: kotlin.Long? = builder.itemCount
    /**
     * The primary key structure for the table. Each `KeySchemaElement` consists of:
     * + `AttributeName` - The name of the attribute.
     * + `KeyType` - The role of the attribute:
     *    + `HASH` - partition key
     *    + `RANGE` - sort key
     * The partition key of an item is also known as its *hash attribute*. The term "hash attribute" derives from DynamoDB's usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.The sort key of an item is also known as its *range attribute*. The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.
     *
     * For more information about primary keys, see [Primary Key](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataModel.html#DataModelPrimaryKey) in the *Amazon DynamoDB Developer Guide*.
     */
    public val keySchema: List<KeySchemaElement>? = builder.keySchema
    /**
     * The Amazon Resource Name (ARN) that uniquely identifies the latest stream for this table.
     */
    public val latestStreamArn: kotlin.String? = builder.latestStreamArn
    /**
     * A timestamp, in ISO 8601 format, for this stream.
     *
     * Note that `LatestStreamLabel` is not a unique identifier for the stream, because it is possible that a stream from another table might have the same timestamp. However, the combination of the following three elements is guaranteed to be unique:
     * + Amazon Web Services customer ID
     * + Table name
     * + `StreamLabel`
     */
    public val latestStreamLabel: kotlin.String? = builder.latestStreamLabel
    /**
     * Represents one or more local secondary indexes on the table. Each index is scoped to a given partition key value. Tables with one or more local secondary indexes are subject to an item collection size limit, where the amount of data within a given item collection cannot exceed 10 GB. Each element is composed of:
     * + `IndexName` - The name of the local secondary index.
     * + `KeySchema` - Specifies the complete index key schema. The attribute names in the key schema must be between 1 and 255 characters (inclusive). The key schema must begin with the same partition key as the table.
     * + `Projection` - Specifies attributes that are copied (projected) from the table into the index. These are in addition to the primary key attributes and index key attributes, which are automatically projected. Each attribute specification is composed of:
     *    + `ProjectionType` - One of the following:
     *       + `KEYS_ONLY` - Only the index and primary keys are projected into the index.
     *       + `INCLUDE` - Only the specified table attributes are projected into the index. The list of projected attributes is in `NonKeyAttributes`.
     *       + `ALL` - All of the table attributes are projected into the index.
     *    + `NonKeyAttributes` - A list of one or more non-key attribute names that are projected into the secondary index. The total count of attributes provided in `NonKeyAttributes`, summed across all of the secondary indexes, must not exceed 100. If you project the same attribute into two different indexes, this counts as two distinct attributes when determining the total.
     * + `IndexSizeBytes` - Represents the total size of the index, in bytes. DynamoDB updates this value approximately every six hours. Recent changes might not be reflected in this value.
     * + `ItemCount` - Represents the number of items in the index. DynamoDB updates this value approximately every six hours. Recent changes might not be reflected in this value.
     *
     * If the table is in the `DELETING` state, no information about indexes will be returned.
     */
    public val localSecondaryIndexes: List<LocalSecondaryIndexDescription>? = builder.localSecondaryIndexes
    /**
     * The provisioned throughput settings for the table, consisting of read and write capacity units, along with data about increases and decreases.
     */
    public val provisionedThroughput: aws.sdk.kotlin.services.dynamodb.model.ProvisionedThroughputDescription? = builder.provisionedThroughput
    /**
     * Represents replicas of the table.
     */
    public val replicas: List<ReplicaDescription>? = builder.replicas
    /**
     * Contains details for the restore.
     */
    public val restoreSummary: aws.sdk.kotlin.services.dynamodb.model.RestoreSummary? = builder.restoreSummary
    /**
     * The description of the server-side encryption status on the specified table.
     */
    public val sseDescription: aws.sdk.kotlin.services.dynamodb.model.SseDescription? = builder.sseDescription
    /**
     * The current DynamoDB Streams configuration for the table.
     */
    public val streamSpecification: aws.sdk.kotlin.services.dynamodb.model.StreamSpecification? = builder.streamSpecification
    /**
     * The Amazon Resource Name (ARN) that uniquely identifies the table.
     */
    public val tableArn: kotlin.String? = builder.tableArn
    /**
     * Contains details of the table class.
     */
    public val tableClassSummary: aws.sdk.kotlin.services.dynamodb.model.TableClassSummary? = builder.tableClassSummary
    /**
     * Unique identifier for the table for which the backup was created.
     */
    public val tableId: kotlin.String? = builder.tableId
    /**
     * The name of the table.
     */
    public val tableName: kotlin.String? = builder.tableName
    /**
     * The total size of the specified table, in bytes. DynamoDB updates this value approximately every six hours. Recent changes might not be reflected in this value.
     */
    public val tableSizeBytes: kotlin.Long? = builder.tableSizeBytes
    /**
     * The current state of the table:
     * + `CREATING` - The table is being created.
     * + `UPDATING` - The table/index configuration is being updated. The table/index remains available for data operations when `UPDATING`.
     * + `DELETING` - The table is being deleted.
     * + `ACTIVE` - The table is ready for use.
     * + `INACCESSIBLE_ENCRYPTION_CREDENTIALS` - The KMS key used to encrypt the table in inaccessible. Table operations may fail due to failure to use the KMS key. DynamoDB will initiate the table archival process when a table's KMS key remains inaccessible for more than seven days.
     * + `ARCHIVING` - The table is being archived. Operations are not allowed until archival is complete.
     * + `ARCHIVED` - The table has been archived. See the ArchivalReason for more information.
     */
    public val tableStatus: aws.sdk.kotlin.services.dynamodb.model.TableStatus? = builder.tableStatus

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dynamodb.model.TableDescription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TableDescription(")
        append("archivalSummary=$archivalSummary,")
        append("attributeDefinitions=$attributeDefinitions,")
        append("billingModeSummary=$billingModeSummary,")
        append("creationDateTime=$creationDateTime,")
        append("deletionProtectionEnabled=$deletionProtectionEnabled,")
        append("globalSecondaryIndexes=$globalSecondaryIndexes,")
        append("globalTableVersion=$globalTableVersion,")
        append("itemCount=$itemCount,")
        append("keySchema=$keySchema,")
        append("latestStreamArn=$latestStreamArn,")
        append("latestStreamLabel=$latestStreamLabel,")
        append("localSecondaryIndexes=$localSecondaryIndexes,")
        append("provisionedThroughput=$provisionedThroughput,")
        append("replicas=$replicas,")
        append("restoreSummary=$restoreSummary,")
        append("sseDescription=$sseDescription,")
        append("streamSpecification=$streamSpecification,")
        append("tableArn=$tableArn,")
        append("tableClassSummary=$tableClassSummary,")
        append("tableId=$tableId,")
        append("tableName=$tableName,")
        append("tableSizeBytes=$tableSizeBytes,")
        append("tableStatus=$tableStatus")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = archivalSummary?.hashCode() ?: 0
        result = 31 * result + (attributeDefinitions?.hashCode() ?: 0)
        result = 31 * result + (billingModeSummary?.hashCode() ?: 0)
        result = 31 * result + (creationDateTime?.hashCode() ?: 0)
        result = 31 * result + (deletionProtectionEnabled?.hashCode() ?: 0)
        result = 31 * result + (globalSecondaryIndexes?.hashCode() ?: 0)
        result = 31 * result + (globalTableVersion?.hashCode() ?: 0)
        result = 31 * result + (itemCount?.hashCode() ?: 0)
        result = 31 * result + (keySchema?.hashCode() ?: 0)
        result = 31 * result + (latestStreamArn?.hashCode() ?: 0)
        result = 31 * result + (latestStreamLabel?.hashCode() ?: 0)
        result = 31 * result + (localSecondaryIndexes?.hashCode() ?: 0)
        result = 31 * result + (provisionedThroughput?.hashCode() ?: 0)
        result = 31 * result + (replicas?.hashCode() ?: 0)
        result = 31 * result + (restoreSummary?.hashCode() ?: 0)
        result = 31 * result + (sseDescription?.hashCode() ?: 0)
        result = 31 * result + (streamSpecification?.hashCode() ?: 0)
        result = 31 * result + (tableArn?.hashCode() ?: 0)
        result = 31 * result + (tableClassSummary?.hashCode() ?: 0)
        result = 31 * result + (tableId?.hashCode() ?: 0)
        result = 31 * result + (tableName?.hashCode() ?: 0)
        result = 31 * result + (tableSizeBytes?.hashCode() ?: 0)
        result = 31 * result + (tableStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TableDescription

        if (archivalSummary != other.archivalSummary) return false
        if (attributeDefinitions != other.attributeDefinitions) return false
        if (billingModeSummary != other.billingModeSummary) return false
        if (creationDateTime != other.creationDateTime) return false
        if (deletionProtectionEnabled != other.deletionProtectionEnabled) return false
        if (globalSecondaryIndexes != other.globalSecondaryIndexes) return false
        if (globalTableVersion != other.globalTableVersion) return false
        if (itemCount != other.itemCount) return false
        if (keySchema != other.keySchema) return false
        if (latestStreamArn != other.latestStreamArn) return false
        if (latestStreamLabel != other.latestStreamLabel) return false
        if (localSecondaryIndexes != other.localSecondaryIndexes) return false
        if (provisionedThroughput != other.provisionedThroughput) return false
        if (replicas != other.replicas) return false
        if (restoreSummary != other.restoreSummary) return false
        if (sseDescription != other.sseDescription) return false
        if (streamSpecification != other.streamSpecification) return false
        if (tableArn != other.tableArn) return false
        if (tableClassSummary != other.tableClassSummary) return false
        if (tableId != other.tableId) return false
        if (tableName != other.tableName) return false
        if (tableSizeBytes != other.tableSizeBytes) return false
        if (tableStatus != other.tableStatus) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dynamodb.model.TableDescription = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Contains information about the table archive.
         */
        public var archivalSummary: aws.sdk.kotlin.services.dynamodb.model.ArchivalSummary? = null
        /**
         * An array of `AttributeDefinition` objects. Each of these objects describes one attribute in the table and index key schema.
         *
         * Each `AttributeDefinition` object in this array is composed of:
         * + `AttributeName` - The name of the attribute.
         * + `AttributeType` - The data type for the attribute.
         */
        public var attributeDefinitions: List<AttributeDefinition>? = null
        /**
         * Contains the details for the read/write capacity mode.
         */
        public var billingModeSummary: aws.sdk.kotlin.services.dynamodb.model.BillingModeSummary? = null
        /**
         * The date and time when the table was created, in [UNIX epoch time](http://www.epochconverter.com/) format.
         */
        public var creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Indicates whether deletion protection is enabled (true) or disabled (false) on the table.
         */
        public var deletionProtectionEnabled: kotlin.Boolean? = null
        /**
         * The global secondary indexes, if any, on the table. Each index is scoped to a given partition key value. Each element is composed of:
         * + `Backfilling` - If true, then the index is currently in the backfilling phase. Backfilling occurs only when a new global secondary index is added to the table. It is the process by which DynamoDB populates the new index with data from the table. (This attribute does not appear for indexes that were created during a `CreateTable` operation.)  You can delete an index that is being created during the `Backfilling` phase when `IndexStatus` is set to CREATING and `Backfilling` is true. You can't delete the index that is being created when `IndexStatus` is set to CREATING and `Backfilling` is false. (This attribute does not appear for indexes that were created during a `CreateTable` operation.)
         * + `IndexName` - The name of the global secondary index.
         * + `IndexSizeBytes` - The total size of the global secondary index, in bytes. DynamoDB updates this value approximately every six hours. Recent changes might not be reflected in this value.
         * + `IndexStatus` - The current status of the global secondary index:
         *    + `CREATING` - The index is being created.
         *    + `UPDATING` - The index is being updated.
         *    + `DELETING` - The index is being deleted.
         *    + `ACTIVE` - The index is ready for use.
         * + `ItemCount` - The number of items in the global secondary index. DynamoDB updates this value approximately every six hours. Recent changes might not be reflected in this value.
         * + `KeySchema` - Specifies the complete index key schema. The attribute names in the key schema must be between 1 and 255 characters (inclusive). The key schema must begin with the same partition key as the table.
         * + `Projection` - Specifies attributes that are copied (projected) from the table into the index. These are in addition to the primary key attributes and index key attributes, which are automatically projected. Each attribute specification is composed of:
         *    + `ProjectionType` - One of the following:
         *       + `KEYS_ONLY` - Only the index and primary keys are projected into the index.
         *       + `INCLUDE` - In addition to the attributes described in `KEYS_ONLY`, the secondary index will include other non-key attributes that you specify.
         *       + `ALL` - All of the table attributes are projected into the index.
         *    + `NonKeyAttributes` - A list of one or more non-key attribute names that are projected into the secondary index. The total count of attributes provided in `NonKeyAttributes`, summed across all of the secondary indexes, must not exceed 100. If you project the same attribute into two different indexes, this counts as two distinct attributes when determining the total.
         * + `ProvisionedThroughput` - The provisioned throughput settings for the global secondary index, consisting of read and write capacity units, along with data about increases and decreases.
         *
         * If the table is in the `DELETING` state, no information about indexes will be returned.
         */
        public var globalSecondaryIndexes: List<GlobalSecondaryIndexDescription>? = null
        /**
         * Represents the version of [global tables](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/GlobalTables.html) in use, if the table is replicated across Amazon Web Services Regions.
         */
        public var globalTableVersion: kotlin.String? = null
        /**
         * The number of items in the specified table. DynamoDB updates this value approximately every six hours. Recent changes might not be reflected in this value.
         */
        public var itemCount: kotlin.Long? = null
        /**
         * The primary key structure for the table. Each `KeySchemaElement` consists of:
         * + `AttributeName` - The name of the attribute.
         * + `KeyType` - The role of the attribute:
         *    + `HASH` - partition key
         *    + `RANGE` - sort key
         * The partition key of an item is also known as its *hash attribute*. The term "hash attribute" derives from DynamoDB's usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.The sort key of an item is also known as its *range attribute*. The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.
         *
         * For more information about primary keys, see [Primary Key](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataModel.html#DataModelPrimaryKey) in the *Amazon DynamoDB Developer Guide*.
         */
        public var keySchema: List<KeySchemaElement>? = null
        /**
         * The Amazon Resource Name (ARN) that uniquely identifies the latest stream for this table.
         */
        public var latestStreamArn: kotlin.String? = null
        /**
         * A timestamp, in ISO 8601 format, for this stream.
         *
         * Note that `LatestStreamLabel` is not a unique identifier for the stream, because it is possible that a stream from another table might have the same timestamp. However, the combination of the following three elements is guaranteed to be unique:
         * + Amazon Web Services customer ID
         * + Table name
         * + `StreamLabel`
         */
        public var latestStreamLabel: kotlin.String? = null
        /**
         * Represents one or more local secondary indexes on the table. Each index is scoped to a given partition key value. Tables with one or more local secondary indexes are subject to an item collection size limit, where the amount of data within a given item collection cannot exceed 10 GB. Each element is composed of:
         * + `IndexName` - The name of the local secondary index.
         * + `KeySchema` - Specifies the complete index key schema. The attribute names in the key schema must be between 1 and 255 characters (inclusive). The key schema must begin with the same partition key as the table.
         * + `Projection` - Specifies attributes that are copied (projected) from the table into the index. These are in addition to the primary key attributes and index key attributes, which are automatically projected. Each attribute specification is composed of:
         *    + `ProjectionType` - One of the following:
         *       + `KEYS_ONLY` - Only the index and primary keys are projected into the index.
         *       + `INCLUDE` - Only the specified table attributes are projected into the index. The list of projected attributes is in `NonKeyAttributes`.
         *       + `ALL` - All of the table attributes are projected into the index.
         *    + `NonKeyAttributes` - A list of one or more non-key attribute names that are projected into the secondary index. The total count of attributes provided in `NonKeyAttributes`, summed across all of the secondary indexes, must not exceed 100. If you project the same attribute into two different indexes, this counts as two distinct attributes when determining the total.
         * + `IndexSizeBytes` - Represents the total size of the index, in bytes. DynamoDB updates this value approximately every six hours. Recent changes might not be reflected in this value.
         * + `ItemCount` - Represents the number of items in the index. DynamoDB updates this value approximately every six hours. Recent changes might not be reflected in this value.
         *
         * If the table is in the `DELETING` state, no information about indexes will be returned.
         */
        public var localSecondaryIndexes: List<LocalSecondaryIndexDescription>? = null
        /**
         * The provisioned throughput settings for the table, consisting of read and write capacity units, along with data about increases and decreases.
         */
        public var provisionedThroughput: aws.sdk.kotlin.services.dynamodb.model.ProvisionedThroughputDescription? = null
        /**
         * Represents replicas of the table.
         */
        public var replicas: List<ReplicaDescription>? = null
        /**
         * Contains details for the restore.
         */
        public var restoreSummary: aws.sdk.kotlin.services.dynamodb.model.RestoreSummary? = null
        /**
         * The description of the server-side encryption status on the specified table.
         */
        public var sseDescription: aws.sdk.kotlin.services.dynamodb.model.SseDescription? = null
        /**
         * The current DynamoDB Streams configuration for the table.
         */
        public var streamSpecification: aws.sdk.kotlin.services.dynamodb.model.StreamSpecification? = null
        /**
         * The Amazon Resource Name (ARN) that uniquely identifies the table.
         */
        public var tableArn: kotlin.String? = null
        /**
         * Contains details of the table class.
         */
        public var tableClassSummary: aws.sdk.kotlin.services.dynamodb.model.TableClassSummary? = null
        /**
         * Unique identifier for the table for which the backup was created.
         */
        public var tableId: kotlin.String? = null
        /**
         * The name of the table.
         */
        public var tableName: kotlin.String? = null
        /**
         * The total size of the specified table, in bytes. DynamoDB updates this value approximately every six hours. Recent changes might not be reflected in this value.
         */
        public var tableSizeBytes: kotlin.Long? = null
        /**
         * The current state of the table:
         * + `CREATING` - The table is being created.
         * + `UPDATING` - The table/index configuration is being updated. The table/index remains available for data operations when `UPDATING`.
         * + `DELETING` - The table is being deleted.
         * + `ACTIVE` - The table is ready for use.
         * + `INACCESSIBLE_ENCRYPTION_CREDENTIALS` - The KMS key used to encrypt the table in inaccessible. Table operations may fail due to failure to use the KMS key. DynamoDB will initiate the table archival process when a table's KMS key remains inaccessible for more than seven days.
         * + `ARCHIVING` - The table is being archived. Operations are not allowed until archival is complete.
         * + `ARCHIVED` - The table has been archived. See the ArchivalReason for more information.
         */
        public var tableStatus: aws.sdk.kotlin.services.dynamodb.model.TableStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dynamodb.model.TableDescription) : this() {
            this.archivalSummary = x.archivalSummary
            this.attributeDefinitions = x.attributeDefinitions
            this.billingModeSummary = x.billingModeSummary
            this.creationDateTime = x.creationDateTime
            this.deletionProtectionEnabled = x.deletionProtectionEnabled
            this.globalSecondaryIndexes = x.globalSecondaryIndexes
            this.globalTableVersion = x.globalTableVersion
            this.itemCount = x.itemCount
            this.keySchema = x.keySchema
            this.latestStreamArn = x.latestStreamArn
            this.latestStreamLabel = x.latestStreamLabel
            this.localSecondaryIndexes = x.localSecondaryIndexes
            this.provisionedThroughput = x.provisionedThroughput
            this.replicas = x.replicas
            this.restoreSummary = x.restoreSummary
            this.sseDescription = x.sseDescription
            this.streamSpecification = x.streamSpecification
            this.tableArn = x.tableArn
            this.tableClassSummary = x.tableClassSummary
            this.tableId = x.tableId
            this.tableName = x.tableName
            this.tableSizeBytes = x.tableSizeBytes
            this.tableStatus = x.tableStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dynamodb.model.TableDescription = TableDescription(this)

        /**
         * construct an [aws.sdk.kotlin.services.dynamodb.model.ArchivalSummary] inside the given [block]
         */
        public fun archivalSummary(block: aws.sdk.kotlin.services.dynamodb.model.ArchivalSummary.Builder.() -> kotlin.Unit) {
            this.archivalSummary = aws.sdk.kotlin.services.dynamodb.model.ArchivalSummary.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.dynamodb.model.BillingModeSummary] inside the given [block]
         */
        public fun billingModeSummary(block: aws.sdk.kotlin.services.dynamodb.model.BillingModeSummary.Builder.() -> kotlin.Unit) {
            this.billingModeSummary = aws.sdk.kotlin.services.dynamodb.model.BillingModeSummary.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.dynamodb.model.ProvisionedThroughputDescription] inside the given [block]
         */
        public fun provisionedThroughput(block: aws.sdk.kotlin.services.dynamodb.model.ProvisionedThroughputDescription.Builder.() -> kotlin.Unit) {
            this.provisionedThroughput = aws.sdk.kotlin.services.dynamodb.model.ProvisionedThroughputDescription.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.dynamodb.model.RestoreSummary] inside the given [block]
         */
        public fun restoreSummary(block: aws.sdk.kotlin.services.dynamodb.model.RestoreSummary.Builder.() -> kotlin.Unit) {
            this.restoreSummary = aws.sdk.kotlin.services.dynamodb.model.RestoreSummary.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.dynamodb.model.SseDescription] inside the given [block]
         */
        public fun sseDescription(block: aws.sdk.kotlin.services.dynamodb.model.SseDescription.Builder.() -> kotlin.Unit) {
            this.sseDescription = aws.sdk.kotlin.services.dynamodb.model.SseDescription.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.dynamodb.model.StreamSpecification] inside the given [block]
         */
        public fun streamSpecification(block: aws.sdk.kotlin.services.dynamodb.model.StreamSpecification.Builder.() -> kotlin.Unit) {
            this.streamSpecification = aws.sdk.kotlin.services.dynamodb.model.StreamSpecification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.dynamodb.model.TableClassSummary] inside the given [block]
         */
        public fun tableClassSummary(block: aws.sdk.kotlin.services.dynamodb.model.TableClassSummary.Builder.() -> kotlin.Unit) {
            this.tableClassSummary = aws.sdk.kotlin.services.dynamodb.model.TableClassSummary.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
