// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dynamodb.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The description of the server-side encryption status on the specified table.
 */
public class SseDescription private constructor(builder: Builder) {
    /**
     * Indicates the time, in UNIX epoch date format, when DynamoDB detected that the table's KMS key was inaccessible. This attribute will automatically be cleared when DynamoDB detects that the table's KMS key is accessible again. DynamoDB will initiate the table archival process when table's KMS key remains inaccessible for more than seven days from this date.
     */
    public val inaccessibleEncryptionDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.inaccessibleEncryptionDateTime
    /**
     * The KMS key ARN used for the KMS encryption.
     */
    public val kmsMasterKeyArn: kotlin.String? = builder.kmsMasterKeyArn
    /**
     * Server-side encryption type. The only supported value is:
     * + `KMS` - Server-side encryption that uses Key Management Service. The key is stored in your account and is managed by KMS (KMS charges apply).
     */
    public val sseType: aws.sdk.kotlin.services.dynamodb.model.SseType? = builder.sseType
    /**
     * Represents the current state of server-side encryption. The only supported values are:
     * + `ENABLED` - Server-side encryption is enabled.
     * + `UPDATING` - Server-side encryption is being updated.
     */
    public val status: aws.sdk.kotlin.services.dynamodb.model.SseStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dynamodb.model.SseDescription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SseDescription(")
        append("inaccessibleEncryptionDateTime=$inaccessibleEncryptionDateTime,")
        append("kmsMasterKeyArn=$kmsMasterKeyArn,")
        append("sseType=$sseType,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = inaccessibleEncryptionDateTime?.hashCode() ?: 0
        result = 31 * result + (kmsMasterKeyArn?.hashCode() ?: 0)
        result = 31 * result + (sseType?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SseDescription

        if (inaccessibleEncryptionDateTime != other.inaccessibleEncryptionDateTime) return false
        if (kmsMasterKeyArn != other.kmsMasterKeyArn) return false
        if (sseType != other.sseType) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dynamodb.model.SseDescription = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Indicates the time, in UNIX epoch date format, when DynamoDB detected that the table's KMS key was inaccessible. This attribute will automatically be cleared when DynamoDB detects that the table's KMS key is accessible again. DynamoDB will initiate the table archival process when table's KMS key remains inaccessible for more than seven days from this date.
         */
        public var inaccessibleEncryptionDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The KMS key ARN used for the KMS encryption.
         */
        public var kmsMasterKeyArn: kotlin.String? = null
        /**
         * Server-side encryption type. The only supported value is:
         * + `KMS` - Server-side encryption that uses Key Management Service. The key is stored in your account and is managed by KMS (KMS charges apply).
         */
        public var sseType: aws.sdk.kotlin.services.dynamodb.model.SseType? = null
        /**
         * Represents the current state of server-side encryption. The only supported values are:
         * + `ENABLED` - Server-side encryption is enabled.
         * + `UPDATING` - Server-side encryption is being updated.
         */
        public var status: aws.sdk.kotlin.services.dynamodb.model.SseStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dynamodb.model.SseDescription) : this() {
            this.inaccessibleEncryptionDateTime = x.inaccessibleEncryptionDateTime
            this.kmsMasterKeyArn = x.kmsMasterKeyArn
            this.sseType = x.sseType
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dynamodb.model.SseDescription = SseDescription(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
