// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dynamodb.model



/**
 * Contains the details of the features enabled on the table when the backup was created. For example, LSIs, GSIs, streams, TTL.
 */
public class SourceTableFeatureDetails private constructor(builder: Builder) {
    /**
     * Represents the GSI properties for the table when the backup was created. It includes the IndexName, KeySchema, Projection, and ProvisionedThroughput for the GSIs on the table at the time of backup.
     */
    public val globalSecondaryIndexes: List<GlobalSecondaryIndexInfo>? = builder.globalSecondaryIndexes
    /**
     * Represents the LSI properties for the table when the backup was created. It includes the IndexName, KeySchema and Projection for the LSIs on the table at the time of backup.
     */
    public val localSecondaryIndexes: List<LocalSecondaryIndexInfo>? = builder.localSecondaryIndexes
    /**
     * The description of the server-side encryption status on the table when the backup was created.
     */
    public val sseDescription: aws.sdk.kotlin.services.dynamodb.model.SseDescription? = builder.sseDescription
    /**
     * Stream settings on the table when the backup was created.
     */
    public val streamDescription: aws.sdk.kotlin.services.dynamodb.model.StreamSpecification? = builder.streamDescription
    /**
     * Time to Live settings on the table when the backup was created.
     */
    public val timeToLiveDescription: aws.sdk.kotlin.services.dynamodb.model.TimeToLiveDescription? = builder.timeToLiveDescription

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dynamodb.model.SourceTableFeatureDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SourceTableFeatureDetails(")
        append("globalSecondaryIndexes=$globalSecondaryIndexes,")
        append("localSecondaryIndexes=$localSecondaryIndexes,")
        append("sseDescription=$sseDescription,")
        append("streamDescription=$streamDescription,")
        append("timeToLiveDescription=$timeToLiveDescription")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = globalSecondaryIndexes?.hashCode() ?: 0
        result = 31 * result + (localSecondaryIndexes?.hashCode() ?: 0)
        result = 31 * result + (sseDescription?.hashCode() ?: 0)
        result = 31 * result + (streamDescription?.hashCode() ?: 0)
        result = 31 * result + (timeToLiveDescription?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SourceTableFeatureDetails

        if (globalSecondaryIndexes != other.globalSecondaryIndexes) return false
        if (localSecondaryIndexes != other.localSecondaryIndexes) return false
        if (sseDescription != other.sseDescription) return false
        if (streamDescription != other.streamDescription) return false
        if (timeToLiveDescription != other.timeToLiveDescription) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dynamodb.model.SourceTableFeatureDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Represents the GSI properties for the table when the backup was created. It includes the IndexName, KeySchema, Projection, and ProvisionedThroughput for the GSIs on the table at the time of backup.
         */
        public var globalSecondaryIndexes: List<GlobalSecondaryIndexInfo>? = null
        /**
         * Represents the LSI properties for the table when the backup was created. It includes the IndexName, KeySchema and Projection for the LSIs on the table at the time of backup.
         */
        public var localSecondaryIndexes: List<LocalSecondaryIndexInfo>? = null
        /**
         * The description of the server-side encryption status on the table when the backup was created.
         */
        public var sseDescription: aws.sdk.kotlin.services.dynamodb.model.SseDescription? = null
        /**
         * Stream settings on the table when the backup was created.
         */
        public var streamDescription: aws.sdk.kotlin.services.dynamodb.model.StreamSpecification? = null
        /**
         * Time to Live settings on the table when the backup was created.
         */
        public var timeToLiveDescription: aws.sdk.kotlin.services.dynamodb.model.TimeToLiveDescription? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dynamodb.model.SourceTableFeatureDetails) : this() {
            this.globalSecondaryIndexes = x.globalSecondaryIndexes
            this.localSecondaryIndexes = x.localSecondaryIndexes
            this.sseDescription = x.sseDescription
            this.streamDescription = x.streamDescription
            this.timeToLiveDescription = x.timeToLiveDescription
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dynamodb.model.SourceTableFeatureDetails = SourceTableFeatureDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.dynamodb.model.SseDescription] inside the given [block]
         */
        public fun sseDescription(block: aws.sdk.kotlin.services.dynamodb.model.SseDescription.Builder.() -> kotlin.Unit) {
            this.sseDescription = aws.sdk.kotlin.services.dynamodb.model.SseDescription.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.dynamodb.model.StreamSpecification] inside the given [block]
         */
        public fun streamDescription(block: aws.sdk.kotlin.services.dynamodb.model.StreamSpecification.Builder.() -> kotlin.Unit) {
            this.streamDescription = aws.sdk.kotlin.services.dynamodb.model.StreamSpecification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.dynamodb.model.TimeToLiveDescription] inside the given [block]
         */
        public fun timeToLiveDescription(block: aws.sdk.kotlin.services.dynamodb.model.TimeToLiveDescription.Builder.() -> kotlin.Unit) {
            this.timeToLiveDescription = aws.sdk.kotlin.services.dynamodb.model.TimeToLiveDescription.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
