// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dynamodb.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains the details of the table when the backup was created.
 */
public class SourceTableDetails private constructor(builder: Builder) {
    /**
     * Controls how you are charged for read and write throughput and how you manage capacity. This setting can be changed later.
     * + `PROVISIONED` - Sets the read/write capacity mode to `PROVISIONED`. We recommend using `PROVISIONED` for predictable workloads.
     * + `PAY_PER_REQUEST` - Sets the read/write capacity mode to `PAY_PER_REQUEST`. We recommend using `PAY_PER_REQUEST` for unpredictable workloads.
     */
    public val billingMode: aws.sdk.kotlin.services.dynamodb.model.BillingMode? = builder.billingMode
    /**
     * Number of items in the table. Note that this is an approximate value.
     */
    public val itemCount: kotlin.Long? = builder.itemCount
    /**
     * Schema of the table.
     */
    public val keySchema: List<KeySchemaElement> = requireNotNull(builder.keySchema) { "A non-null value must be provided for keySchema" }
    /**
     * Read IOPs and Write IOPS on the table when the backup was created.
     */
    public val provisionedThroughput: aws.sdk.kotlin.services.dynamodb.model.ProvisionedThroughput? = builder.provisionedThroughput
    /**
     * ARN of the table for which backup was created.
     */
    public val tableArn: kotlin.String? = builder.tableArn
    /**
     * Time when the source table was created.
     */
    public val tableCreationDateTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.tableCreationDateTime) { "A non-null value must be provided for tableCreationDateTime" }
    /**
     * Unique identifier for the table for which the backup was created.
     */
    public val tableId: kotlin.String = requireNotNull(builder.tableId) { "A non-null value must be provided for tableId" }
    /**
     * The name of the table for which the backup was created.
     */
    public val tableName: kotlin.String = requireNotNull(builder.tableName) { "A non-null value must be provided for tableName" }
    /**
     * Size of the table in bytes. Note that this is an approximate value.
     */
    public val tableSizeBytes: kotlin.Long? = builder.tableSizeBytes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dynamodb.model.SourceTableDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SourceTableDetails(")
        append("billingMode=$billingMode,")
        append("itemCount=$itemCount,")
        append("keySchema=$keySchema,")
        append("provisionedThroughput=$provisionedThroughput,")
        append("tableArn=$tableArn,")
        append("tableCreationDateTime=$tableCreationDateTime,")
        append("tableId=$tableId,")
        append("tableName=$tableName,")
        append("tableSizeBytes=$tableSizeBytes")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = billingMode?.hashCode() ?: 0
        result = 31 * result + (itemCount?.hashCode() ?: 0)
        result = 31 * result + (keySchema.hashCode())
        result = 31 * result + (provisionedThroughput?.hashCode() ?: 0)
        result = 31 * result + (tableArn?.hashCode() ?: 0)
        result = 31 * result + (tableCreationDateTime.hashCode())
        result = 31 * result + (tableId.hashCode())
        result = 31 * result + (tableName.hashCode())
        result = 31 * result + (tableSizeBytes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SourceTableDetails

        if (billingMode != other.billingMode) return false
        if (itemCount != other.itemCount) return false
        if (keySchema != other.keySchema) return false
        if (provisionedThroughput != other.provisionedThroughput) return false
        if (tableArn != other.tableArn) return false
        if (tableCreationDateTime != other.tableCreationDateTime) return false
        if (tableId != other.tableId) return false
        if (tableName != other.tableName) return false
        if (tableSizeBytes != other.tableSizeBytes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dynamodb.model.SourceTableDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Controls how you are charged for read and write throughput and how you manage capacity. This setting can be changed later.
         * + `PROVISIONED` - Sets the read/write capacity mode to `PROVISIONED`. We recommend using `PROVISIONED` for predictable workloads.
         * + `PAY_PER_REQUEST` - Sets the read/write capacity mode to `PAY_PER_REQUEST`. We recommend using `PAY_PER_REQUEST` for unpredictable workloads.
         */
        public var billingMode: aws.sdk.kotlin.services.dynamodb.model.BillingMode? = null
        /**
         * Number of items in the table. Note that this is an approximate value.
         */
        public var itemCount: kotlin.Long? = null
        /**
         * Schema of the table.
         */
        public var keySchema: List<KeySchemaElement>? = null
        /**
         * Read IOPs and Write IOPS on the table when the backup was created.
         */
        public var provisionedThroughput: aws.sdk.kotlin.services.dynamodb.model.ProvisionedThroughput? = null
        /**
         * ARN of the table for which backup was created.
         */
        public var tableArn: kotlin.String? = null
        /**
         * Time when the source table was created.
         */
        public var tableCreationDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Unique identifier for the table for which the backup was created.
         */
        public var tableId: kotlin.String? = null
        /**
         * The name of the table for which the backup was created.
         */
        public var tableName: kotlin.String? = null
        /**
         * Size of the table in bytes. Note that this is an approximate value.
         */
        public var tableSizeBytes: kotlin.Long? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dynamodb.model.SourceTableDetails) : this() {
            this.billingMode = x.billingMode
            this.itemCount = x.itemCount
            this.keySchema = x.keySchema
            this.provisionedThroughput = x.provisionedThroughput
            this.tableArn = x.tableArn
            this.tableCreationDateTime = x.tableCreationDateTime
            this.tableId = x.tableId
            this.tableName = x.tableName
            this.tableSizeBytes = x.tableSizeBytes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dynamodb.model.SourceTableDetails = SourceTableDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.dynamodb.model.ProvisionedThroughput] inside the given [block]
         */
        public fun provisionedThroughput(block: aws.sdk.kotlin.services.dynamodb.model.ProvisionedThroughput.Builder.() -> kotlin.Unit) {
            this.provisionedThroughput = aws.sdk.kotlin.services.dynamodb.model.ProvisionedThroughput.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (keySchema == null) keySchema = emptyList()
            if (tableCreationDateTime == null) tableCreationDateTime = Instant.fromEpochSeconds(0)
            if (tableId == null) tableId = ""
            if (tableName == null) tableName = ""
            return this
        }
    }
}
