// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dynamodb.model



/**
 * Represents the output of a `Scan` operation.
 */
public class ScanResponse private constructor(builder: Builder) {
    /**
     * The capacity units consumed by the `Scan` operation. The data returned includes the total provisioned throughput consumed, along with statistics for the table and any indexes involved in the operation. `ConsumedCapacity` is only returned if the `ReturnConsumedCapacity` parameter was specified. For more information, see [Provisioned Throughput](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughput.html#ItemSizeCalculations.Reads) in the *Amazon DynamoDB Developer Guide*.
     */
    public val consumedCapacity: aws.sdk.kotlin.services.dynamodb.model.ConsumedCapacity? = builder.consumedCapacity
    /**
     * The number of items in the response.
     *
     * If you set `ScanFilter` in the request, then `Count` is the number of items returned after the filter was applied, and `ScannedCount` is the number of matching items before the filter was applied.
     *
     * If you did not use a filter in the request, then `Count` is the same as `ScannedCount`.
     */
    public val count: kotlin.Int = builder.count
    /**
     * An array of item attributes that match the scan criteria. Each element in this array consists of an attribute name and the value for that attribute.
     */
    public val items: List<Map<String, AttributeValue>>? = builder.items
    /**
     * The primary key of the item where the operation stopped, inclusive of the previous result set. Use this value to start a new operation, excluding this value in the new request.
     *
     * If `LastEvaluatedKey` is empty, then the "last page" of results has been processed and there is no more data to be retrieved.
     *
     * If `LastEvaluatedKey` is not empty, it does not necessarily mean that there is more data in the result set. The only way to know when you have reached the end of the result set is when `LastEvaluatedKey` is empty.
     */
    public val lastEvaluatedKey: Map<String, AttributeValue>? = builder.lastEvaluatedKey
    /**
     * The number of items evaluated, before any `ScanFilter` is applied. A high `ScannedCount` value with few, or no, `Count` results indicates an inefficient `Scan` operation. For more information, see [Count and ScannedCount](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html#Count) in the *Amazon DynamoDB Developer Guide*.
     *
     * If you did not use a filter in the request, then `ScannedCount` is the same as `Count`.
     */
    public val scannedCount: kotlin.Int = builder.scannedCount

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dynamodb.model.ScanResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ScanResponse(")
        append("consumedCapacity=$consumedCapacity,")
        append("count=$count,")
        append("items=$items,")
        append("lastEvaluatedKey=$lastEvaluatedKey,")
        append("scannedCount=$scannedCount")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = consumedCapacity?.hashCode() ?: 0
        result = 31 * result + (count)
        result = 31 * result + (items?.hashCode() ?: 0)
        result = 31 * result + (lastEvaluatedKey?.hashCode() ?: 0)
        result = 31 * result + (scannedCount)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ScanResponse

        if (consumedCapacity != other.consumedCapacity) return false
        if (count != other.count) return false
        if (items != other.items) return false
        if (lastEvaluatedKey != other.lastEvaluatedKey) return false
        if (scannedCount != other.scannedCount) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dynamodb.model.ScanResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The capacity units consumed by the `Scan` operation. The data returned includes the total provisioned throughput consumed, along with statistics for the table and any indexes involved in the operation. `ConsumedCapacity` is only returned if the `ReturnConsumedCapacity` parameter was specified. For more information, see [Provisioned Throughput](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughput.html#ItemSizeCalculations.Reads) in the *Amazon DynamoDB Developer Guide*.
         */
        public var consumedCapacity: aws.sdk.kotlin.services.dynamodb.model.ConsumedCapacity? = null
        /**
         * The number of items in the response.
         *
         * If you set `ScanFilter` in the request, then `Count` is the number of items returned after the filter was applied, and `ScannedCount` is the number of matching items before the filter was applied.
         *
         * If you did not use a filter in the request, then `Count` is the same as `ScannedCount`.
         */
        public var count: kotlin.Int = 0
        /**
         * An array of item attributes that match the scan criteria. Each element in this array consists of an attribute name and the value for that attribute.
         */
        public var items: List<Map<String, AttributeValue>>? = null
        /**
         * The primary key of the item where the operation stopped, inclusive of the previous result set. Use this value to start a new operation, excluding this value in the new request.
         *
         * If `LastEvaluatedKey` is empty, then the "last page" of results has been processed and there is no more data to be retrieved.
         *
         * If `LastEvaluatedKey` is not empty, it does not necessarily mean that there is more data in the result set. The only way to know when you have reached the end of the result set is when `LastEvaluatedKey` is empty.
         */
        public var lastEvaluatedKey: Map<String, AttributeValue>? = null
        /**
         * The number of items evaluated, before any `ScanFilter` is applied. A high `ScannedCount` value with few, or no, `Count` results indicates an inefficient `Scan` operation. For more information, see [Count and ScannedCount](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html#Count) in the *Amazon DynamoDB Developer Guide*.
         *
         * If you did not use a filter in the request, then `ScannedCount` is the same as `Count`.
         */
        public var scannedCount: kotlin.Int = 0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dynamodb.model.ScanResponse) : this() {
            this.consumedCapacity = x.consumedCapacity
            this.count = x.count
            this.items = x.items
            this.lastEvaluatedKey = x.lastEvaluatedKey
            this.scannedCount = x.scannedCount
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dynamodb.model.ScanResponse = ScanResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.dynamodb.model.ConsumedCapacity] inside the given [block]
         */
        public fun consumedCapacity(block: aws.sdk.kotlin.services.dynamodb.model.ConsumedCapacity.Builder.() -> kotlin.Unit) {
            this.consumedCapacity = aws.sdk.kotlin.services.dynamodb.model.ConsumedCapacity.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
