// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dynamodb.model



/**
 * The S3 bucket that is being imported from.
 */
public class S3BucketSource private constructor(builder: Builder) {
    /**
     * The S3 bucket that is being imported from.
     */
    public val s3Bucket: kotlin.String = requireNotNull(builder.s3Bucket) { "A non-null value must be provided for s3Bucket" }
    /**
     * The account number of the S3 bucket that is being imported from. If the bucket is owned by the requester this is optional.
     */
    public val s3BucketOwner: kotlin.String? = builder.s3BucketOwner
    /**
     * The key prefix shared by all S3 Objects that are being imported.
     */
    public val s3KeyPrefix: kotlin.String? = builder.s3KeyPrefix

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dynamodb.model.S3BucketSource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3BucketSource(")
        append("s3Bucket=$s3Bucket,")
        append("s3BucketOwner=$s3BucketOwner,")
        append("s3KeyPrefix=$s3KeyPrefix")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = s3Bucket.hashCode()
        result = 31 * result + (s3BucketOwner?.hashCode() ?: 0)
        result = 31 * result + (s3KeyPrefix?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3BucketSource

        if (s3Bucket != other.s3Bucket) return false
        if (s3BucketOwner != other.s3BucketOwner) return false
        if (s3KeyPrefix != other.s3KeyPrefix) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dynamodb.model.S3BucketSource = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The S3 bucket that is being imported from.
         */
        public var s3Bucket: kotlin.String? = null
        /**
         * The account number of the S3 bucket that is being imported from. If the bucket is owned by the requester this is optional.
         */
        public var s3BucketOwner: kotlin.String? = null
        /**
         * The key prefix shared by all S3 Objects that are being imported.
         */
        public var s3KeyPrefix: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dynamodb.model.S3BucketSource) : this() {
            this.s3Bucket = x.s3Bucket
            this.s3BucketOwner = x.s3BucketOwner
            this.s3KeyPrefix = x.s3KeyPrefix
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dynamodb.model.S3BucketSource = S3BucketSource(this)

        internal fun correctErrors(): Builder {
            if (s3Bucket == null) s3Bucket = ""
            return this
        }
    }
}
