// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dynamodb.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains details for the restore.
 */
public class RestoreSummary private constructor(builder: Builder) {
    /**
     * Point in time or source backup time.
     */
    public val restoreDateTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.restoreDateTime) { "A non-null value must be provided for restoreDateTime" }
    /**
     * Indicates if a restore is in progress or not.
     */
    public val restoreInProgress: kotlin.Boolean = requireNotNull(builder.restoreInProgress) { "A non-null value must be provided for restoreInProgress" }
    /**
     * The Amazon Resource Name (ARN) of the backup from which the table was restored.
     */
    public val sourceBackupArn: kotlin.String? = builder.sourceBackupArn
    /**
     * The ARN of the source table of the backup that is being restored.
     */
    public val sourceTableArn: kotlin.String? = builder.sourceTableArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dynamodb.model.RestoreSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RestoreSummary(")
        append("restoreDateTime=$restoreDateTime,")
        append("restoreInProgress=$restoreInProgress,")
        append("sourceBackupArn=$sourceBackupArn,")
        append("sourceTableArn=$sourceTableArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = restoreDateTime.hashCode()
        result = 31 * result + (restoreInProgress.hashCode())
        result = 31 * result + (sourceBackupArn?.hashCode() ?: 0)
        result = 31 * result + (sourceTableArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RestoreSummary

        if (restoreDateTime != other.restoreDateTime) return false
        if (restoreInProgress != other.restoreInProgress) return false
        if (sourceBackupArn != other.sourceBackupArn) return false
        if (sourceTableArn != other.sourceTableArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dynamodb.model.RestoreSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Point in time or source backup time.
         */
        public var restoreDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Indicates if a restore is in progress or not.
         */
        public var restoreInProgress: kotlin.Boolean? = null
        /**
         * The Amazon Resource Name (ARN) of the backup from which the table was restored.
         */
        public var sourceBackupArn: kotlin.String? = null
        /**
         * The ARN of the source table of the backup that is being restored.
         */
        public var sourceTableArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dynamodb.model.RestoreSummary) : this() {
            this.restoreDateTime = x.restoreDateTime
            this.restoreInProgress = x.restoreInProgress
            this.sourceBackupArn = x.sourceBackupArn
            this.sourceTableArn = x.sourceTableArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dynamodb.model.RestoreSummary = RestoreSummary(this)

        internal fun correctErrors(): Builder {
            if (restoreDateTime == null) restoreDateTime = Instant.fromEpochSeconds(0)
            if (restoreInProgress == null) restoreInProgress = false
            return this
        }
    }
}
