// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dynamodb.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains the details of the replica.
 */
public class ReplicaDescription private constructor(builder: Builder) {
    /**
     * Replica-specific global secondary index settings.
     */
    public val globalSecondaryIndexes: List<ReplicaGlobalSecondaryIndexDescription>? = builder.globalSecondaryIndexes
    /**
     * The KMS key of the replica that will be used for KMS encryption.
     */
    public val kmsMasterKeyId: kotlin.String? = builder.kmsMasterKeyId
    /**
     * Replica-specific provisioned throughput. If not described, uses the source table's provisioned throughput settings.
     */
    public val provisionedThroughputOverride: aws.sdk.kotlin.services.dynamodb.model.ProvisionedThroughputOverride? = builder.provisionedThroughputOverride
    /**
     * The name of the Region.
     */
    public val regionName: kotlin.String? = builder.regionName
    /**
     * The time at which the replica was first detected as inaccessible. To determine cause of inaccessibility check the `ReplicaStatus` property.
     */
    public val replicaInaccessibleDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.replicaInaccessibleDateTime
    /**
     * The current state of the replica:
     * + `CREATING` - The replica is being created.
     * + `UPDATING` - The replica is being updated.
     * + `DELETING` - The replica is being deleted.
     * + `ACTIVE` - The replica is ready for use.
     * + `REGION_DISABLED` - The replica is inaccessible because the Amazon Web Services Region has been disabled.If the Amazon Web Services Region remains inaccessible for more than 20 hours, DynamoDB will remove this replica from the replication group. The replica will not be deleted and replication will stop from and to this region.
     * + `INACCESSIBLE_ENCRYPTION_CREDENTIALS ` - The KMS key used to encrypt the table is inaccessible.If the KMS key remains inaccessible for more than 20 hours, DynamoDB will remove this replica from the replication group. The replica will not be deleted and replication will stop from and to this region.
     */
    public val replicaStatus: aws.sdk.kotlin.services.dynamodb.model.ReplicaStatus? = builder.replicaStatus
    /**
     * Detailed information about the replica status.
     */
    public val replicaStatusDescription: kotlin.String? = builder.replicaStatusDescription
    /**
     * Specifies the progress of a Create, Update, or Delete action on the replica as a percentage.
     */
    public val replicaStatusPercentProgress: kotlin.String? = builder.replicaStatusPercentProgress
    /**
     * Contains details of the table class.
     */
    public val replicaTableClassSummary: aws.sdk.kotlin.services.dynamodb.model.TableClassSummary? = builder.replicaTableClassSummary

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dynamodb.model.ReplicaDescription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ReplicaDescription(")
        append("globalSecondaryIndexes=$globalSecondaryIndexes,")
        append("kmsMasterKeyId=$kmsMasterKeyId,")
        append("provisionedThroughputOverride=$provisionedThroughputOverride,")
        append("regionName=$regionName,")
        append("replicaInaccessibleDateTime=$replicaInaccessibleDateTime,")
        append("replicaStatus=$replicaStatus,")
        append("replicaStatusDescription=$replicaStatusDescription,")
        append("replicaStatusPercentProgress=$replicaStatusPercentProgress,")
        append("replicaTableClassSummary=$replicaTableClassSummary")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = globalSecondaryIndexes?.hashCode() ?: 0
        result = 31 * result + (kmsMasterKeyId?.hashCode() ?: 0)
        result = 31 * result + (provisionedThroughputOverride?.hashCode() ?: 0)
        result = 31 * result + (regionName?.hashCode() ?: 0)
        result = 31 * result + (replicaInaccessibleDateTime?.hashCode() ?: 0)
        result = 31 * result + (replicaStatus?.hashCode() ?: 0)
        result = 31 * result + (replicaStatusDescription?.hashCode() ?: 0)
        result = 31 * result + (replicaStatusPercentProgress?.hashCode() ?: 0)
        result = 31 * result + (replicaTableClassSummary?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ReplicaDescription

        if (globalSecondaryIndexes != other.globalSecondaryIndexes) return false
        if (kmsMasterKeyId != other.kmsMasterKeyId) return false
        if (provisionedThroughputOverride != other.provisionedThroughputOverride) return false
        if (regionName != other.regionName) return false
        if (replicaInaccessibleDateTime != other.replicaInaccessibleDateTime) return false
        if (replicaStatus != other.replicaStatus) return false
        if (replicaStatusDescription != other.replicaStatusDescription) return false
        if (replicaStatusPercentProgress != other.replicaStatusPercentProgress) return false
        if (replicaTableClassSummary != other.replicaTableClassSummary) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dynamodb.model.ReplicaDescription = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Replica-specific global secondary index settings.
         */
        public var globalSecondaryIndexes: List<ReplicaGlobalSecondaryIndexDescription>? = null
        /**
         * The KMS key of the replica that will be used for KMS encryption.
         */
        public var kmsMasterKeyId: kotlin.String? = null
        /**
         * Replica-specific provisioned throughput. If not described, uses the source table's provisioned throughput settings.
         */
        public var provisionedThroughputOverride: aws.sdk.kotlin.services.dynamodb.model.ProvisionedThroughputOverride? = null
        /**
         * The name of the Region.
         */
        public var regionName: kotlin.String? = null
        /**
         * The time at which the replica was first detected as inaccessible. To determine cause of inaccessibility check the `ReplicaStatus` property.
         */
        public var replicaInaccessibleDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The current state of the replica:
         * + `CREATING` - The replica is being created.
         * + `UPDATING` - The replica is being updated.
         * + `DELETING` - The replica is being deleted.
         * + `ACTIVE` - The replica is ready for use.
         * + `REGION_DISABLED` - The replica is inaccessible because the Amazon Web Services Region has been disabled.If the Amazon Web Services Region remains inaccessible for more than 20 hours, DynamoDB will remove this replica from the replication group. The replica will not be deleted and replication will stop from and to this region.
         * + `INACCESSIBLE_ENCRYPTION_CREDENTIALS ` - The KMS key used to encrypt the table is inaccessible.If the KMS key remains inaccessible for more than 20 hours, DynamoDB will remove this replica from the replication group. The replica will not be deleted and replication will stop from and to this region.
         */
        public var replicaStatus: aws.sdk.kotlin.services.dynamodb.model.ReplicaStatus? = null
        /**
         * Detailed information about the replica status.
         */
        public var replicaStatusDescription: kotlin.String? = null
        /**
         * Specifies the progress of a Create, Update, or Delete action on the replica as a percentage.
         */
        public var replicaStatusPercentProgress: kotlin.String? = null
        /**
         * Contains details of the table class.
         */
        public var replicaTableClassSummary: aws.sdk.kotlin.services.dynamodb.model.TableClassSummary? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dynamodb.model.ReplicaDescription) : this() {
            this.globalSecondaryIndexes = x.globalSecondaryIndexes
            this.kmsMasterKeyId = x.kmsMasterKeyId
            this.provisionedThroughputOverride = x.provisionedThroughputOverride
            this.regionName = x.regionName
            this.replicaInaccessibleDateTime = x.replicaInaccessibleDateTime
            this.replicaStatus = x.replicaStatus
            this.replicaStatusDescription = x.replicaStatusDescription
            this.replicaStatusPercentProgress = x.replicaStatusPercentProgress
            this.replicaTableClassSummary = x.replicaTableClassSummary
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dynamodb.model.ReplicaDescription = ReplicaDescription(this)

        /**
         * construct an [aws.sdk.kotlin.services.dynamodb.model.ProvisionedThroughputOverride] inside the given [block]
         */
        public fun provisionedThroughputOverride(block: aws.sdk.kotlin.services.dynamodb.model.ProvisionedThroughputOverride.Builder.() -> kotlin.Unit) {
            this.provisionedThroughputOverride = aws.sdk.kotlin.services.dynamodb.model.ProvisionedThroughputOverride.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.dynamodb.model.TableClassSummary] inside the given [block]
         */
        public fun replicaTableClassSummary(block: aws.sdk.kotlin.services.dynamodb.model.TableClassSummary.Builder.() -> kotlin.Unit) {
            this.replicaTableClassSummary = aws.sdk.kotlin.services.dynamodb.model.TableClassSummary.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
