// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dynamodb.model



/**
 * Represents the input of a `Query` operation.
 */
public class QueryRequest private constructor(builder: Builder) {
    /**
     * This is a legacy parameter. Use `ProjectionExpression` instead. For more information, see [AttributesToGet](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html) in the *Amazon DynamoDB Developer Guide*.
     */
    public val attributesToGet: List<String>? = builder.attributesToGet
    /**
     * This is a legacy parameter. Use `FilterExpression` instead. For more information, see [ConditionalOperator](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html) in the *Amazon DynamoDB Developer Guide*.
     */
    public val conditionalOperator: aws.sdk.kotlin.services.dynamodb.model.ConditionalOperator? = builder.conditionalOperator
    /**
     * Determines the read consistency model: If set to `true`, then the operation uses strongly consistent reads; otherwise, the operation uses eventually consistent reads.
     *
     * Strongly consistent reads are not supported on global secondary indexes. If you query a global secondary index with `ConsistentRead` set to `true`, you will receive a `ValidationException`.
     */
    public val consistentRead: kotlin.Boolean? = builder.consistentRead
    /**
     * The primary key of the first item that this operation will evaluate. Use the value that was returned for `LastEvaluatedKey` in the previous operation.
     *
     * The data type for `ExclusiveStartKey` must be String, Number, or Binary. No set data types are allowed.
     */
    public val exclusiveStartKey: Map<String, AttributeValue>? = builder.exclusiveStartKey
    /**
     * One or more substitution tokens for attribute names in an expression. The following are some use cases for using `ExpressionAttributeNames`:
     * + To access an attribute whose name conflicts with a DynamoDB reserved word.
     * + To create a placeholder for repeating occurrences of an attribute name in an expression.
     * + To prevent special characters in an attribute name from being misinterpreted in an expression.
     *
     * Use the **#** character in an expression to dereference an attribute name. For example, consider the following attribute name:
     * + `Percentile`
     *
     * The name of this attribute conflicts with a reserved word, so it cannot be used directly in an expression. (For the complete list of reserved words, see [Reserved Words](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html) in the *Amazon DynamoDB Developer Guide*). To work around this, you could specify the following for `ExpressionAttributeNames`:
     * + `{"#P":"Percentile"}`
     *
     * You could then use this substitution in an expression, as in this example:
     * + `#P = :val`
     *
     * Tokens that begin with the **:** character are *expression attribute values*, which are placeholders for the actual value at runtime.
     *
     * For more information on expression attribute names, see [Specifying Item Attributes](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html) in the *Amazon DynamoDB Developer Guide*.
     */
    public val expressionAttributeNames: Map<String, String>? = builder.expressionAttributeNames
    /**
     * One or more values that can be substituted in an expression.
     *
     * Use the **:** (colon) character in an expression to dereference an attribute value. For example, suppose that you wanted to check whether the value of the *ProductStatus* attribute was one of the following:
     *
     * `Available | Backordered | Discontinued`
     *
     * You would first need to specify `ExpressionAttributeValues` as follows:
     *
     * `{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"}, ":disc":{"S":"Discontinued"} }`
     *
     * You could then use these values in an expression, such as this:
     *
     * `ProductStatus IN (:avail, :back, :disc)`
     *
     * For more information on expression attribute values, see [Specifying Conditions](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html) in the *Amazon DynamoDB Developer Guide*.
     */
    public val expressionAttributeValues: Map<String, AttributeValue>? = builder.expressionAttributeValues
    /**
     * A string that contains conditions that DynamoDB applies after the `Query` operation, but before the data is returned to you. Items that do not satisfy the `FilterExpression` criteria are not returned.
     *
     * A `FilterExpression` does not allow key attributes. You cannot define a filter expression based on a partition key or a sort key.
     *
     * A `FilterExpression` is applied after the items have already been read; the process of filtering does not consume any additional read capacity units.
     *
     * For more information, see [Filter Expressions](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html#Query.FilterExpression) in the *Amazon DynamoDB Developer Guide*.
     */
    public val filterExpression: kotlin.String? = builder.filterExpression
    /**
     * The name of an index to query. This index can be any local secondary index or global secondary index on the table. Note that if you use the `IndexName` parameter, you must also provide `TableName.`
     */
    public val indexName: kotlin.String? = builder.indexName
    /**
     * The condition that specifies the key values for items to be retrieved by the `Query` action.
     *
     * The condition must perform an equality test on a single partition key value.
     *
     * The condition can optionally perform one of several comparison tests on a single sort key value. This allows `Query` to retrieve one item with a given partition key value and sort key value, or several items that have the same partition key value but different sort key values.
     *
     * The partition key equality test is required, and must be specified in the following format:
     *
     * `partitionKeyName`*=*`:partitionkeyval`
     *
     * If you also want to provide a condition for the sort key, it must be combined using `AND` with the condition for the sort key. Following is an example, using the **=** comparison operator for the sort key:
     *
     * `partitionKeyName``=``:partitionkeyval``AND``sortKeyName``=``:sortkeyval`
     *
     * Valid comparisons for the sort key condition are as follows:
     * + `sortKeyName``=``:sortkeyval` - true if the sort key value is equal to `:sortkeyval`.
     * + `sortKeyName``<``:sortkeyval` - true if the sort key value is less than `:sortkeyval`.
     * + `sortKeyName``<=``:sortkeyval` - true if the sort key value is less than or equal to `:sortkeyval`.
     * + `sortKeyName``>``:sortkeyval` - true if the sort key value is greater than `:sortkeyval`.
     * + `sortKeyName``>= ``:sortkeyval` - true if the sort key value is greater than or equal to `:sortkeyval`.
     * + `sortKeyName``BETWEEN``:sortkeyval1``AND``:sortkeyval2` - true if the sort key value is greater than or equal to `:sortkeyval1`, and less than or equal to `:sortkeyval2`.
     * + `begins_with (``sortKeyName`, `:sortkeyval``)` - true if the sort key value begins with a particular operand. (You cannot use this function with a sort key that is of type Number.) Note that the function name `begins_with` is case-sensitive.
     *
     * Use the `ExpressionAttributeValues` parameter to replace tokens such as `:partitionval` and `:sortval` with actual values at runtime.
     *
     * You can optionally use the `ExpressionAttributeNames` parameter to replace the names of the partition key and sort key with placeholder tokens. This option might be necessary if an attribute name conflicts with a DynamoDB reserved word. For example, the following `KeyConditionExpression` parameter causes an error because *Size* is a reserved word:
     * + `Size = :myval`
     *
     * To work around this, define a placeholder (such a `#S`) to represent the attribute name *Size*. `KeyConditionExpression` then is as follows:
     * + `#S = :myval`
     *
     * For a list of reserved words, see [Reserved Words](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html) in the *Amazon DynamoDB Developer Guide*.
     *
     * For more information on `ExpressionAttributeNames` and `ExpressionAttributeValues`, see [Using Placeholders for Attribute Names and Values](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ExpressionPlaceholders.html) in the *Amazon DynamoDB Developer Guide*.
     */
    public val keyConditionExpression: kotlin.String? = builder.keyConditionExpression
    /**
     * This is a legacy parameter. Use `KeyConditionExpression` instead. For more information, see [KeyConditions](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.KeyConditions.html) in the *Amazon DynamoDB Developer Guide*.
     */
    public val keyConditions: Map<String, Condition>? = builder.keyConditions
    /**
     * The maximum number of items to evaluate (not necessarily the number of matching items). If DynamoDB processes the number of items up to the limit while processing the results, it stops the operation and returns the matching values up to that point, and a key in `LastEvaluatedKey` to apply in a subsequent operation, so that you can pick up where you left off. Also, if the processed dataset size exceeds 1 MB before DynamoDB reaches this limit, it stops the operation and returns the matching values up to the limit, and a key in `LastEvaluatedKey` to apply in a subsequent operation to continue the operation. For more information, see [Query and Scan](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html) in the *Amazon DynamoDB Developer Guide*.
     */
    public val limit: kotlin.Int? = builder.limit
    /**
     * A string that identifies one or more attributes to retrieve from the table. These attributes can include scalars, sets, or elements of a JSON document. The attributes in the expression must be separated by commas.
     *
     * If no attribute names are specified, then all attributes will be returned. If any of the requested attributes are not found, they will not appear in the result.
     *
     * For more information, see [Accessing Item Attributes](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html) in the *Amazon DynamoDB Developer Guide*.
     */
    public val projectionExpression: kotlin.String? = builder.projectionExpression
    /**
     * This is a legacy parameter. Use `FilterExpression` instead. For more information, see [QueryFilter](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.QueryFilter.html) in the *Amazon DynamoDB Developer Guide*.
     */
    public val queryFilter: Map<String, Condition>? = builder.queryFilter
    /**
     * Determines the level of detail about either provisioned or on-demand throughput consumption that is returned in the response:
     * + `INDEXES` - The response includes the aggregate `ConsumedCapacity` for the operation, together with `ConsumedCapacity` for each table and secondary index that was accessed.Note that some operations, such as `GetItem` and `BatchGetItem`, do not access any indexes at all. In these cases, specifying `INDEXES` will only return `ConsumedCapacity` information for table(s).
     * + `TOTAL` - The response includes only the aggregate `ConsumedCapacity` for the operation.
     * + `NONE` - No `ConsumedCapacity` details are included in the response.
     */
    public val returnConsumedCapacity: aws.sdk.kotlin.services.dynamodb.model.ReturnConsumedCapacity? = builder.returnConsumedCapacity
    /**
     * Specifies the order for index traversal: If `true` (default), the traversal is performed in ascending order; if `false`, the traversal is performed in descending order.
     *
     * Items with the same partition key value are stored in sorted order by sort key. If the sort key data type is Number, the results are stored in numeric order. For type String, the results are stored in order of UTF-8 bytes. For type Binary, DynamoDB treats each byte of the binary data as unsigned.
     *
     * If `ScanIndexForward` is `true`, DynamoDB returns the results in the order in which they are stored (by sort key value). This is the default behavior. If `ScanIndexForward` is `false`, DynamoDB reads the results in reverse order by sort key value, and then returns the results to the client.
     */
    public val scanIndexForward: kotlin.Boolean? = builder.scanIndexForward
    /**
     * The attributes to be returned in the result. You can retrieve all item attributes, specific item attributes, the count of matching items, or in the case of an index, some or all of the attributes projected into the index.
     * + `ALL_ATTRIBUTES` - Returns all of the item attributes from the specified table or index. If you query a local secondary index, then for each matching item in the index, DynamoDB fetches the entire item from the parent table. If the index is configured to project all item attributes, then all of the data can be obtained from the local secondary index, and no fetching is required.
     * + `ALL_PROJECTED_ATTRIBUTES` - Allowed only when querying an index. Retrieves all attributes that have been projected into the index. If the index is configured to project all attributes, this return value is equivalent to specifying `ALL_ATTRIBUTES`.
     * + `COUNT` - Returns the number of matching items, rather than the matching items themselves. Note that this uses the same quantity of read capacity units as getting the items, and is subject to the same item size calculations.
     * + `SPECIFIC_ATTRIBUTES` - Returns only the attributes listed in `ProjectionExpression`. This return value is equivalent to specifying `ProjectionExpression` without specifying any value for `Select`.If you query or scan a local secondary index and request only attributes that are projected into that index, the operation will read only the index and not the table. If any of the requested attributes are not projected into the local secondary index, DynamoDB fetches each of these attributes from the parent table. This extra fetching incurs additional throughput cost and latency.If you query or scan a global secondary index, you can only request attributes that are projected into the index. Global secondary index queries cannot fetch attributes from the parent table.
     *
     * If neither `Select` nor `ProjectionExpression` are specified, DynamoDB defaults to `ALL_ATTRIBUTES` when accessing a table, and `ALL_PROJECTED_ATTRIBUTES` when accessing an index. You cannot use both `Select` and `ProjectionExpression` together in a single request, unless the value for `Select` is `SPECIFIC_ATTRIBUTES`. (This usage is equivalent to specifying `ProjectionExpression` without any value for `Select`.)
     *
     * If you use the `ProjectionExpression` parameter, then the value for `Select` can only be `SPECIFIC_ATTRIBUTES`. Any other value for `Select` will return an error.
     */
    public val select: aws.sdk.kotlin.services.dynamodb.model.Select? = builder.select
    /**
     * The name of the table containing the requested items.
     */
    public val tableName: kotlin.String? = builder.tableName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dynamodb.model.QueryRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("QueryRequest(")
        append("attributesToGet=$attributesToGet,")
        append("conditionalOperator=$conditionalOperator,")
        append("consistentRead=$consistentRead,")
        append("exclusiveStartKey=$exclusiveStartKey,")
        append("expressionAttributeNames=$expressionAttributeNames,")
        append("expressionAttributeValues=$expressionAttributeValues,")
        append("filterExpression=$filterExpression,")
        append("indexName=$indexName,")
        append("keyConditionExpression=$keyConditionExpression,")
        append("keyConditions=$keyConditions,")
        append("limit=$limit,")
        append("projectionExpression=$projectionExpression,")
        append("queryFilter=$queryFilter,")
        append("returnConsumedCapacity=$returnConsumedCapacity,")
        append("scanIndexForward=$scanIndexForward,")
        append("select=$select,")
        append("tableName=$tableName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributesToGet?.hashCode() ?: 0
        result = 31 * result + (conditionalOperator?.hashCode() ?: 0)
        result = 31 * result + (consistentRead?.hashCode() ?: 0)
        result = 31 * result + (exclusiveStartKey?.hashCode() ?: 0)
        result = 31 * result + (expressionAttributeNames?.hashCode() ?: 0)
        result = 31 * result + (expressionAttributeValues?.hashCode() ?: 0)
        result = 31 * result + (filterExpression?.hashCode() ?: 0)
        result = 31 * result + (indexName?.hashCode() ?: 0)
        result = 31 * result + (keyConditionExpression?.hashCode() ?: 0)
        result = 31 * result + (keyConditions?.hashCode() ?: 0)
        result = 31 * result + (limit ?: 0)
        result = 31 * result + (projectionExpression?.hashCode() ?: 0)
        result = 31 * result + (queryFilter?.hashCode() ?: 0)
        result = 31 * result + (returnConsumedCapacity?.hashCode() ?: 0)
        result = 31 * result + (scanIndexForward?.hashCode() ?: 0)
        result = 31 * result + (select?.hashCode() ?: 0)
        result = 31 * result + (tableName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as QueryRequest

        if (attributesToGet != other.attributesToGet) return false
        if (conditionalOperator != other.conditionalOperator) return false
        if (consistentRead != other.consistentRead) return false
        if (exclusiveStartKey != other.exclusiveStartKey) return false
        if (expressionAttributeNames != other.expressionAttributeNames) return false
        if (expressionAttributeValues != other.expressionAttributeValues) return false
        if (filterExpression != other.filterExpression) return false
        if (indexName != other.indexName) return false
        if (keyConditionExpression != other.keyConditionExpression) return false
        if (keyConditions != other.keyConditions) return false
        if (limit != other.limit) return false
        if (projectionExpression != other.projectionExpression) return false
        if (queryFilter != other.queryFilter) return false
        if (returnConsumedCapacity != other.returnConsumedCapacity) return false
        if (scanIndexForward != other.scanIndexForward) return false
        if (select != other.select) return false
        if (tableName != other.tableName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dynamodb.model.QueryRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * This is a legacy parameter. Use `ProjectionExpression` instead. For more information, see [AttributesToGet](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.AttributesToGet.html) in the *Amazon DynamoDB Developer Guide*.
         */
        public var attributesToGet: List<String>? = null
        /**
         * This is a legacy parameter. Use `FilterExpression` instead. For more information, see [ConditionalOperator](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.ConditionalOperator.html) in the *Amazon DynamoDB Developer Guide*.
         */
        public var conditionalOperator: aws.sdk.kotlin.services.dynamodb.model.ConditionalOperator? = null
        /**
         * Determines the read consistency model: If set to `true`, then the operation uses strongly consistent reads; otherwise, the operation uses eventually consistent reads.
         *
         * Strongly consistent reads are not supported on global secondary indexes. If you query a global secondary index with `ConsistentRead` set to `true`, you will receive a `ValidationException`.
         */
        public var consistentRead: kotlin.Boolean? = null
        /**
         * The primary key of the first item that this operation will evaluate. Use the value that was returned for `LastEvaluatedKey` in the previous operation.
         *
         * The data type for `ExclusiveStartKey` must be String, Number, or Binary. No set data types are allowed.
         */
        public var exclusiveStartKey: Map<String, AttributeValue>? = null
        /**
         * One or more substitution tokens for attribute names in an expression. The following are some use cases for using `ExpressionAttributeNames`:
         * + To access an attribute whose name conflicts with a DynamoDB reserved word.
         * + To create a placeholder for repeating occurrences of an attribute name in an expression.
         * + To prevent special characters in an attribute name from being misinterpreted in an expression.
         *
         * Use the **#** character in an expression to dereference an attribute name. For example, consider the following attribute name:
         * + `Percentile`
         *
         * The name of this attribute conflicts with a reserved word, so it cannot be used directly in an expression. (For the complete list of reserved words, see [Reserved Words](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html) in the *Amazon DynamoDB Developer Guide*). To work around this, you could specify the following for `ExpressionAttributeNames`:
         * + `{"#P":"Percentile"}`
         *
         * You could then use this substitution in an expression, as in this example:
         * + `#P = :val`
         *
         * Tokens that begin with the **:** character are *expression attribute values*, which are placeholders for the actual value at runtime.
         *
         * For more information on expression attribute names, see [Specifying Item Attributes](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html) in the *Amazon DynamoDB Developer Guide*.
         */
        public var expressionAttributeNames: Map<String, String>? = null
        /**
         * One or more values that can be substituted in an expression.
         *
         * Use the **:** (colon) character in an expression to dereference an attribute value. For example, suppose that you wanted to check whether the value of the *ProductStatus* attribute was one of the following:
         *
         * `Available | Backordered | Discontinued`
         *
         * You would first need to specify `ExpressionAttributeValues` as follows:
         *
         * `{ ":avail":{"S":"Available"}, ":back":{"S":"Backordered"}, ":disc":{"S":"Discontinued"} }`
         *
         * You could then use these values in an expression, such as this:
         *
         * `ProductStatus IN (:avail, :back, :disc)`
         *
         * For more information on expression attribute values, see [Specifying Conditions](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.SpecifyingConditions.html) in the *Amazon DynamoDB Developer Guide*.
         */
        public var expressionAttributeValues: Map<String, AttributeValue>? = null
        /**
         * A string that contains conditions that DynamoDB applies after the `Query` operation, but before the data is returned to you. Items that do not satisfy the `FilterExpression` criteria are not returned.
         *
         * A `FilterExpression` does not allow key attributes. You cannot define a filter expression based on a partition key or a sort key.
         *
         * A `FilterExpression` is applied after the items have already been read; the process of filtering does not consume any additional read capacity units.
         *
         * For more information, see [Filter Expressions](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html#Query.FilterExpression) in the *Amazon DynamoDB Developer Guide*.
         */
        public var filterExpression: kotlin.String? = null
        /**
         * The name of an index to query. This index can be any local secondary index or global secondary index on the table. Note that if you use the `IndexName` parameter, you must also provide `TableName.`
         */
        public var indexName: kotlin.String? = null
        /**
         * The condition that specifies the key values for items to be retrieved by the `Query` action.
         *
         * The condition must perform an equality test on a single partition key value.
         *
         * The condition can optionally perform one of several comparison tests on a single sort key value. This allows `Query` to retrieve one item with a given partition key value and sort key value, or several items that have the same partition key value but different sort key values.
         *
         * The partition key equality test is required, and must be specified in the following format:
         *
         * `partitionKeyName`*=*`:partitionkeyval`
         *
         * If you also want to provide a condition for the sort key, it must be combined using `AND` with the condition for the sort key. Following is an example, using the **=** comparison operator for the sort key:
         *
         * `partitionKeyName``=``:partitionkeyval``AND``sortKeyName``=``:sortkeyval`
         *
         * Valid comparisons for the sort key condition are as follows:
         * + `sortKeyName``=``:sortkeyval` - true if the sort key value is equal to `:sortkeyval`.
         * + `sortKeyName``<``:sortkeyval` - true if the sort key value is less than `:sortkeyval`.
         * + `sortKeyName``<=``:sortkeyval` - true if the sort key value is less than or equal to `:sortkeyval`.
         * + `sortKeyName``>``:sortkeyval` - true if the sort key value is greater than `:sortkeyval`.
         * + `sortKeyName``>= ``:sortkeyval` - true if the sort key value is greater than or equal to `:sortkeyval`.
         * + `sortKeyName``BETWEEN``:sortkeyval1``AND``:sortkeyval2` - true if the sort key value is greater than or equal to `:sortkeyval1`, and less than or equal to `:sortkeyval2`.
         * + `begins_with (``sortKeyName`, `:sortkeyval``)` - true if the sort key value begins with a particular operand. (You cannot use this function with a sort key that is of type Number.) Note that the function name `begins_with` is case-sensitive.
         *
         * Use the `ExpressionAttributeValues` parameter to replace tokens such as `:partitionval` and `:sortval` with actual values at runtime.
         *
         * You can optionally use the `ExpressionAttributeNames` parameter to replace the names of the partition key and sort key with placeholder tokens. This option might be necessary if an attribute name conflicts with a DynamoDB reserved word. For example, the following `KeyConditionExpression` parameter causes an error because *Size* is a reserved word:
         * + `Size = :myval`
         *
         * To work around this, define a placeholder (such a `#S`) to represent the attribute name *Size*. `KeyConditionExpression` then is as follows:
         * + `#S = :myval`
         *
         * For a list of reserved words, see [Reserved Words](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ReservedWords.html) in the *Amazon DynamoDB Developer Guide*.
         *
         * For more information on `ExpressionAttributeNames` and `ExpressionAttributeValues`, see [Using Placeholders for Attribute Names and Values](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ExpressionPlaceholders.html) in the *Amazon DynamoDB Developer Guide*.
         */
        public var keyConditionExpression: kotlin.String? = null
        /**
         * This is a legacy parameter. Use `KeyConditionExpression` instead. For more information, see [KeyConditions](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.KeyConditions.html) in the *Amazon DynamoDB Developer Guide*.
         */
        public var keyConditions: Map<String, Condition>? = null
        /**
         * The maximum number of items to evaluate (not necessarily the number of matching items). If DynamoDB processes the number of items up to the limit while processing the results, it stops the operation and returns the matching values up to that point, and a key in `LastEvaluatedKey` to apply in a subsequent operation, so that you can pick up where you left off. Also, if the processed dataset size exceeds 1 MB before DynamoDB reaches this limit, it stops the operation and returns the matching values up to the limit, and a key in `LastEvaluatedKey` to apply in a subsequent operation to continue the operation. For more information, see [Query and Scan](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/QueryAndScan.html) in the *Amazon DynamoDB Developer Guide*.
         */
        public var limit: kotlin.Int? = null
        /**
         * A string that identifies one or more attributes to retrieve from the table. These attributes can include scalars, sets, or elements of a JSON document. The attributes in the expression must be separated by commas.
         *
         * If no attribute names are specified, then all attributes will be returned. If any of the requested attributes are not found, they will not appear in the result.
         *
         * For more information, see [Accessing Item Attributes](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Expressions.AccessingItemAttributes.html) in the *Amazon DynamoDB Developer Guide*.
         */
        public var projectionExpression: kotlin.String? = null
        /**
         * This is a legacy parameter. Use `FilterExpression` instead. For more information, see [QueryFilter](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/LegacyConditionalParameters.QueryFilter.html) in the *Amazon DynamoDB Developer Guide*.
         */
        public var queryFilter: Map<String, Condition>? = null
        /**
         * Determines the level of detail about either provisioned or on-demand throughput consumption that is returned in the response:
         * + `INDEXES` - The response includes the aggregate `ConsumedCapacity` for the operation, together with `ConsumedCapacity` for each table and secondary index that was accessed.Note that some operations, such as `GetItem` and `BatchGetItem`, do not access any indexes at all. In these cases, specifying `INDEXES` will only return `ConsumedCapacity` information for table(s).
         * + `TOTAL` - The response includes only the aggregate `ConsumedCapacity` for the operation.
         * + `NONE` - No `ConsumedCapacity` details are included in the response.
         */
        public var returnConsumedCapacity: aws.sdk.kotlin.services.dynamodb.model.ReturnConsumedCapacity? = null
        /**
         * Specifies the order for index traversal: If `true` (default), the traversal is performed in ascending order; if `false`, the traversal is performed in descending order.
         *
         * Items with the same partition key value are stored in sorted order by sort key. If the sort key data type is Number, the results are stored in numeric order. For type String, the results are stored in order of UTF-8 bytes. For type Binary, DynamoDB treats each byte of the binary data as unsigned.
         *
         * If `ScanIndexForward` is `true`, DynamoDB returns the results in the order in which they are stored (by sort key value). This is the default behavior. If `ScanIndexForward` is `false`, DynamoDB reads the results in reverse order by sort key value, and then returns the results to the client.
         */
        public var scanIndexForward: kotlin.Boolean? = null
        /**
         * The attributes to be returned in the result. You can retrieve all item attributes, specific item attributes, the count of matching items, or in the case of an index, some or all of the attributes projected into the index.
         * + `ALL_ATTRIBUTES` - Returns all of the item attributes from the specified table or index. If you query a local secondary index, then for each matching item in the index, DynamoDB fetches the entire item from the parent table. If the index is configured to project all item attributes, then all of the data can be obtained from the local secondary index, and no fetching is required.
         * + `ALL_PROJECTED_ATTRIBUTES` - Allowed only when querying an index. Retrieves all attributes that have been projected into the index. If the index is configured to project all attributes, this return value is equivalent to specifying `ALL_ATTRIBUTES`.
         * + `COUNT` - Returns the number of matching items, rather than the matching items themselves. Note that this uses the same quantity of read capacity units as getting the items, and is subject to the same item size calculations.
         * + `SPECIFIC_ATTRIBUTES` - Returns only the attributes listed in `ProjectionExpression`. This return value is equivalent to specifying `ProjectionExpression` without specifying any value for `Select`.If you query or scan a local secondary index and request only attributes that are projected into that index, the operation will read only the index and not the table. If any of the requested attributes are not projected into the local secondary index, DynamoDB fetches each of these attributes from the parent table. This extra fetching incurs additional throughput cost and latency.If you query or scan a global secondary index, you can only request attributes that are projected into the index. Global secondary index queries cannot fetch attributes from the parent table.
         *
         * If neither `Select` nor `ProjectionExpression` are specified, DynamoDB defaults to `ALL_ATTRIBUTES` when accessing a table, and `ALL_PROJECTED_ATTRIBUTES` when accessing an index. You cannot use both `Select` and `ProjectionExpression` together in a single request, unless the value for `Select` is `SPECIFIC_ATTRIBUTES`. (This usage is equivalent to specifying `ProjectionExpression` without any value for `Select`.)
         *
         * If you use the `ProjectionExpression` parameter, then the value for `Select` can only be `SPECIFIC_ATTRIBUTES`. Any other value for `Select` will return an error.
         */
        public var select: aws.sdk.kotlin.services.dynamodb.model.Select? = null
        /**
         * The name of the table containing the requested items.
         */
        public var tableName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dynamodb.model.QueryRequest) : this() {
            this.attributesToGet = x.attributesToGet
            this.conditionalOperator = x.conditionalOperator
            this.consistentRead = x.consistentRead
            this.exclusiveStartKey = x.exclusiveStartKey
            this.expressionAttributeNames = x.expressionAttributeNames
            this.expressionAttributeValues = x.expressionAttributeValues
            this.filterExpression = x.filterExpression
            this.indexName = x.indexName
            this.keyConditionExpression = x.keyConditionExpression
            this.keyConditions = x.keyConditions
            this.limit = x.limit
            this.projectionExpression = x.projectionExpression
            this.queryFilter = x.queryFilter
            this.returnConsumedCapacity = x.returnConsumedCapacity
            this.scanIndexForward = x.scanIndexForward
            this.select = x.select
            this.tableName = x.tableName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dynamodb.model.QueryRequest = QueryRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
