// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dynamodb.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Represents the provisioned throughput settings for the table, consisting of read and write capacity units, along with data about increases and decreases.
 */
public class ProvisionedThroughputDescription private constructor(builder: Builder) {
    /**
     * The date and time of the last provisioned throughput decrease for this table.
     */
    public val lastDecreaseDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastDecreaseDateTime
    /**
     * The date and time of the last provisioned throughput increase for this table.
     */
    public val lastIncreaseDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastIncreaseDateTime
    /**
     * The number of provisioned throughput decreases for this table during this UTC calendar day. For current maximums on provisioned throughput decreases, see [Service, Account, and Table Quotas](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html) in the *Amazon DynamoDB Developer Guide*.
     */
    public val numberOfDecreasesToday: kotlin.Long? = builder.numberOfDecreasesToday
    /**
     * The maximum number of strongly consistent reads consumed per second before DynamoDB returns a `ThrottlingException`. Eventually consistent reads require less effort than strongly consistent reads, so a setting of 50 `ReadCapacityUnits` per second provides 100 eventually consistent `ReadCapacityUnits` per second.
     */
    public val readCapacityUnits: kotlin.Long? = builder.readCapacityUnits
    /**
     * The maximum number of writes consumed per second before DynamoDB returns a `ThrottlingException`.
     */
    public val writeCapacityUnits: kotlin.Long? = builder.writeCapacityUnits

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dynamodb.model.ProvisionedThroughputDescription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ProvisionedThroughputDescription(")
        append("lastDecreaseDateTime=$lastDecreaseDateTime,")
        append("lastIncreaseDateTime=$lastIncreaseDateTime,")
        append("numberOfDecreasesToday=$numberOfDecreasesToday,")
        append("readCapacityUnits=$readCapacityUnits,")
        append("writeCapacityUnits=$writeCapacityUnits")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = lastDecreaseDateTime?.hashCode() ?: 0
        result = 31 * result + (lastIncreaseDateTime?.hashCode() ?: 0)
        result = 31 * result + (numberOfDecreasesToday?.hashCode() ?: 0)
        result = 31 * result + (readCapacityUnits?.hashCode() ?: 0)
        result = 31 * result + (writeCapacityUnits?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ProvisionedThroughputDescription

        if (lastDecreaseDateTime != other.lastDecreaseDateTime) return false
        if (lastIncreaseDateTime != other.lastIncreaseDateTime) return false
        if (numberOfDecreasesToday != other.numberOfDecreasesToday) return false
        if (readCapacityUnits != other.readCapacityUnits) return false
        if (writeCapacityUnits != other.writeCapacityUnits) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dynamodb.model.ProvisionedThroughputDescription = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The date and time of the last provisioned throughput decrease for this table.
         */
        public var lastDecreaseDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The date and time of the last provisioned throughput increase for this table.
         */
        public var lastIncreaseDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The number of provisioned throughput decreases for this table during this UTC calendar day. For current maximums on provisioned throughput decreases, see [Service, Account, and Table Quotas](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html) in the *Amazon DynamoDB Developer Guide*.
         */
        public var numberOfDecreasesToday: kotlin.Long? = null
        /**
         * The maximum number of strongly consistent reads consumed per second before DynamoDB returns a `ThrottlingException`. Eventually consistent reads require less effort than strongly consistent reads, so a setting of 50 `ReadCapacityUnits` per second provides 100 eventually consistent `ReadCapacityUnits` per second.
         */
        public var readCapacityUnits: kotlin.Long? = null
        /**
         * The maximum number of writes consumed per second before DynamoDB returns a `ThrottlingException`.
         */
        public var writeCapacityUnits: kotlin.Long? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dynamodb.model.ProvisionedThroughputDescription) : this() {
            this.lastDecreaseDateTime = x.lastDecreaseDateTime
            this.lastIncreaseDateTime = x.lastIncreaseDateTime
            this.numberOfDecreasesToday = x.numberOfDecreasesToday
            this.readCapacityUnits = x.readCapacityUnits
            this.writeCapacityUnits = x.writeCapacityUnits
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dynamodb.model.ProvisionedThroughputDescription = ProvisionedThroughputDescription(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
