// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dynamodb.model



/**
 * Represents attributes that are copied (projected) from the table into an index. These are in addition to the primary key attributes and index key attributes, which are automatically projected.
 */
public class Projection private constructor(builder: Builder) {
    /**
     * Represents the non-key attribute names which will be projected into the index.
     *
     * For local secondary indexes, the total count of `NonKeyAttributes` summed across all of the local secondary indexes, must not exceed 100. If you project the same attribute into two different indexes, this counts as two distinct attributes when determining the total.
     */
    public val nonKeyAttributes: List<String>? = builder.nonKeyAttributes
    /**
     * The set of attributes that are projected into the index:
     * + `KEYS_ONLY` - Only the index and primary keys are projected into the index.
     * + `INCLUDE` - In addition to the attributes described in `KEYS_ONLY`, the secondary index will include other non-key attributes that you specify.
     * + `ALL` - All of the table attributes are projected into the index.
     */
    public val projectionType: aws.sdk.kotlin.services.dynamodb.model.ProjectionType? = builder.projectionType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dynamodb.model.Projection = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Projection(")
        append("nonKeyAttributes=$nonKeyAttributes,")
        append("projectionType=$projectionType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = nonKeyAttributes?.hashCode() ?: 0
        result = 31 * result + (projectionType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Projection

        if (nonKeyAttributes != other.nonKeyAttributes) return false
        if (projectionType != other.projectionType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dynamodb.model.Projection = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Represents the non-key attribute names which will be projected into the index.
         *
         * For local secondary indexes, the total count of `NonKeyAttributes` summed across all of the local secondary indexes, must not exceed 100. If you project the same attribute into two different indexes, this counts as two distinct attributes when determining the total.
         */
        public var nonKeyAttributes: List<String>? = null
        /**
         * The set of attributes that are projected into the index:
         * + `KEYS_ONLY` - Only the index and primary keys are projected into the index.
         * + `INCLUDE` - In addition to the attributes described in `KEYS_ONLY`, the secondary index will include other non-key attributes that you specify.
         * + `ALL` - All of the table attributes are projected into the index.
         */
        public var projectionType: aws.sdk.kotlin.services.dynamodb.model.ProjectionType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dynamodb.model.Projection) : this() {
            this.nonKeyAttributes = x.nonKeyAttributes
            this.projectionType = x.projectionType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dynamodb.model.Projection = Projection(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
