// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dynamodb.model



/**
 * Represents a PartiQL statment that uses parameters.
 */
public class ParameterizedStatement private constructor(builder: Builder) {
    /**
     * The parameter values.
     */
    public val parameters: List<AttributeValue>? = builder.parameters
    /**
     * An optional parameter that returns the item attributes for a PartiQL `ParameterizedStatement` operation that failed a condition check.
     *
     * There is no additional cost associated with requesting a return value aside from the small network and processing overhead of receiving a larger response. No read capacity units are consumed.
     */
    public val returnValuesOnConditionCheckFailure: aws.sdk.kotlin.services.dynamodb.model.ReturnValuesOnConditionCheckFailure? = builder.returnValuesOnConditionCheckFailure
    /**
     * A PartiQL statment that uses parameters.
     */
    public val statement: kotlin.String = requireNotNull(builder.statement) { "A non-null value must be provided for statement" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dynamodb.model.ParameterizedStatement = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ParameterizedStatement(")
        append("parameters=$parameters,")
        append("returnValuesOnConditionCheckFailure=$returnValuesOnConditionCheckFailure,")
        append("statement=$statement")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = parameters?.hashCode() ?: 0
        result = 31 * result + (returnValuesOnConditionCheckFailure?.hashCode() ?: 0)
        result = 31 * result + (statement.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ParameterizedStatement

        if (parameters != other.parameters) return false
        if (returnValuesOnConditionCheckFailure != other.returnValuesOnConditionCheckFailure) return false
        if (statement != other.statement) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dynamodb.model.ParameterizedStatement = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The parameter values.
         */
        public var parameters: List<AttributeValue>? = null
        /**
         * An optional parameter that returns the item attributes for a PartiQL `ParameterizedStatement` operation that failed a condition check.
         *
         * There is no additional cost associated with requesting a return value aside from the small network and processing overhead of receiving a larger response. No read capacity units are consumed.
         */
        public var returnValuesOnConditionCheckFailure: aws.sdk.kotlin.services.dynamodb.model.ReturnValuesOnConditionCheckFailure? = null
        /**
         * A PartiQL statment that uses parameters.
         */
        public var statement: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dynamodb.model.ParameterizedStatement) : this() {
            this.parameters = x.parameters
            this.returnValuesOnConditionCheckFailure = x.returnValuesOnConditionCheckFailure
            this.statement = x.statement
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dynamodb.model.ParameterizedStatement = ParameterizedStatement(this)

        internal fun correctErrors(): Builder {
            if (statement == null) statement = ""
            return this
        }
    }
}
