// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dynamodb.model



/**
 * Represents the output of a `ListTables` operation.
 */
public class ListTablesResponse private constructor(builder: Builder) {
    /**
     * The name of the last table in the current page of results. Use this value as the `ExclusiveStartTableName` in a new request to obtain the next page of results, until all the table names are returned.
     *
     * If you do not receive a `LastEvaluatedTableName` value in the response, this means that there are no more table names to be retrieved.
     */
    public val lastEvaluatedTableName: kotlin.String? = builder.lastEvaluatedTableName
    /**
     * The names of the tables associated with the current account at the current endpoint. The maximum size of this array is 100.
     *
     * If `LastEvaluatedTableName` also appears in the output, you can use this value as the `ExclusiveStartTableName` parameter in a subsequent `ListTables` request and obtain the next page of results.
     */
    public val tableNames: List<String>? = builder.tableNames

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dynamodb.model.ListTablesResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListTablesResponse(")
        append("lastEvaluatedTableName=$lastEvaluatedTableName,")
        append("tableNames=$tableNames")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = lastEvaluatedTableName?.hashCode() ?: 0
        result = 31 * result + (tableNames?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListTablesResponse

        if (lastEvaluatedTableName != other.lastEvaluatedTableName) return false
        if (tableNames != other.tableNames) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dynamodb.model.ListTablesResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the last table in the current page of results. Use this value as the `ExclusiveStartTableName` in a new request to obtain the next page of results, until all the table names are returned.
         *
         * If you do not receive a `LastEvaluatedTableName` value in the response, this means that there are no more table names to be retrieved.
         */
        public var lastEvaluatedTableName: kotlin.String? = null
        /**
         * The names of the tables associated with the current account at the current endpoint. The maximum size of this array is 100.
         *
         * If `LastEvaluatedTableName` also appears in the output, you can use this value as the `ExclusiveStartTableName` parameter in a subsequent `ListTables` request and obtain the next page of results.
         */
        public var tableNames: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dynamodb.model.ListTablesResponse) : this() {
            this.lastEvaluatedTableName = x.lastEvaluatedTableName
            this.tableNames = x.tableNames
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dynamodb.model.ListTablesResponse = ListTablesResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
