// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dynamodb.model

import aws.smithy.kotlin.runtime.time.Instant

public class ListBackupsRequest private constructor(builder: Builder) {
    /**
     * The backups from the table specified by `BackupType` are listed.
     *
     * Where `BackupType` can be:
     * + `USER` - On-demand backup created by you. (The default setting if no other backup types are specified.)
     * + `SYSTEM` - On-demand backup automatically created by DynamoDB.
     * + `ALL` - All types of on-demand backups (USER and SYSTEM).
     */
    public val backupType: aws.sdk.kotlin.services.dynamodb.model.BackupTypeFilter? = builder.backupType
    /**
     * `LastEvaluatedBackupArn` is the Amazon Resource Name (ARN) of the backup last evaluated when the current page of results was returned, inclusive of the current page of results. This value may be specified as the `ExclusiveStartBackupArn` of a new `ListBackups` operation in order to fetch the next page of results.
     */
    public val exclusiveStartBackupArn: kotlin.String? = builder.exclusiveStartBackupArn
    /**
     * Maximum number of backups to return at once.
     */
    public val limit: kotlin.Int? = builder.limit
    /**
     * The backups from the table specified by `TableName` are listed.
     */
    public val tableName: kotlin.String? = builder.tableName
    /**
     * Only backups created after this time are listed. `TimeRangeLowerBound` is inclusive.
     */
    public val timeRangeLowerBound: aws.smithy.kotlin.runtime.time.Instant? = builder.timeRangeLowerBound
    /**
     * Only backups created before this time are listed. `TimeRangeUpperBound` is exclusive.
     */
    public val timeRangeUpperBound: aws.smithy.kotlin.runtime.time.Instant? = builder.timeRangeUpperBound

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dynamodb.model.ListBackupsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListBackupsRequest(")
        append("backupType=$backupType,")
        append("exclusiveStartBackupArn=$exclusiveStartBackupArn,")
        append("limit=$limit,")
        append("tableName=$tableName,")
        append("timeRangeLowerBound=$timeRangeLowerBound,")
        append("timeRangeUpperBound=$timeRangeUpperBound")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = backupType?.hashCode() ?: 0
        result = 31 * result + (exclusiveStartBackupArn?.hashCode() ?: 0)
        result = 31 * result + (limit ?: 0)
        result = 31 * result + (tableName?.hashCode() ?: 0)
        result = 31 * result + (timeRangeLowerBound?.hashCode() ?: 0)
        result = 31 * result + (timeRangeUpperBound?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListBackupsRequest

        if (backupType != other.backupType) return false
        if (exclusiveStartBackupArn != other.exclusiveStartBackupArn) return false
        if (limit != other.limit) return false
        if (tableName != other.tableName) return false
        if (timeRangeLowerBound != other.timeRangeLowerBound) return false
        if (timeRangeUpperBound != other.timeRangeUpperBound) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dynamodb.model.ListBackupsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The backups from the table specified by `BackupType` are listed.
         *
         * Where `BackupType` can be:
         * + `USER` - On-demand backup created by you. (The default setting if no other backup types are specified.)
         * + `SYSTEM` - On-demand backup automatically created by DynamoDB.
         * + `ALL` - All types of on-demand backups (USER and SYSTEM).
         */
        public var backupType: aws.sdk.kotlin.services.dynamodb.model.BackupTypeFilter? = null
        /**
         * `LastEvaluatedBackupArn` is the Amazon Resource Name (ARN) of the backup last evaluated when the current page of results was returned, inclusive of the current page of results. This value may be specified as the `ExclusiveStartBackupArn` of a new `ListBackups` operation in order to fetch the next page of results.
         */
        public var exclusiveStartBackupArn: kotlin.String? = null
        /**
         * Maximum number of backups to return at once.
         */
        public var limit: kotlin.Int? = null
        /**
         * The backups from the table specified by `TableName` are listed.
         */
        public var tableName: kotlin.String? = null
        /**
         * Only backups created after this time are listed. `TimeRangeLowerBound` is inclusive.
         */
        public var timeRangeLowerBound: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Only backups created before this time are listed. `TimeRangeUpperBound` is exclusive.
         */
        public var timeRangeUpperBound: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dynamodb.model.ListBackupsRequest) : this() {
            this.backupType = x.backupType
            this.exclusiveStartBackupArn = x.exclusiveStartBackupArn
            this.limit = x.limit
            this.tableName = x.tableName
            this.timeRangeLowerBound = x.timeRangeLowerBound
            this.timeRangeUpperBound = x.timeRangeUpperBound
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dynamodb.model.ListBackupsRequest = ListBackupsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
