// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dynamodb.model



/**
 * Information about item collections, if any, that were affected by the operation. `ItemCollectionMetrics` is only returned if the request asked for it. If the table does not have any local secondary indexes, this information is not returned in the response.
 */
public class ItemCollectionMetrics private constructor(builder: Builder) {
    /**
     * The partition key value of the item collection. This value is the same as the partition key value of the item.
     */
    public val itemCollectionKey: Map<String, AttributeValue>? = builder.itemCollectionKey
    /**
     * An estimate of item collection size, in gigabytes. This value is a two-element array containing a lower bound and an upper bound for the estimate. The estimate includes the size of all the items in the table, plus the size of all attributes projected into all of the local secondary indexes on that table. Use this estimate to measure whether a local secondary index is approaching its size limit.
     *
     * The estimate is subject to change over time; therefore, do not rely on the precision or accuracy of the estimate.
     */
    public val sizeEstimateRangeGb: List<Double>? = builder.sizeEstimateRangeGb

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dynamodb.model.ItemCollectionMetrics = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ItemCollectionMetrics(")
        append("itemCollectionKey=$itemCollectionKey,")
        append("sizeEstimateRangeGb=$sizeEstimateRangeGb")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = itemCollectionKey?.hashCode() ?: 0
        result = 31 * result + (sizeEstimateRangeGb?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ItemCollectionMetrics

        if (itemCollectionKey != other.itemCollectionKey) return false
        if (sizeEstimateRangeGb != other.sizeEstimateRangeGb) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dynamodb.model.ItemCollectionMetrics = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The partition key value of the item collection. This value is the same as the partition key value of the item.
         */
        public var itemCollectionKey: Map<String, AttributeValue>? = null
        /**
         * An estimate of item collection size, in gigabytes. This value is a two-element array containing a lower bound and an upper bound for the estimate. The estimate includes the size of all the items in the table, plus the size of all attributes projected into all of the local secondary indexes on that table. Use this estimate to measure whether a local secondary index is approaching its size limit.
         *
         * The estimate is subject to change over time; therefore, do not rely on the precision or accuracy of the estimate.
         */
        public var sizeEstimateRangeGb: List<Double>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dynamodb.model.ItemCollectionMetrics) : this() {
            this.itemCollectionKey = x.itemCollectionKey
            this.sizeEstimateRangeGb = x.sizeEstimateRangeGb
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dynamodb.model.ItemCollectionMetrics = ItemCollectionMetrics(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
