// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dynamodb.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Represents the properties of the table being imported into.
 */
public class ImportTableDescription private constructor(builder: Builder) {
    /**
     * The client token that was provided for the import task. Reusing the client token on retry makes a call to `ImportTable` idempotent.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The Amazon Resource Number (ARN) of the Cloudwatch Log Group associated with the target table.
     */
    public val cloudWatchLogGroupArn: kotlin.String? = builder.cloudWatchLogGroupArn
    /**
     * The time at which the creation of the table associated with this import task completed.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The number of errors occurred on importing the source file into the target table.
     */
    public val errorCount: kotlin.Long = builder.errorCount
    /**
     * The error code corresponding to the failure that the import job ran into during execution.
     */
    public val failureCode: kotlin.String? = builder.failureCode
    /**
     * The error message corresponding to the failure that the import job ran into during execution.
     */
    public val failureMessage: kotlin.String? = builder.failureMessage
    /**
     * The Amazon Resource Number (ARN) corresponding to the import request.
     */
    public val importArn: kotlin.String? = builder.importArn
    /**
     * The status of the import.
     */
    public val importStatus: aws.sdk.kotlin.services.dynamodb.model.ImportStatus? = builder.importStatus
    /**
     * The number of items successfully imported into the new table.
     */
    public val importedItemCount: kotlin.Long = builder.importedItemCount
    /**
     * The compression options for the data that has been imported into the target table. The values are NONE, GZIP, or ZSTD.
     */
    public val inputCompressionType: aws.sdk.kotlin.services.dynamodb.model.InputCompressionType? = builder.inputCompressionType
    /**
     * The format of the source data going into the target table.
     */
    public val inputFormat: aws.sdk.kotlin.services.dynamodb.model.InputFormat? = builder.inputFormat
    /**
     * The format options for the data that was imported into the target table. There is one value, CsvOption.
     */
    public val inputFormatOptions: aws.sdk.kotlin.services.dynamodb.model.InputFormatOptions? = builder.inputFormatOptions
    /**
     * The total number of items processed from the source file.
     */
    public val processedItemCount: kotlin.Long = builder.processedItemCount
    /**
     * The total size of data processed from the source file, in Bytes.
     */
    public val processedSizeBytes: kotlin.Long? = builder.processedSizeBytes
    /**
     * Values for the S3 bucket the source file is imported from. Includes bucket name (required), key prefix (optional) and bucket account owner ID (optional).
     */
    public val s3BucketSource: aws.sdk.kotlin.services.dynamodb.model.S3BucketSource? = builder.s3BucketSource
    /**
     * The time when this import task started.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * The Amazon Resource Number (ARN) of the table being imported into.
     */
    public val tableArn: kotlin.String? = builder.tableArn
    /**
     * The parameters for the new table that is being imported into.
     */
    public val tableCreationParameters: aws.sdk.kotlin.services.dynamodb.model.TableCreationParameters? = builder.tableCreationParameters
    /**
     * The table id corresponding to the table created by import table process.
     */
    public val tableId: kotlin.String? = builder.tableId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dynamodb.model.ImportTableDescription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ImportTableDescription(")
        append("clientToken=$clientToken,")
        append("cloudWatchLogGroupArn=$cloudWatchLogGroupArn,")
        append("endTime=$endTime,")
        append("errorCount=$errorCount,")
        append("failureCode=$failureCode,")
        append("failureMessage=$failureMessage,")
        append("importArn=$importArn,")
        append("importStatus=$importStatus,")
        append("importedItemCount=$importedItemCount,")
        append("inputCompressionType=$inputCompressionType,")
        append("inputFormat=$inputFormat,")
        append("inputFormatOptions=$inputFormatOptions,")
        append("processedItemCount=$processedItemCount,")
        append("processedSizeBytes=$processedSizeBytes,")
        append("s3BucketSource=$s3BucketSource,")
        append("startTime=$startTime,")
        append("tableArn=$tableArn,")
        append("tableCreationParameters=$tableCreationParameters,")
        append("tableId=$tableId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (cloudWatchLogGroupArn?.hashCode() ?: 0)
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (errorCount.hashCode())
        result = 31 * result + (failureCode?.hashCode() ?: 0)
        result = 31 * result + (failureMessage?.hashCode() ?: 0)
        result = 31 * result + (importArn?.hashCode() ?: 0)
        result = 31 * result + (importStatus?.hashCode() ?: 0)
        result = 31 * result + (importedItemCount.hashCode())
        result = 31 * result + (inputCompressionType?.hashCode() ?: 0)
        result = 31 * result + (inputFormat?.hashCode() ?: 0)
        result = 31 * result + (inputFormatOptions?.hashCode() ?: 0)
        result = 31 * result + (processedItemCount.hashCode())
        result = 31 * result + (processedSizeBytes?.hashCode() ?: 0)
        result = 31 * result + (s3BucketSource?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (tableArn?.hashCode() ?: 0)
        result = 31 * result + (tableCreationParameters?.hashCode() ?: 0)
        result = 31 * result + (tableId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ImportTableDescription

        if (clientToken != other.clientToken) return false
        if (cloudWatchLogGroupArn != other.cloudWatchLogGroupArn) return false
        if (endTime != other.endTime) return false
        if (errorCount != other.errorCount) return false
        if (failureCode != other.failureCode) return false
        if (failureMessage != other.failureMessage) return false
        if (importArn != other.importArn) return false
        if (importStatus != other.importStatus) return false
        if (importedItemCount != other.importedItemCount) return false
        if (inputCompressionType != other.inputCompressionType) return false
        if (inputFormat != other.inputFormat) return false
        if (inputFormatOptions != other.inputFormatOptions) return false
        if (processedItemCount != other.processedItemCount) return false
        if (processedSizeBytes != other.processedSizeBytes) return false
        if (s3BucketSource != other.s3BucketSource) return false
        if (startTime != other.startTime) return false
        if (tableArn != other.tableArn) return false
        if (tableCreationParameters != other.tableCreationParameters) return false
        if (tableId != other.tableId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dynamodb.model.ImportTableDescription = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The client token that was provided for the import task. Reusing the client token on retry makes a call to `ImportTable` idempotent.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The Amazon Resource Number (ARN) of the Cloudwatch Log Group associated with the target table.
         */
        public var cloudWatchLogGroupArn: kotlin.String? = null
        /**
         * The time at which the creation of the table associated with this import task completed.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The number of errors occurred on importing the source file into the target table.
         */
        public var errorCount: kotlin.Long = 0L
        /**
         * The error code corresponding to the failure that the import job ran into during execution.
         */
        public var failureCode: kotlin.String? = null
        /**
         * The error message corresponding to the failure that the import job ran into during execution.
         */
        public var failureMessage: kotlin.String? = null
        /**
         * The Amazon Resource Number (ARN) corresponding to the import request.
         */
        public var importArn: kotlin.String? = null
        /**
         * The status of the import.
         */
        public var importStatus: aws.sdk.kotlin.services.dynamodb.model.ImportStatus? = null
        /**
         * The number of items successfully imported into the new table.
         */
        public var importedItemCount: kotlin.Long = 0L
        /**
         * The compression options for the data that has been imported into the target table. The values are NONE, GZIP, or ZSTD.
         */
        public var inputCompressionType: aws.sdk.kotlin.services.dynamodb.model.InputCompressionType? = null
        /**
         * The format of the source data going into the target table.
         */
        public var inputFormat: aws.sdk.kotlin.services.dynamodb.model.InputFormat? = null
        /**
         * The format options for the data that was imported into the target table. There is one value, CsvOption.
         */
        public var inputFormatOptions: aws.sdk.kotlin.services.dynamodb.model.InputFormatOptions? = null
        /**
         * The total number of items processed from the source file.
         */
        public var processedItemCount: kotlin.Long = 0L
        /**
         * The total size of data processed from the source file, in Bytes.
         */
        public var processedSizeBytes: kotlin.Long? = null
        /**
         * Values for the S3 bucket the source file is imported from. Includes bucket name (required), key prefix (optional) and bucket account owner ID (optional).
         */
        public var s3BucketSource: aws.sdk.kotlin.services.dynamodb.model.S3BucketSource? = null
        /**
         * The time when this import task started.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Number (ARN) of the table being imported into.
         */
        public var tableArn: kotlin.String? = null
        /**
         * The parameters for the new table that is being imported into.
         */
        public var tableCreationParameters: aws.sdk.kotlin.services.dynamodb.model.TableCreationParameters? = null
        /**
         * The table id corresponding to the table created by import table process.
         */
        public var tableId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dynamodb.model.ImportTableDescription) : this() {
            this.clientToken = x.clientToken
            this.cloudWatchLogGroupArn = x.cloudWatchLogGroupArn
            this.endTime = x.endTime
            this.errorCount = x.errorCount
            this.failureCode = x.failureCode
            this.failureMessage = x.failureMessage
            this.importArn = x.importArn
            this.importStatus = x.importStatus
            this.importedItemCount = x.importedItemCount
            this.inputCompressionType = x.inputCompressionType
            this.inputFormat = x.inputFormat
            this.inputFormatOptions = x.inputFormatOptions
            this.processedItemCount = x.processedItemCount
            this.processedSizeBytes = x.processedSizeBytes
            this.s3BucketSource = x.s3BucketSource
            this.startTime = x.startTime
            this.tableArn = x.tableArn
            this.tableCreationParameters = x.tableCreationParameters
            this.tableId = x.tableId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dynamodb.model.ImportTableDescription = ImportTableDescription(this)

        /**
         * construct an [aws.sdk.kotlin.services.dynamodb.model.InputFormatOptions] inside the given [block]
         */
        public fun inputFormatOptions(block: aws.sdk.kotlin.services.dynamodb.model.InputFormatOptions.Builder.() -> kotlin.Unit) {
            this.inputFormatOptions = aws.sdk.kotlin.services.dynamodb.model.InputFormatOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.dynamodb.model.S3BucketSource] inside the given [block]
         */
        public fun s3BucketSource(block: aws.sdk.kotlin.services.dynamodb.model.S3BucketSource.Builder.() -> kotlin.Unit) {
            this.s3BucketSource = aws.sdk.kotlin.services.dynamodb.model.S3BucketSource.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.dynamodb.model.TableCreationParameters] inside the given [block]
         */
        public fun tableCreationParameters(block: aws.sdk.kotlin.services.dynamodb.model.TableCreationParameters.Builder.() -> kotlin.Unit) {
            this.tableCreationParameters = aws.sdk.kotlin.services.dynamodb.model.TableCreationParameters.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
