// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dynamodb.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Summary information about the source file for the import.
 */
public class ImportSummary private constructor(builder: Builder) {
    /**
     * The Amazon Resource Number (ARN) of the Cloudwatch Log Group associated with this import task.
     */
    public val cloudWatchLogGroupArn: kotlin.String? = builder.cloudWatchLogGroupArn
    /**
     * The time at which this import task ended. (Does this include the successful complete creation of the table it was imported to?)
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The Amazon Resource Number (ARN) corresponding to the import request.
     */
    public val importArn: kotlin.String? = builder.importArn
    /**
     * The status of the import operation.
     */
    public val importStatus: aws.sdk.kotlin.services.dynamodb.model.ImportStatus? = builder.importStatus
    /**
     * The format of the source data. Valid values are `CSV`, `DYNAMODB_JSON` or `ION`.
     */
    public val inputFormat: aws.sdk.kotlin.services.dynamodb.model.InputFormat? = builder.inputFormat
    /**
     * The path and S3 bucket of the source file that is being imported. This includes the S3Bucket (required), S3KeyPrefix (optional) and S3BucketOwner (optional if the bucket is owned by the requester).
     */
    public val s3BucketSource: aws.sdk.kotlin.services.dynamodb.model.S3BucketSource? = builder.s3BucketSource
    /**
     * The time at which this import task began.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * The Amazon Resource Number (ARN) of the table being imported into.
     */
    public val tableArn: kotlin.String? = builder.tableArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dynamodb.model.ImportSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ImportSummary(")
        append("cloudWatchLogGroupArn=$cloudWatchLogGroupArn,")
        append("endTime=$endTime,")
        append("importArn=$importArn,")
        append("importStatus=$importStatus,")
        append("inputFormat=$inputFormat,")
        append("s3BucketSource=$s3BucketSource,")
        append("startTime=$startTime,")
        append("tableArn=$tableArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cloudWatchLogGroupArn?.hashCode() ?: 0
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (importArn?.hashCode() ?: 0)
        result = 31 * result + (importStatus?.hashCode() ?: 0)
        result = 31 * result + (inputFormat?.hashCode() ?: 0)
        result = 31 * result + (s3BucketSource?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (tableArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ImportSummary

        if (cloudWatchLogGroupArn != other.cloudWatchLogGroupArn) return false
        if (endTime != other.endTime) return false
        if (importArn != other.importArn) return false
        if (importStatus != other.importStatus) return false
        if (inputFormat != other.inputFormat) return false
        if (s3BucketSource != other.s3BucketSource) return false
        if (startTime != other.startTime) return false
        if (tableArn != other.tableArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dynamodb.model.ImportSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Number (ARN) of the Cloudwatch Log Group associated with this import task.
         */
        public var cloudWatchLogGroupArn: kotlin.String? = null
        /**
         * The time at which this import task ended. (Does this include the successful complete creation of the table it was imported to?)
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Number (ARN) corresponding to the import request.
         */
        public var importArn: kotlin.String? = null
        /**
         * The status of the import operation.
         */
        public var importStatus: aws.sdk.kotlin.services.dynamodb.model.ImportStatus? = null
        /**
         * The format of the source data. Valid values are `CSV`, `DYNAMODB_JSON` or `ION`.
         */
        public var inputFormat: aws.sdk.kotlin.services.dynamodb.model.InputFormat? = null
        /**
         * The path and S3 bucket of the source file that is being imported. This includes the S3Bucket (required), S3KeyPrefix (optional) and S3BucketOwner (optional if the bucket is owned by the requester).
         */
        public var s3BucketSource: aws.sdk.kotlin.services.dynamodb.model.S3BucketSource? = null
        /**
         * The time at which this import task began.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Number (ARN) of the table being imported into.
         */
        public var tableArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dynamodb.model.ImportSummary) : this() {
            this.cloudWatchLogGroupArn = x.cloudWatchLogGroupArn
            this.endTime = x.endTime
            this.importArn = x.importArn
            this.importStatus = x.importStatus
            this.inputFormat = x.inputFormat
            this.s3BucketSource = x.s3BucketSource
            this.startTime = x.startTime
            this.tableArn = x.tableArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dynamodb.model.ImportSummary = ImportSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.dynamodb.model.S3BucketSource] inside the given [block]
         */
        public fun s3BucketSource(block: aws.sdk.kotlin.services.dynamodb.model.S3BucketSource.Builder.() -> kotlin.Unit) {
            this.s3BucketSource = aws.sdk.kotlin.services.dynamodb.model.S3BucketSource.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
