// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dynamodb.model



/**
 * Represents the settings of a global secondary index for a global table that will be modified.
 */
public class GlobalTableGlobalSecondaryIndexSettingsUpdate private constructor(builder: Builder) {
    /**
     * The name of the global secondary index. The name must be unique among all other indexes on this table.
     */
    public val indexName: kotlin.String = requireNotNull(builder.indexName) { "A non-null value must be provided for indexName" }
    /**
     * Auto scaling settings for managing a global secondary index's write capacity units.
     */
    public val provisionedWriteCapacityAutoScalingSettingsUpdate: aws.sdk.kotlin.services.dynamodb.model.AutoScalingSettingsUpdate? = builder.provisionedWriteCapacityAutoScalingSettingsUpdate
    /**
     * The maximum number of writes consumed per second before DynamoDB returns a `ThrottlingException.`
     */
    public val provisionedWriteCapacityUnits: kotlin.Long? = builder.provisionedWriteCapacityUnits

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dynamodb.model.GlobalTableGlobalSecondaryIndexSettingsUpdate = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GlobalTableGlobalSecondaryIndexSettingsUpdate(")
        append("indexName=$indexName,")
        append("provisionedWriteCapacityAutoScalingSettingsUpdate=$provisionedWriteCapacityAutoScalingSettingsUpdate,")
        append("provisionedWriteCapacityUnits=$provisionedWriteCapacityUnits")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = indexName.hashCode()
        result = 31 * result + (provisionedWriteCapacityAutoScalingSettingsUpdate?.hashCode() ?: 0)
        result = 31 * result + (provisionedWriteCapacityUnits?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GlobalTableGlobalSecondaryIndexSettingsUpdate

        if (indexName != other.indexName) return false
        if (provisionedWriteCapacityAutoScalingSettingsUpdate != other.provisionedWriteCapacityAutoScalingSettingsUpdate) return false
        if (provisionedWriteCapacityUnits != other.provisionedWriteCapacityUnits) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dynamodb.model.GlobalTableGlobalSecondaryIndexSettingsUpdate = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the global secondary index. The name must be unique among all other indexes on this table.
         */
        public var indexName: kotlin.String? = null
        /**
         * Auto scaling settings for managing a global secondary index's write capacity units.
         */
        public var provisionedWriteCapacityAutoScalingSettingsUpdate: aws.sdk.kotlin.services.dynamodb.model.AutoScalingSettingsUpdate? = null
        /**
         * The maximum number of writes consumed per second before DynamoDB returns a `ThrottlingException.`
         */
        public var provisionedWriteCapacityUnits: kotlin.Long? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dynamodb.model.GlobalTableGlobalSecondaryIndexSettingsUpdate) : this() {
            this.indexName = x.indexName
            this.provisionedWriteCapacityAutoScalingSettingsUpdate = x.provisionedWriteCapacityAutoScalingSettingsUpdate
            this.provisionedWriteCapacityUnits = x.provisionedWriteCapacityUnits
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dynamodb.model.GlobalTableGlobalSecondaryIndexSettingsUpdate = GlobalTableGlobalSecondaryIndexSettingsUpdate(this)

        /**
         * construct an [aws.sdk.kotlin.services.dynamodb.model.AutoScalingSettingsUpdate] inside the given [block]
         */
        public fun provisionedWriteCapacityAutoScalingSettingsUpdate(block: aws.sdk.kotlin.services.dynamodb.model.AutoScalingSettingsUpdate.Builder.() -> kotlin.Unit) {
            this.provisionedWriteCapacityAutoScalingSettingsUpdate = aws.sdk.kotlin.services.dynamodb.model.AutoScalingSettingsUpdate.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (indexName == null) indexName = ""
            return this
        }
    }
}
