// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dynamodb.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains details about the global table.
 */
public class GlobalTableDescription private constructor(builder: Builder) {
    /**
     * The creation time of the global table.
     */
    public val creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDateTime
    /**
     * The unique identifier of the global table.
     */
    public val globalTableArn: kotlin.String? = builder.globalTableArn
    /**
     * The global table name.
     */
    public val globalTableName: kotlin.String? = builder.globalTableName
    /**
     * The current state of the global table:
     * + `CREATING` - The global table is being created.
     * + `UPDATING` - The global table is being updated.
     * + `DELETING` - The global table is being deleted.
     * + `ACTIVE` - The global table is ready for use.
     */
    public val globalTableStatus: aws.sdk.kotlin.services.dynamodb.model.GlobalTableStatus? = builder.globalTableStatus
    /**
     * The Regions where the global table has replicas.
     */
    public val replicationGroup: List<ReplicaDescription>? = builder.replicationGroup

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dynamodb.model.GlobalTableDescription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GlobalTableDescription(")
        append("creationDateTime=$creationDateTime,")
        append("globalTableArn=$globalTableArn,")
        append("globalTableName=$globalTableName,")
        append("globalTableStatus=$globalTableStatus,")
        append("replicationGroup=$replicationGroup")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationDateTime?.hashCode() ?: 0
        result = 31 * result + (globalTableArn?.hashCode() ?: 0)
        result = 31 * result + (globalTableName?.hashCode() ?: 0)
        result = 31 * result + (globalTableStatus?.hashCode() ?: 0)
        result = 31 * result + (replicationGroup?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GlobalTableDescription

        if (creationDateTime != other.creationDateTime) return false
        if (globalTableArn != other.globalTableArn) return false
        if (globalTableName != other.globalTableName) return false
        if (globalTableStatus != other.globalTableStatus) return false
        if (replicationGroup != other.replicationGroup) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dynamodb.model.GlobalTableDescription = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The creation time of the global table.
         */
        public var creationDateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The unique identifier of the global table.
         */
        public var globalTableArn: kotlin.String? = null
        /**
         * The global table name.
         */
        public var globalTableName: kotlin.String? = null
        /**
         * The current state of the global table:
         * + `CREATING` - The global table is being created.
         * + `UPDATING` - The global table is being updated.
         * + `DELETING` - The global table is being deleted.
         * + `ACTIVE` - The global table is ready for use.
         */
        public var globalTableStatus: aws.sdk.kotlin.services.dynamodb.model.GlobalTableStatus? = null
        /**
         * The Regions where the global table has replicas.
         */
        public var replicationGroup: List<ReplicaDescription>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dynamodb.model.GlobalTableDescription) : this() {
            this.creationDateTime = x.creationDateTime
            this.globalTableArn = x.globalTableArn
            this.globalTableName = x.globalTableName
            this.globalTableStatus = x.globalTableStatus
            this.replicationGroup = x.replicationGroup
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dynamodb.model.GlobalTableDescription = GlobalTableDescription(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
