// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dynamodb.model



public class ExecuteStatementResponse private constructor(builder: Builder) {
    /**
     * The capacity units consumed by an operation. The data returned includes the total provisioned throughput consumed, along with statistics for the table and any indexes involved in the operation. `ConsumedCapacity` is only returned if the request asked for it. For more information, see [Provisioned Throughput](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html) in the *Amazon DynamoDB Developer Guide*.
     */
    public val consumedCapacity: aws.sdk.kotlin.services.dynamodb.model.ConsumedCapacity? = builder.consumedCapacity
    /**
     * If a read operation was used, this property will contain the result of the read operation; a map of attribute names and their values. For the write operations this value will be empty.
     */
    public val items: List<Map<String, AttributeValue>>? = builder.items
    /**
     * The primary key of the item where the operation stopped, inclusive of the previous result set. Use this value to start a new operation, excluding this value in the new request. If `LastEvaluatedKey` is empty, then the "last page" of results has been processed and there is no more data to be retrieved. If `LastEvaluatedKey` is not empty, it does not necessarily mean that there is more data in the result set. The only way to know when you have reached the end of the result set is when `LastEvaluatedKey` is empty.
     */
    public val lastEvaluatedKey: Map<String, AttributeValue>? = builder.lastEvaluatedKey
    /**
     * If the response of a read request exceeds the response payload limit DynamoDB will set this value in the response. If set, you can use that this value in the subsequent request to get the remaining results.
     */
    public val nextToken: kotlin.String? = builder.nextToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dynamodb.model.ExecuteStatementResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ExecuteStatementResponse(")
        append("consumedCapacity=$consumedCapacity,")
        append("items=$items,")
        append("lastEvaluatedKey=$lastEvaluatedKey,")
        append("nextToken=$nextToken")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = consumedCapacity?.hashCode() ?: 0
        result = 31 * result + (items?.hashCode() ?: 0)
        result = 31 * result + (lastEvaluatedKey?.hashCode() ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ExecuteStatementResponse

        if (consumedCapacity != other.consumedCapacity) return false
        if (items != other.items) return false
        if (lastEvaluatedKey != other.lastEvaluatedKey) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dynamodb.model.ExecuteStatementResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The capacity units consumed by an operation. The data returned includes the total provisioned throughput consumed, along with statistics for the table and any indexes involved in the operation. `ConsumedCapacity` is only returned if the request asked for it. For more information, see [Provisioned Throughput](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/ProvisionedThroughputIntro.html) in the *Amazon DynamoDB Developer Guide*.
         */
        public var consumedCapacity: aws.sdk.kotlin.services.dynamodb.model.ConsumedCapacity? = null
        /**
         * If a read operation was used, this property will contain the result of the read operation; a map of attribute names and their values. For the write operations this value will be empty.
         */
        public var items: List<Map<String, AttributeValue>>? = null
        /**
         * The primary key of the item where the operation stopped, inclusive of the previous result set. Use this value to start a new operation, excluding this value in the new request. If `LastEvaluatedKey` is empty, then the "last page" of results has been processed and there is no more data to be retrieved. If `LastEvaluatedKey` is not empty, it does not necessarily mean that there is more data in the result set. The only way to know when you have reached the end of the result set is when `LastEvaluatedKey` is empty.
         */
        public var lastEvaluatedKey: Map<String, AttributeValue>? = null
        /**
         * If the response of a read request exceeds the response payload limit DynamoDB will set this value in the response. If set, you can use that this value in the subsequent request to get the remaining results.
         */
        public var nextToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dynamodb.model.ExecuteStatementResponse) : this() {
            this.consumedCapacity = x.consumedCapacity
            this.items = x.items
            this.lastEvaluatedKey = x.lastEvaluatedKey
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dynamodb.model.ExecuteStatementResponse = ExecuteStatementResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.dynamodb.model.ConsumedCapacity] inside the given [block]
         */
        public fun consumedCapacity(block: aws.sdk.kotlin.services.dynamodb.model.ConsumedCapacity.Builder.() -> kotlin.Unit) {
            this.consumedCapacity = aws.sdk.kotlin.services.dynamodb.model.ConsumedCapacity.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
