// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dynamodb.model



/**
 * Represents the input of a `CreateTable` operation.
 */
public class CreateTableRequest private constructor(builder: Builder) {
    /**
     * An array of attributes that describe the key schema for the table and indexes.
     */
    public val attributeDefinitions: List<AttributeDefinition>? = builder.attributeDefinitions
    /**
     * Controls how you are charged for read and write throughput and how you manage capacity. This setting can be changed later.
     * + `PROVISIONED` - We recommend using `PROVISIONED` for predictable workloads. `PROVISIONED` sets the billing mode to [Provisioned Mode](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.ProvisionedThroughput.Manual).
     * + `PAY_PER_REQUEST` - We recommend using `PAY_PER_REQUEST` for unpredictable workloads. `PAY_PER_REQUEST` sets the billing mode to [On-Demand Mode](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.OnDemand).
     */
    public val billingMode: aws.sdk.kotlin.services.dynamodb.model.BillingMode? = builder.billingMode
    /**
     * Indicates whether deletion protection is to be enabled (true) or disabled (false) on the table.
     */
    public val deletionProtectionEnabled: kotlin.Boolean? = builder.deletionProtectionEnabled
    /**
     * One or more global secondary indexes (the maximum is 20) to be created on the table. Each global secondary index in the array includes the following:
     * + `IndexName` - The name of the global secondary index. Must be unique only for this table.
     * + `KeySchema` - Specifies the key schema for the global secondary index.
     * + `Projection` - Specifies attributes that are copied (projected) from the table into the index. These are in addition to the primary key attributes and index key attributes, which are automatically projected. Each attribute specification is composed of:
     *    + `ProjectionType` - One of the following:
     *       + `KEYS_ONLY` - Only the index and primary keys are projected into the index.
     *       + `INCLUDE` - Only the specified table attributes are projected into the index. The list of projected attributes is in `NonKeyAttributes`.
     *       + `ALL` - All of the table attributes are projected into the index.
     *    + `NonKeyAttributes` - A list of one or more non-key attribute names that are projected into the secondary index. The total count of attributes provided in `NonKeyAttributes`, summed across all of the secondary indexes, must not exceed 100. If you project the same attribute into two different indexes, this counts as two distinct attributes when determining the total.
     * + `ProvisionedThroughput` - The provisioned throughput settings for the global secondary index, consisting of read and write capacity units.
     */
    public val globalSecondaryIndexes: List<GlobalSecondaryIndex>? = builder.globalSecondaryIndexes
    /**
     * Specifies the attributes that make up the primary key for a table or an index. The attributes in `KeySchema` must also be defined in the `AttributeDefinitions` array. For more information, see [Data Model](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataModel.html) in the *Amazon DynamoDB Developer Guide*.
     *
     * Each `KeySchemaElement` in the array is composed of:
     * + `AttributeName` - The name of this key attribute.
     * + `KeyType` - The role that the key attribute will assume:
     *    + `HASH` - partition key
     *    + `RANGE` - sort key
     *
     * The partition key of an item is also known as its *hash attribute*. The term "hash attribute" derives from the DynamoDB usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.
     *
     * The sort key of an item is also known as its *range attribute*. The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.
     *
     * For a simple primary key (partition key), you must provide exactly one element with a `KeyType` of `HASH`.
     *
     * For a composite primary key (partition key and sort key), you must provide exactly two elements, in this order: The first element must have a `KeyType` of `HASH`, and the second element must have a `KeyType` of `RANGE`.
     *
     * For more information, see [Working with Tables](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#WorkingWithTables.primary.key) in the *Amazon DynamoDB Developer Guide*.
     */
    public val keySchema: List<KeySchemaElement>? = builder.keySchema
    /**
     * One or more local secondary indexes (the maximum is 5) to be created on the table. Each index is scoped to a given partition key value. There is a 10 GB size limit per partition key value; otherwise, the size of a local secondary index is unconstrained.
     *
     * Each local secondary index in the array includes the following:
     * + `IndexName` - The name of the local secondary index. Must be unique only for this table.
     * + `KeySchema` - Specifies the key schema for the local secondary index. The key schema must begin with the same partition key as the table.
     * + `Projection` - Specifies attributes that are copied (projected) from the table into the index. These are in addition to the primary key attributes and index key attributes, which are automatically projected. Each attribute specification is composed of:
     *    + `ProjectionType` - One of the following:
     *       + `KEYS_ONLY` - Only the index and primary keys are projected into the index.
     *       + `INCLUDE` - Only the specified table attributes are projected into the index. The list of projected attributes is in `NonKeyAttributes`.
     *       + `ALL` - All of the table attributes are projected into the index.
     *    + `NonKeyAttributes` - A list of one or more non-key attribute names that are projected into the secondary index. The total count of attributes provided in `NonKeyAttributes`, summed across all of the secondary indexes, must not exceed 100. If you project the same attribute into two different indexes, this counts as two distinct attributes when determining the total.
     */
    public val localSecondaryIndexes: List<LocalSecondaryIndex>? = builder.localSecondaryIndexes
    /**
     * Represents the provisioned throughput settings for a specified table or index. The settings can be modified using the `UpdateTable` operation.
     *
     *  If you set BillingMode as `PROVISIONED`, you must specify this property. If you set BillingMode as `PAY_PER_REQUEST`, you cannot specify this property.
     *
     * For current minimum and maximum provisioned throughput values, see [Service, Account, and Table Quotas](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html) in the *Amazon DynamoDB Developer Guide*.
     */
    public val provisionedThroughput: aws.sdk.kotlin.services.dynamodb.model.ProvisionedThroughput? = builder.provisionedThroughput
    /**
     * Represents the settings used to enable server-side encryption.
     */
    public val sseSpecification: aws.sdk.kotlin.services.dynamodb.model.SseSpecification? = builder.sseSpecification
    /**
     * The settings for DynamoDB Streams on the table. These settings consist of:
     * + `StreamEnabled` - Indicates whether DynamoDB Streams is to be enabled (true) or disabled (false).
     * + `StreamViewType` - When an item in the table is modified, `StreamViewType` determines what information is written to the table's stream. Valid values for `StreamViewType` are:
     *    + `KEYS_ONLY` - Only the key attributes of the modified item are written to the stream.
     *    + `NEW_IMAGE` - The entire item, as it appears after it was modified, is written to the stream.
     *    + `OLD_IMAGE` - The entire item, as it appeared before it was modified, is written to the stream.
     *    + `NEW_AND_OLD_IMAGES` - Both the new and the old item images of the item are written to the stream.
     */
    public val streamSpecification: aws.sdk.kotlin.services.dynamodb.model.StreamSpecification? = builder.streamSpecification
    /**
     * The table class of the new table. Valid values are `STANDARD` and `STANDARD_INFREQUENT_ACCESS`.
     */
    public val tableClass: aws.sdk.kotlin.services.dynamodb.model.TableClass? = builder.tableClass
    /**
     * The name of the table to create.
     */
    public val tableName: kotlin.String? = builder.tableName
    /**
     * A list of key-value pairs to label the table. For more information, see [Tagging for DynamoDB](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Tagging.html).
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dynamodb.model.CreateTableRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateTableRequest(")
        append("attributeDefinitions=$attributeDefinitions,")
        append("billingMode=$billingMode,")
        append("deletionProtectionEnabled=$deletionProtectionEnabled,")
        append("globalSecondaryIndexes=$globalSecondaryIndexes,")
        append("keySchema=$keySchema,")
        append("localSecondaryIndexes=$localSecondaryIndexes,")
        append("provisionedThroughput=$provisionedThroughput,")
        append("sseSpecification=$sseSpecification,")
        append("streamSpecification=$streamSpecification,")
        append("tableClass=$tableClass,")
        append("tableName=$tableName,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attributeDefinitions?.hashCode() ?: 0
        result = 31 * result + (billingMode?.hashCode() ?: 0)
        result = 31 * result + (deletionProtectionEnabled?.hashCode() ?: 0)
        result = 31 * result + (globalSecondaryIndexes?.hashCode() ?: 0)
        result = 31 * result + (keySchema?.hashCode() ?: 0)
        result = 31 * result + (localSecondaryIndexes?.hashCode() ?: 0)
        result = 31 * result + (provisionedThroughput?.hashCode() ?: 0)
        result = 31 * result + (sseSpecification?.hashCode() ?: 0)
        result = 31 * result + (streamSpecification?.hashCode() ?: 0)
        result = 31 * result + (tableClass?.hashCode() ?: 0)
        result = 31 * result + (tableName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateTableRequest

        if (attributeDefinitions != other.attributeDefinitions) return false
        if (billingMode != other.billingMode) return false
        if (deletionProtectionEnabled != other.deletionProtectionEnabled) return false
        if (globalSecondaryIndexes != other.globalSecondaryIndexes) return false
        if (keySchema != other.keySchema) return false
        if (localSecondaryIndexes != other.localSecondaryIndexes) return false
        if (provisionedThroughput != other.provisionedThroughput) return false
        if (sseSpecification != other.sseSpecification) return false
        if (streamSpecification != other.streamSpecification) return false
        if (tableClass != other.tableClass) return false
        if (tableName != other.tableName) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dynamodb.model.CreateTableRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An array of attributes that describe the key schema for the table and indexes.
         */
        public var attributeDefinitions: List<AttributeDefinition>? = null
        /**
         * Controls how you are charged for read and write throughput and how you manage capacity. This setting can be changed later.
         * + `PROVISIONED` - We recommend using `PROVISIONED` for predictable workloads. `PROVISIONED` sets the billing mode to [Provisioned Mode](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.ProvisionedThroughput.Manual).
         * + `PAY_PER_REQUEST` - We recommend using `PAY_PER_REQUEST` for unpredictable workloads. `PAY_PER_REQUEST` sets the billing mode to [On-Demand Mode](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadWriteCapacityMode.html#HowItWorks.OnDemand).
         */
        public var billingMode: aws.sdk.kotlin.services.dynamodb.model.BillingMode? = null
        /**
         * Indicates whether deletion protection is to be enabled (true) or disabled (false) on the table.
         */
        public var deletionProtectionEnabled: kotlin.Boolean? = null
        /**
         * One or more global secondary indexes (the maximum is 20) to be created on the table. Each global secondary index in the array includes the following:
         * + `IndexName` - The name of the global secondary index. Must be unique only for this table.
         * + `KeySchema` - Specifies the key schema for the global secondary index.
         * + `Projection` - Specifies attributes that are copied (projected) from the table into the index. These are in addition to the primary key attributes and index key attributes, which are automatically projected. Each attribute specification is composed of:
         *    + `ProjectionType` - One of the following:
         *       + `KEYS_ONLY` - Only the index and primary keys are projected into the index.
         *       + `INCLUDE` - Only the specified table attributes are projected into the index. The list of projected attributes is in `NonKeyAttributes`.
         *       + `ALL` - All of the table attributes are projected into the index.
         *    + `NonKeyAttributes` - A list of one or more non-key attribute names that are projected into the secondary index. The total count of attributes provided in `NonKeyAttributes`, summed across all of the secondary indexes, must not exceed 100. If you project the same attribute into two different indexes, this counts as two distinct attributes when determining the total.
         * + `ProvisionedThroughput` - The provisioned throughput settings for the global secondary index, consisting of read and write capacity units.
         */
        public var globalSecondaryIndexes: List<GlobalSecondaryIndex>? = null
        /**
         * Specifies the attributes that make up the primary key for a table or an index. The attributes in `KeySchema` must also be defined in the `AttributeDefinitions` array. For more information, see [Data Model](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DataModel.html) in the *Amazon DynamoDB Developer Guide*.
         *
         * Each `KeySchemaElement` in the array is composed of:
         * + `AttributeName` - The name of this key attribute.
         * + `KeyType` - The role that the key attribute will assume:
         *    + `HASH` - partition key
         *    + `RANGE` - sort key
         *
         * The partition key of an item is also known as its *hash attribute*. The term "hash attribute" derives from the DynamoDB usage of an internal hash function to evenly distribute data items across partitions, based on their partition key values.
         *
         * The sort key of an item is also known as its *range attribute*. The term "range attribute" derives from the way DynamoDB stores items with the same partition key physically close together, in sorted order by the sort key value.
         *
         * For a simple primary key (partition key), you must provide exactly one element with a `KeyType` of `HASH`.
         *
         * For a composite primary key (partition key and sort key), you must provide exactly two elements, in this order: The first element must have a `KeyType` of `HASH`, and the second element must have a `KeyType` of `RANGE`.
         *
         * For more information, see [Working with Tables](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/WorkingWithTables.html#WorkingWithTables.primary.key) in the *Amazon DynamoDB Developer Guide*.
         */
        public var keySchema: List<KeySchemaElement>? = null
        /**
         * One or more local secondary indexes (the maximum is 5) to be created on the table. Each index is scoped to a given partition key value. There is a 10 GB size limit per partition key value; otherwise, the size of a local secondary index is unconstrained.
         *
         * Each local secondary index in the array includes the following:
         * + `IndexName` - The name of the local secondary index. Must be unique only for this table.
         * + `KeySchema` - Specifies the key schema for the local secondary index. The key schema must begin with the same partition key as the table.
         * + `Projection` - Specifies attributes that are copied (projected) from the table into the index. These are in addition to the primary key attributes and index key attributes, which are automatically projected. Each attribute specification is composed of:
         *    + `ProjectionType` - One of the following:
         *       + `KEYS_ONLY` - Only the index and primary keys are projected into the index.
         *       + `INCLUDE` - Only the specified table attributes are projected into the index. The list of projected attributes is in `NonKeyAttributes`.
         *       + `ALL` - All of the table attributes are projected into the index.
         *    + `NonKeyAttributes` - A list of one or more non-key attribute names that are projected into the secondary index. The total count of attributes provided in `NonKeyAttributes`, summed across all of the secondary indexes, must not exceed 100. If you project the same attribute into two different indexes, this counts as two distinct attributes when determining the total.
         */
        public var localSecondaryIndexes: List<LocalSecondaryIndex>? = null
        /**
         * Represents the provisioned throughput settings for a specified table or index. The settings can be modified using the `UpdateTable` operation.
         *
         *  If you set BillingMode as `PROVISIONED`, you must specify this property. If you set BillingMode as `PAY_PER_REQUEST`, you cannot specify this property.
         *
         * For current minimum and maximum provisioned throughput values, see [Service, Account, and Table Quotas](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html) in the *Amazon DynamoDB Developer Guide*.
         */
        public var provisionedThroughput: aws.sdk.kotlin.services.dynamodb.model.ProvisionedThroughput? = null
        /**
         * Represents the settings used to enable server-side encryption.
         */
        public var sseSpecification: aws.sdk.kotlin.services.dynamodb.model.SseSpecification? = null
        /**
         * The settings for DynamoDB Streams on the table. These settings consist of:
         * + `StreamEnabled` - Indicates whether DynamoDB Streams is to be enabled (true) or disabled (false).
         * + `StreamViewType` - When an item in the table is modified, `StreamViewType` determines what information is written to the table's stream. Valid values for `StreamViewType` are:
         *    + `KEYS_ONLY` - Only the key attributes of the modified item are written to the stream.
         *    + `NEW_IMAGE` - The entire item, as it appears after it was modified, is written to the stream.
         *    + `OLD_IMAGE` - The entire item, as it appeared before it was modified, is written to the stream.
         *    + `NEW_AND_OLD_IMAGES` - Both the new and the old item images of the item are written to the stream.
         */
        public var streamSpecification: aws.sdk.kotlin.services.dynamodb.model.StreamSpecification? = null
        /**
         * The table class of the new table. Valid values are `STANDARD` and `STANDARD_INFREQUENT_ACCESS`.
         */
        public var tableClass: aws.sdk.kotlin.services.dynamodb.model.TableClass? = null
        /**
         * The name of the table to create.
         */
        public var tableName: kotlin.String? = null
        /**
         * A list of key-value pairs to label the table. For more information, see [Tagging for DynamoDB](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Tagging.html).
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dynamodb.model.CreateTableRequest) : this() {
            this.attributeDefinitions = x.attributeDefinitions
            this.billingMode = x.billingMode
            this.deletionProtectionEnabled = x.deletionProtectionEnabled
            this.globalSecondaryIndexes = x.globalSecondaryIndexes
            this.keySchema = x.keySchema
            this.localSecondaryIndexes = x.localSecondaryIndexes
            this.provisionedThroughput = x.provisionedThroughput
            this.sseSpecification = x.sseSpecification
            this.streamSpecification = x.streamSpecification
            this.tableClass = x.tableClass
            this.tableName = x.tableName
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dynamodb.model.CreateTableRequest = CreateTableRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.dynamodb.model.ProvisionedThroughput] inside the given [block]
         */
        public fun provisionedThroughput(block: aws.sdk.kotlin.services.dynamodb.model.ProvisionedThroughput.Builder.() -> kotlin.Unit) {
            this.provisionedThroughput = aws.sdk.kotlin.services.dynamodb.model.ProvisionedThroughput.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.dynamodb.model.SseSpecification] inside the given [block]
         */
        public fun sseSpecification(block: aws.sdk.kotlin.services.dynamodb.model.SseSpecification.Builder.() -> kotlin.Unit) {
            this.sseSpecification = aws.sdk.kotlin.services.dynamodb.model.SseSpecification.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.dynamodb.model.StreamSpecification] inside the given [block]
         */
        public fun streamSpecification(block: aws.sdk.kotlin.services.dynamodb.model.StreamSpecification.Builder.() -> kotlin.Unit) {
            this.streamSpecification = aws.sdk.kotlin.services.dynamodb.model.StreamSpecification.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
