// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dynamodb.model



/**
 * Represents a new global secondary index to be added to an existing table.
 */
public class CreateGlobalSecondaryIndexAction private constructor(builder: Builder) {
    /**
     * The name of the global secondary index to be created.
     */
    public val indexName: kotlin.String = requireNotNull(builder.indexName) { "A non-null value must be provided for indexName" }
    /**
     * The key schema for the global secondary index.
     */
    public val keySchema: List<KeySchemaElement> = requireNotNull(builder.keySchema) { "A non-null value must be provided for keySchema" }
    /**
     * Represents attributes that are copied (projected) from the table into an index. These are in addition to the primary key attributes and index key attributes, which are automatically projected.
     */
    public val projection: aws.sdk.kotlin.services.dynamodb.model.Projection? = builder.projection
    /**
     * Represents the provisioned throughput settings for the specified global secondary index.
     *
     * For current minimum and maximum provisioned throughput values, see [Service, Account, and Table Quotas](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html) in the *Amazon DynamoDB Developer Guide*.
     */
    public val provisionedThroughput: aws.sdk.kotlin.services.dynamodb.model.ProvisionedThroughput? = builder.provisionedThroughput

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dynamodb.model.CreateGlobalSecondaryIndexAction = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateGlobalSecondaryIndexAction(")
        append("indexName=$indexName,")
        append("keySchema=$keySchema,")
        append("projection=$projection,")
        append("provisionedThroughput=$provisionedThroughput")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = indexName.hashCode()
        result = 31 * result + (keySchema.hashCode())
        result = 31 * result + (projection?.hashCode() ?: 0)
        result = 31 * result + (provisionedThroughput?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateGlobalSecondaryIndexAction

        if (indexName != other.indexName) return false
        if (keySchema != other.keySchema) return false
        if (projection != other.projection) return false
        if (provisionedThroughput != other.provisionedThroughput) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dynamodb.model.CreateGlobalSecondaryIndexAction = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the global secondary index to be created.
         */
        public var indexName: kotlin.String? = null
        /**
         * The key schema for the global secondary index.
         */
        public var keySchema: List<KeySchemaElement>? = null
        /**
         * Represents attributes that are copied (projected) from the table into an index. These are in addition to the primary key attributes and index key attributes, which are automatically projected.
         */
        public var projection: aws.sdk.kotlin.services.dynamodb.model.Projection? = null
        /**
         * Represents the provisioned throughput settings for the specified global secondary index.
         *
         * For current minimum and maximum provisioned throughput values, see [Service, Account, and Table Quotas](https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/Limits.html) in the *Amazon DynamoDB Developer Guide*.
         */
        public var provisionedThroughput: aws.sdk.kotlin.services.dynamodb.model.ProvisionedThroughput? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dynamodb.model.CreateGlobalSecondaryIndexAction) : this() {
            this.indexName = x.indexName
            this.keySchema = x.keySchema
            this.projection = x.projection
            this.provisionedThroughput = x.provisionedThroughput
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dynamodb.model.CreateGlobalSecondaryIndexAction = CreateGlobalSecondaryIndexAction(this)

        /**
         * construct an [aws.sdk.kotlin.services.dynamodb.model.Projection] inside the given [block]
         */
        public fun projection(block: aws.sdk.kotlin.services.dynamodb.model.Projection.Builder.() -> kotlin.Unit) {
            this.projection = aws.sdk.kotlin.services.dynamodb.model.Projection.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.dynamodb.model.ProvisionedThroughput] inside the given [block]
         */
        public fun provisionedThroughput(block: aws.sdk.kotlin.services.dynamodb.model.ProvisionedThroughput.Builder.() -> kotlin.Unit) {
            this.provisionedThroughput = aws.sdk.kotlin.services.dynamodb.model.ProvisionedThroughput.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (indexName == null) indexName = ""
            if (keySchema == null) keySchema = emptyList()
            return this
        }
    }
}
