// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dynamodb.model



/**
 * An ordered list of errors for each item in the request which caused the transaction to get cancelled. The values of the list are ordered according to the ordering of the `TransactWriteItems` request parameter. If no error occurred for the associated item an error with a Null code and Null message will be present.
 */
public class CancellationReason private constructor(builder: Builder) {
    /**
     * Status code for the result of the cancelled transaction.
     */
    public val code: kotlin.String? = builder.code
    /**
     * Item in the request which caused the transaction to get cancelled.
     */
    public val item: Map<String, AttributeValue>? = builder.item
    /**
     * Cancellation reason message description.
     */
    public val message: kotlin.String? = builder.message

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dynamodb.model.CancellationReason = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CancellationReason(")
        append("code=$code,")
        append("item=$item,")
        append("message=$message")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = code?.hashCode() ?: 0
        result = 31 * result + (item?.hashCode() ?: 0)
        result = 31 * result + (message?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CancellationReason

        if (code != other.code) return false
        if (item != other.item) return false
        if (message != other.message) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dynamodb.model.CancellationReason = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Status code for the result of the cancelled transaction.
         */
        public var code: kotlin.String? = null
        /**
         * Item in the request which caused the transaction to get cancelled.
         */
        public var item: Map<String, AttributeValue>? = null
        /**
         * Cancellation reason message description.
         */
        public var message: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dynamodb.model.CancellationReason) : this() {
            this.code = x.code
            this.item = x.item
            this.message = x.message
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dynamodb.model.CancellationReason = CancellationReason(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
