// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.dynamodb.model



/**
 * Represents the output of a `BatchWriteItem` operation.
 */
public class BatchWriteItemResponse private constructor(builder: Builder) {
    /**
     * The capacity units consumed by the entire `BatchWriteItem` operation.
     *
     * Each element consists of:
     * + `TableName` - The table that consumed the provisioned throughput.
     * + `CapacityUnits` - The total number of capacity units consumed.
     */
    public val consumedCapacity: List<ConsumedCapacity>? = builder.consumedCapacity
    /**
     * A list of tables that were processed by `BatchWriteItem` and, for each table, information about any item collections that were affected by individual `DeleteItem` or `PutItem` operations.
     *
     * Each entry consists of the following subelements:
     * + `ItemCollectionKey` - The partition key value of the item collection. This is the same as the partition key value of the item.
     * + `SizeEstimateRangeGB` - An estimate of item collection size, expressed in GB. This is a two-element array containing a lower bound and an upper bound for the estimate. The estimate includes the size of all the items in the table, plus the size of all attributes projected into all of the local secondary indexes on the table. Use this estimate to measure whether a local secondary index is approaching its size limit.The estimate is subject to change over time; therefore, do not rely on the precision or accuracy of the estimate.
     */
    public val itemCollectionMetrics: Map<String, List<ItemCollectionMetrics>>? = builder.itemCollectionMetrics
    /**
     * A map of tables and requests against those tables that were not processed. The `UnprocessedItems` value is in the same form as `RequestItems`, so you can provide this value directly to a subsequent `BatchWriteItem` operation. For more information, see `RequestItems` in the Request Parameters section.
     *
     * Each `UnprocessedItems` entry consists of a table name and, for that table, a list of operations to perform (`DeleteRequest` or `PutRequest`).
     * + `DeleteRequest` - Perform a `DeleteItem` operation on the specified item. The item to be deleted is identified by a `Key` subelement:
     *    + `Key` - A map of primary key attribute values that uniquely identify the item. Each entry in this map consists of an attribute name and an attribute value.
     * + `PutRequest` - Perform a `PutItem` operation on the specified item. The item to be put is identified by an `Item` subelement:
     *    + `Item` - A map of attributes and their values. Each entry in this map consists of an attribute name and an attribute value. Attribute values must not be null; string and binary type attributes must have lengths greater than zero; and set type attributes must not be empty. Requests that contain empty values will be rejected with a `ValidationException` exception.If you specify any attributes that are part of an index key, then the data types for those attributes must match those of the schema in the table's attribute definition.
     *
     * If there are no unprocessed items remaining, the response contains an empty `UnprocessedItems` map.
     */
    public val unprocessedItems: Map<String, List<WriteRequest>>? = builder.unprocessedItems

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.dynamodb.model.BatchWriteItemResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BatchWriteItemResponse(")
        append("consumedCapacity=$consumedCapacity,")
        append("itemCollectionMetrics=$itemCollectionMetrics,")
        append("unprocessedItems=$unprocessedItems")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = consumedCapacity?.hashCode() ?: 0
        result = 31 * result + (itemCollectionMetrics?.hashCode() ?: 0)
        result = 31 * result + (unprocessedItems?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BatchWriteItemResponse

        if (consumedCapacity != other.consumedCapacity) return false
        if (itemCollectionMetrics != other.itemCollectionMetrics) return false
        if (unprocessedItems != other.unprocessedItems) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.dynamodb.model.BatchWriteItemResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The capacity units consumed by the entire `BatchWriteItem` operation.
         *
         * Each element consists of:
         * + `TableName` - The table that consumed the provisioned throughput.
         * + `CapacityUnits` - The total number of capacity units consumed.
         */
        public var consumedCapacity: List<ConsumedCapacity>? = null
        /**
         * A list of tables that were processed by `BatchWriteItem` and, for each table, information about any item collections that were affected by individual `DeleteItem` or `PutItem` operations.
         *
         * Each entry consists of the following subelements:
         * + `ItemCollectionKey` - The partition key value of the item collection. This is the same as the partition key value of the item.
         * + `SizeEstimateRangeGB` - An estimate of item collection size, expressed in GB. This is a two-element array containing a lower bound and an upper bound for the estimate. The estimate includes the size of all the items in the table, plus the size of all attributes projected into all of the local secondary indexes on the table. Use this estimate to measure whether a local secondary index is approaching its size limit.The estimate is subject to change over time; therefore, do not rely on the precision or accuracy of the estimate.
         */
        public var itemCollectionMetrics: Map<String, List<ItemCollectionMetrics>>? = null
        /**
         * A map of tables and requests against those tables that were not processed. The `UnprocessedItems` value is in the same form as `RequestItems`, so you can provide this value directly to a subsequent `BatchWriteItem` operation. For more information, see `RequestItems` in the Request Parameters section.
         *
         * Each `UnprocessedItems` entry consists of a table name and, for that table, a list of operations to perform (`DeleteRequest` or `PutRequest`).
         * + `DeleteRequest` - Perform a `DeleteItem` operation on the specified item. The item to be deleted is identified by a `Key` subelement:
         *    + `Key` - A map of primary key attribute values that uniquely identify the item. Each entry in this map consists of an attribute name and an attribute value.
         * + `PutRequest` - Perform a `PutItem` operation on the specified item. The item to be put is identified by an `Item` subelement:
         *    + `Item` - A map of attributes and their values. Each entry in this map consists of an attribute name and an attribute value. Attribute values must not be null; string and binary type attributes must have lengths greater than zero; and set type attributes must not be empty. Requests that contain empty values will be rejected with a `ValidationException` exception.If you specify any attributes that are part of an index key, then the data types for those attributes must match those of the schema in the table's attribute definition.
         *
         * If there are no unprocessed items remaining, the response contains an empty `UnprocessedItems` map.
         */
        public var unprocessedItems: Map<String, List<WriteRequest>>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.dynamodb.model.BatchWriteItemResponse) : this() {
            this.consumedCapacity = x.consumedCapacity
            this.itemCollectionMetrics = x.itemCollectionMetrics
            this.unprocessedItems = x.unprocessedItems
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.dynamodb.model.BatchWriteItemResponse = BatchWriteItemResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
